#include "transfertitledelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/paths.h"
#include <QPainter>

TransferTitleDelegate::TransferTitleDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferTitleDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect imageRect = option.rect;
    imageRect.setSize(QSize(36, 36));
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 12));

    QString serviceIcon = index.data(TransferModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("filemanager_unknown_file").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage(ICON_PATH_MAEMO_5 + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 45);
    textRect.setRight(textRect.right() - 5);

    QFont font;
    font.setPixelSize(20);

    painter->setFont(font);
    painter->drawText(textRect, Qt::AlignVCenter, index.data(TransferModel::FileNameRole).toString());
    painter->restore();
}

QSize TransferTitleDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 60);
}
