#ifndef TRANSFERSELECTIONWINDOW_H
#define TRANSFERSELECTIONWINDOW_H

#include "../shared/enums.h"
#include <QMainWindow>

class Session;
class QModelIndex;

class TransferSelectionWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit TransferSelectionWindow(Session *session, const QString &title, const QString &buttonText, const char* slot, QWidget *parent = 0);
    ~TransferSelectionWindow();
    
private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void resumeTransfers();
    void pauseTransfers();
    void cancelTransfers();
    void showTransferCategoryDialog();
    void showTransferPriorityDialog();
    void showMoveTransfersDialog();
    void setTransferCategories(const QString &category);
    void setTransferPriorities(Transfers::Priority priority);
    void moveTransfers(int row);

signals:
    void accepted();

private:
    Session *m_session;
};

#endif // TRANSFERSELECTIONWINDOW_H
