#ifndef TRANSFERMOVEDIALOG_H
#define TRANSFERMOVEDIALOG_H

#include <QDialog>

class Session;
class QListView;
class QModelIndex;

class TransferMoveDialog : public QDialog
{
    Q_OBJECT

public:
    explicit TransferMoveDialog(Session *session, QWidget *parent = 0);
    int currentValue() const;
    void setValue(int value);
    
private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void valueChanged(int value);

private:
    Session *m_session;
    QListView *m_listView;
};

#endif // TRANSFERMOVEDIALOG_H
