#ifndef TRANSFERDETAILSDIALOG_H
#define TRANSFERDETAILSDIALOG_H

#include "../shared/transferitem.h"
#include <QDialog>

class Session;
class QLabel;
class QLineEdit;

class TransferDetailsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit TransferDetailsDialog(Session *session, QSharedPointer<TransferItem> transfer, QWidget *parent = 0);

private slots:
    void onTransferStatusChanged(Transfers::Status status);
    void onTransferStatusInfoChanged(const QString &info);
    void onTransferSizeChanged(qint64 size);
    void onTransferProgressChanged(int progress);
    void onTransferSpeedChanged(double speed);
    void onFileNameTextChanged(const QString &text);
    void setTransferFileName();
    void onPauseResumeClicked();
    void cancelTransfer();

private:
    Session *m_session;
    QSharedPointer<TransferItem> m_transfer;
    QLabel *m_statusLabel;
    QLabel *m_statusIcon;
    QLabel *m_infoLabel;
    QLabel *m_sizeLabel;
    QLabel *m_progressLabel;
    QLabel *m_speedLabel;
    QLineEdit *m_nameEdit;
    QPushButton *m_nameButton;
    QPushButton *m_pauseResumeButton;
    QPushButton *m_cancelButton;
};

#endif // TRANSFERDETAILSDIALOG_H
