#include "transfercategorydialog.h"
#include "textlistdelegate.h"
#include "../shared/session.h"
#include "../shared/categoriesmodel.h"
#include <QListView>
#include <QGridLayout>

TransferCategoryDialog::TransferCategoryDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_model(new CategoriesModel(m_session, this)),
    m_listView(new QListView(this))
{
    this->setWindowTitle(tr("Category"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_listView, 0, 0);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(CategoriesModel::NameRole, Qt::AlignCenter, m_listView));

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

void TransferCategoryDialog::setValue(const QString &value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->index(i, 0).data(CategoriesModel::NameRole).toString() == value;

        if (found) {
            m_listView->setCurrentIndex(m_model->index(i, 0));
        }

        i++;
    }

    if (!found) {
        m_listView->setCurrentIndex(m_model->index(0, 0));
    }
}

QString TransferCategoryDialog::currentValue() const {
    return m_listView->currentIndex().data(CategoriesModel::NameRole).toString();
}

void TransferCategoryDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(index.data(CategoriesModel::NameRole).toString());
    this->accept();
}
