#include "serviceaccountsdialog.h"
#include "editserviceaccountdialog.h"
#include "servicenamedelegate.h"
#include "servicepassworddelegate.h"
#include "serviceusernamedelegate.h"
#include "../shared/paths.h"
#include "../shared/session.h"
#include "../shared/serviceaccountsmodel.h"
#include <QTreeView>
#include <QMenu>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

ServiceAccountsDialog::ServiceAccountsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_model(new ServiceAccountsModel(m_session, this)),
    m_treeView(new QTreeView(this)),
    m_contextMenu(new QMenu(this))
{
    this->setWindowTitle(tr("Service accounts"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_treeView, 0, 0);

    m_contextMenu->addAction(tr("Remove"), this, SLOT(removeAccount()));

    m_treeView->setModel(m_model);
    m_treeView->setItemDelegateForColumn(0, new ServiceNameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(1, new ServiceUsernameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(2, new ServicePasswordDelegate(m_treeView));
    m_treeView->setRootIsDecorated(false);
    m_treeView->setSelectionBehavior(QTreeView::SelectRows);
    m_treeView->setContextMenuPolicy(Qt::CustomContextMenu);
    m_treeView->setEditTriggers(QTreeView::NoEditTriggers);
    m_treeView->setExpandsOnDoubleClick(false);
    m_treeView->setItemsExpandable(false);
    m_treeView->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_treeView->setColumnWidth(0, 300);
    m_treeView->setColumnWidth(1, 300);

    this->connect(m_treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_treeView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void ServiceAccountsDialog::onItemClicked(const QModelIndex &index) {
    EditServiceAccountDialog *dialog = new EditServiceAccountDialog(m_session, this);
    dialog->setAccount(ICON_PATH_MAEMO_5 + index.data(ServiceAccountsModel::ServiceIconRole).toString(),
                       index.data(ServiceAccountsModel::ServiceNameRole).toString(),
                       index.data(ServiceAccountsModel::UsernameRole).toString(),
                       index.data(ServiceAccountsModel::PasswordRole).toString());

    dialog->open();
    this->connect(dialog, SIGNAL(addAccount(QString,QString,QString)), this, SLOT(addAccount(QString,QString,QString)));
}

void ServiceAccountsDialog::showContextMenu(const QPoint &pos) {
    if (m_treeView->currentIndex().isValid()) {
        m_contextMenu->popup(mapToGlobal(pos));
    }
}

void ServiceAccountsDialog::addAccount(const QString &serviceName, const QString &username, const QString &password) {
    if (m_session->database()->addAccount(serviceName, username, password)) {
        m_model->loadAccounts();
    }
}

void ServiceAccountsDialog::removeAccount() {
    if (m_treeView->currentIndex().isValid()) {
        if (m_session->database()->removeAccount(m_treeView->currentIndex().data(ServiceAccountsModel::ServiceNameRole).toString())) {
            m_model->loadAccounts();
        }
    }
}
