#ifndef PLUGINSETTINGSSELECTOR_H
#define PLUGINSETTINGSSELECTOR_H

#include <QMaemo5ValueButton>

#include "../shared/selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class PluginSettingsSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit PluginSettingsSelector(const QString &text, QWidget *parent = 0);
    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }
    inline SelectionModel* model() const { return m_model; }

public slots:
    void setModel(SelectionModel *model);
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onSelected();

private:
    QString m_key;
    QVariant m_default;
    SelectionModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // PLUGINSETTINGSSELECTOR_H
