#ifndef NETWORKPROXYDIALOG_H
#define NETWORKPROXYDIALOG_H

#include <QDialog>

class QCheckBox;
class QLineEdit;
class Session;
class NetworkProxyTypeSelector;

class NetworkProxyDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NetworkProxyDialog(Session *session, QWidget *parent = 0);

private:
    void loadSettings();

private slots:
    void saveSettings();
    void onProxyCheckboxToggled(bool checked);
    
private:
    Session *m_session;
    QCheckBox *m_proxyCheckbox;
    QWidget *m_proxyWidget;
    NetworkProxyTypeSelector *m_proxyTypeSelector;
    QLineEdit *m_hostEdit;
    QLineEdit *m_portEdit;
    QLineEdit *m_userEdit;
    QLineEdit *m_passEdit;
};

#endif // NETWORKPROXYDIALOG_H
