#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "../shared/enums.h"
#include <QMainWindow>

class Session;
class CheckUrlsDialog;
class TreeView;
class QMenu;
class QModelIndex;
class QLineEdit;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(Session *session, QWidget *parent = 0);    

private slots:
    void onUrlTextChanged(const QString &text);
    void showContextMenu(const QPoint &pos);
    void moveTransfer(int row);
    void pauseResumeTransfer();
    void cancelTransfer();
    void setTransferSaveAsAudio();
    void setTransferPriority(Transfers::Priority priority);
    void addTransferFromUrlEdit();
    void showAddUrlsDialog();
    void showTextFileDialog();
    void showAboutDialog();
    void showSettingsDialog();
    void showMoveTransferDialog();
    void showTransferPriorityDialog();
    void showTransferCategoryDialog();
    void showTransferDetailsDialog(const QModelIndex &index);
    void setTransferCategory(const QString &category);
    void moveSelectedTransfers();
    void resumeSelectedTransfers();
    void pauseSelectedTransfers();
    void cancelSelectedTransfers();
    void setCategoryOfSelectedTransfers();
    void setPriorityOfSelectedTransfers();
    
private:
    Session *m_session;
    QLineEdit *m_urlEdit;
    QAction *m_addButton;
    TreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_contextSaveAsAudioAction;
    QAction *m_contextPauseResumeAction;
    QAction *m_contextCancelAction;
    CheckUrlsDialog *m_checkDialog;
};

#endif // MAINWINDOW_H
