#include "decaptchausernamedelegate.h"
#include "../shared/decaptchaaccountsmodel.h"
#include <QPainter>

DecaptchaUsernameDelegate::DecaptchaUsernameDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void DecaptchaUsernameDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(DecaptchaAccountsModel::UsernameRole).toString());
}

QSize DecaptchaUsernameDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 60);
}
