#include "decaptchanamedelegate.h"
#include "../shared/decaptchaaccountsmodel.h"
#include "../shared/paths.h"
#include <QPainter>

DecaptchaNameDelegate::DecaptchaNameDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void DecaptchaNameDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect imageRect = option.rect;
    imageRect.setSize(QSize(36, 36));
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 12));

    QString serviceIcon = index.data(DecaptchaAccountsModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("unknown").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage(ICON_PATH_MAEMO_5 + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 46);
    textRect.setRight(textRect.right() - 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(DecaptchaAccountsModel::ServiceNameRole).toString());
}

QSize DecaptchaNameDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 60);
}
