#include "transfercategorydelegate.h"
#include "../shared/transfermodel.h"
#include <QPainter>

TransferCategoryDelegate::TransferCategoryDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferCategoryDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if (index.data(TransferModel::SelectedRole).toBool()) {
        painter->fillRect(option.rect, Qt::cyan);
    }
    else if (index.data(TransferModel::EnteredRole).toBool()) {
        painter->fillRect(option.rect, Qt::lightGray);
    }

    painter->drawText(option.rect, Qt::AlignCenter, index.data(TransferModel::CategoryRole).toString());
}

QSize TransferCategoryDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
