#include "pluginsettingsspinbox.h"
#include <QSettings>

PluginSettingsSpinbox::PluginSettingsSpinbox(QWidget *parent) :
    QSpinBox(parent)
{
}

void PluginSettingsSpinbox::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsSpinbox::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsSpinbox::load() {
    int value = QSettings("QDL", "QDL").value(this->key(), this->defaultValue()).toInt();
    this->setValue(value);
    this->connect(this, SIGNAL(valueChanged(int)), this, SLOT(onValueChanged(int)));
}

void PluginSettingsSpinbox::onValueChanged(int value) {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), value);
    }
}
