#ifndef DOWNLOADSETTINGSTAB_H
#define DOWNLOADSETTINGSTAB_H

#include "../shared/session.h"
#include <QWidget>

class QLineEdit;
class QCheckBox;
class QSpinBox;
class QComboBox;

class DownloadSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit DownloadSettingsTab(Session *session, QWidget *parent = 0);

public slots:
    void saveSettings();

private:
    void loadSettings();

private slots:
    void showFileDialog();
    void onProxyCheckboxToggled(bool checked);
    
private:
    Session *m_session;
    QLineEdit *m_pathEdit;
    QCheckBox *m_statusCheckbox;
    QSpinBox *m_concurrentSpinbox;
    QCheckBox *m_clipboardCheckbox;
    QCheckBox *m_extractCheckbox;
    QCheckBox *m_deleteCheckbox;
    QCheckBox *m_proxyCheckbox;
    QComboBox *m_proxyTypeCombobox;
    QLineEdit *m_proxyHostEdit;
    QLineEdit *m_proxyPortEdit;
    QLineEdit *m_proxyUserEdit;
    QLineEdit *m_proxyPassEdit;
};

#endif // DOWNLOADSETTINGSTAB_H
