#include "categorysettingstab.h"
#include "categorynamedelegate.h"
#include "categorypathdelegate.h"
#include <QGridLayout>
#include <QLabel>
#include <QFileDialog>
#include <QDesktopServices>

CategorySettingsTab::CategorySettingsTab(Session *session, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(new CategoriesModel(m_session, this)),
    m_treeView(new QTreeView(this)),
    m_editButton(new QPushButton(tr("Edit"), this)),
    m_removeButton(new QPushButton(tr("Remove"), this)),
    m_nameEdit(new QLineEdit(this)),
    m_pathEdit(new QLineEdit(this)),
    m_browseButton(new QPushButton(tr("Browse"), this)),
    m_doneButton(new QPushButton(tr("OK"), this))
{
    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_treeView, 0, 0, 3, 4);
    grid->addWidget(m_editButton, 0, 4, Qt::AlignTop);
    grid->addWidget(m_removeButton, 1, 4, Qt::AlignTop);
    grid->addItem(new QSpacerItem(10, 10, QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 4);
    grid->addWidget(new QLabel(tr("Add/edit category"), this), 3, 0);
    grid->addWidget(new QLabel(QString("%1:").arg(tr("Name")), this), 4, 0);
    grid->addWidget(m_nameEdit, 4, 1);
    grid->addWidget(new QLabel(QString("%1:").arg(tr("Download path")), this), 5, 0);
    grid->addWidget(m_pathEdit, 5, 1);
    grid->addWidget(m_browseButton, 5, 2);
    grid->addWidget(m_doneButton, 6, 0);

    m_editButton->setEnabled(false);
    m_removeButton->setEnabled(false);
    m_doneButton->setEnabled(false);

    m_treeView->setModel(m_model);
    m_treeView->setItemDelegateForColumn(0, new CategoryNameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(1, new CategoryPathDelegate(m_treeView));
    m_treeView->setRootIsDecorated(false);
    m_treeView->setSelectionBehavior(QTreeView::SelectRows);
    m_treeView->setEditTriggers(QTreeView::NoEditTriggers);
    m_treeView->setExpandsOnDoubleClick(false);
    m_treeView->setItemsExpandable(false);

    this->connect(m_treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_editButton, SIGNAL(clicked()), this, SLOT(editCategory()));
    this->connect(m_doneButton, SIGNAL(clicked()), this, SLOT(addCategory()));
    this->connect(m_removeButton, SIGNAL(clicked()), this, SLOT(removeCategory()));
    this->connect(m_browseButton, SIGNAL(clicked()), this, SLOT(showFolderDialog()));
    this->connect(m_nameEdit, SIGNAL(textChanged(QString)), this, SLOT(onCategoryEditChanged()));
    this->connect(m_pathEdit, SIGNAL(textChanged(QString)), this, SLOT(onCategoryEditChanged()));
}

void CategorySettingsTab::onItemClicked(const QModelIndex &index) {
    Q_UNUSED(index)

    m_editButton->setEnabled(true);
    m_removeButton->setEnabled(true);
}

void CategorySettingsTab::addCategory() {
    m_model->addCategory(m_nameEdit->text(), m_pathEdit->text());

    m_nameEdit->clear();
    m_pathEdit->clear();
}

void CategorySettingsTab::removeCategory() {
    QModelIndex index = m_treeView->currentIndex();

    if (index.isValid()) {
        m_model->removeCategory(index.row());
    }
}

void CategorySettingsTab::editCategory() {
    QModelIndex index = m_treeView->currentIndex();

    if (index.isValid()) {
        m_nameEdit->setText(index.data(CategoriesModel::NameRole).toString());
        m_pathEdit->setText(index.data(CategoriesModel::PathRole).toString());
    }
}

void CategorySettingsTab::showFolderDialog() {
    QString currentPath = m_pathEdit->text().isEmpty() ? QDesktopServices::storageLocation(QDesktopServices::HomeLocation) : m_pathEdit->text();
    QString path = QFileDialog::getExistingDirectory(this, tr("Download path"), currentPath);

    if (!path.isEmpty()) {
        m_pathEdit->setText(path);
    }
}

void CategorySettingsTab::onCategoryEditChanged() {
    m_doneButton->setEnabled((!m_nameEdit->text().isEmpty()) && (!m_pathEdit->text().isEmpty()));
}
