#include "categorypathdelegate.h"
#include "../shared/categoriesmodel.h"
#include <QPainter>

CategoryPathDelegate::CategoryPathDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void CategoryPathDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->drawText(option.rect, Qt::AlignVCenter, index.data(CategoriesModel::PathRole).toString());
}

QSize CategoryPathDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 25);
}
