#ifndef CAPTCHASETTINGSTAB_H
#define CAPTCHASETTINGSTAB_H

#include "../shared/session.h"
#include "../shared/decaptchaaccountsmodel.h"
#include <QWidget>

class QTreeView;
class QPushButton;
class QLineEdit;
class QCheckBox;

class CaptchaSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit CaptchaSettingsTab(Session *session, QWidget *parent = 0);

private slots:
    void onItemClicked(const QModelIndex &index);
    void addAccount();
    void removeAccount();
    void editAccount();
    void onAccountEditChanged();
    void onCheckboxClicked(bool checked);

private:
    Session *m_session;
    DecaptchaAccountsModel *m_model;
    QTreeView *m_treeView;
    QPushButton *m_addButton;
    QPushButton *m_editButton;
    QPushButton *m_removeButton;
    QLineEdit *m_nameEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_doneButton;
    QCheckBox *m_checkbox;
};

#endif // CAPTCHASETTINGSTAB_H
