#ifndef ACCOUNTSETTINGSTAB_H
#define ACCOUNTSETTINGSTAB_H

#include "../shared/session.h"
#include "../shared/serviceaccountsmodel.h"
#include <QWidget>
#include <QTreeView>
#include <QPushButton>
#include <QLineEdit>

class AccountSettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit AccountSettingsTab(Session *session, QWidget *parent = 0);

private slots:
    void onItemClicked(const QModelIndex &index);
    void addAccount();
    void removeAccount();
    void editAccount();
    void onAccountEditChanged();

private:
    Session *m_session;
    ServiceAccountsModel *m_model;
    QTreeView *m_treeView;
    QPushButton *m_addButton;
    QPushButton *m_editButton;
    QPushButton *m_removeButton;
    QLineEdit *m_nameEdit;
    QLineEdit *m_passEdit;
    QPushButton *m_doneButton;
};

#endif // ACCOUNTSETTINGSTAB_H
