#include "aboutdialog.h"
#include "../shared/utils.h"
#include <QDesktopServices>
#include <QUrl>
#include <QLabel>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent)
{
    this->setWindowTitle(tr("About QDL"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    QLabel *icon = new QLabel(this);
    icon->setPixmap(QPixmap(":/qdl64.png"));
    QLabel *title = new QLabel(QString("<b><font size='40'>QDL %1</font></b>").arg(Utils::versionNumberString()), this);
    QLabel *description = new QLabel("A user-friendly download manager.<br><br>&copy; Stuart Howarth 2012-2013", this);
    description->setWordWrap(true);
    QDialogButtonBox *buttonBox = new QDialogButtonBox(Qt::Horizontal, this);
    QPushButton *donateButton = new QPushButton(QIcon::fromTheme("help-donate"), tr("Donate"), this);
    QPushButton *bugButton = new QPushButton(QIcon::fromTheme("tools-report-bug"), tr("Report bug"), this);
    QPushButton *closeButton = new QPushButton(QIcon::fromTheme("dialog-close"), tr("Close"), this);
    buttonBox->addButton(donateButton, QDialogButtonBox::ActionRole);
    buttonBox->addButton(bugButton, QDialogButtonBox::ActionRole);
    buttonBox->addButton(closeButton, QDialogButtonBox::AcceptRole);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(icon, 0, 0);
    grid->addWidget(title, 0, 1);
    grid->addWidget(description, 1, 0, 1, 2);
    grid->addWidget(buttonBox, 2, 0, 1, 2);

    this->connect(donateButton, SIGNAL(clicked()), this, SLOT(donate()));
    this->connect(bugButton, SIGNAL(clicked()), this, SLOT(reportBug()));
    this->connect(closeButton, SIGNAL(clicked()), this, SLOT(accept()));
}

void AboutDialog::donate() {
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=QDL&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted"));
    this->accept();
}

void AboutDialog::reportBug() {
    QDesktopServices::openUrl(QUrl("mailto:stuhowarth77@gmail.com?subject=QDL"));
    this->accept();
}
