import QtQuick 1.1
import com.nokia.symbian 1.1
import com.marxian.items 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function addUrlFromInput(url) {
        UrlChecker.addUrlToQueue(url);
        urlInput.text = "";
    }

    function showTransferDetails(index) {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("TransferDetailsDialog.qml"), pageStack);
        dialog.transfer = TransferModel.getTransferForQML(index);
        dialog.open();
    }

    function showAboutDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("AboutDialog.qml"), pageStack);
        dialog.open();
    }

    function showAddUrlsDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("AddUrlsDialog.qml"), pageStack);
        dialog.open();
    }

    function showFileBrowserDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), pageStack);
        dialog.showFiles = true;
        dialog.startFolder = "/home/user/MyDocs/";
        dialog.open();
        dialog.fileChosen.connect(UrlChecker.importUrlsFromTextFile);
    }

    function openMenu() {
        if (TransferModel.count == 0) {
            menu.open();
        }
        else if (TransferModel.rowsSelected) {
            menu3.open();
        }
        else {
            menu2.open();
        }
    }

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolButton {
            iconSource: "qrc:/close.png"
            onClicked: Qt.quit()
        }

        ToolButton {
            iconSource: "toolbar-settings"
            onClicked: pageStack.push(Qt.resolvedUrl("SettingsPage.qml"))
        }

        ToolButton {
            iconSource: "qrc:/contact.png"
            onClicked: pageStack.push(Qt.resolvedUrl("AccountsPage.qml"))
        }

        ToolButton {
            iconSource: "toolbar-view-menu"
            onClicked: root.openMenu()
        }
    }

    Menu {
        id: menu

        MenuLayout {

            MenuItem {
                text: qsTr("Add URLs")
                onClicked: root.showAddUrlsDialog()
            }

            MenuItem {
                text: qsTr("Import URLs")
                onClicked: root.showFileBrowserDialog()
            }

            MenuItem {
                text: qsTr("About")
                onClicked: root.showAboutDialog()
            }
        }
    }

    Menu {
        id: menu2

        MenuLayout {

            MenuItem {
                text: qsTr("Select all")
                onClicked: TransferModel.selectAllRows()
            }

            MenuItem {
                text: qsTr("Add URLs")
                onClicked: root.showAddUrlsDialog()
            }

            MenuItem {
                text: qsTr("Import URLs")
                onClicked: root.showFileBrowserDialog()
            }

            MenuItem {
                text: qsTr("About")
                onClicked: root.showAboutDialog()
            }
        }
    }

    Menu {
        id: menu3

        MenuLayout {

            MenuItem {
                text: qsTr("Select none")
                onClicked: TransferModel.clearSelectedRows()
            }

            MenuItem {
                text: qsTr("Pause")
                onClicked: {
                    TransferModel.pauseSelectedTransfers();
                    TransferModel.clearSelectedRows();
                }
            }

            MenuItem {
                text: qsTr("Resume")
                onClicked: {
                    TransferModel.resumeSelectedTransfers();
                    TransferModel.clearSelectedRows();
                }
            }

            MenuItem {
                text: qsTr("Cancel")
                onClicked: {
                    TransferModel.cancelSelectedTransfers();
                    TransferModel.clearSelectedRows();
                }
            }
        }
    }

    TextFieldBox {
        id: urlInput

        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
        }

        z: 1000
        placeholderText: qsTr("Add URL")
        onAccepted: root.addUrlFromInput(text)
        enabled: view.visible
    }

    ListView {
        id: view

        anchors {
            top: urlInput.bottom
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }

        cacheBuffer: 1000
        model: TransferModel
        delegate: TransferDelegate {
            onClicked: TransferModel.rowsSelected ? TransferModel.toggleRowSelected(index) : root.showTransferDetails(index)
            onPressAndHold: TransferModel.toggleRowSelected(index)
        }

        visible: (!urlCheckInfo.visible) && (!progressInfo.visible)
    }

    ScrollDecorator {
        flickableItem: view
    }

    Label {
        anchors.centerIn: parent
        font {
            bold: true
            pixelSize: 32
        }

        color: "#4d4d4d"
        text: qsTr("No downloads queued")
        visible: (TransferModel.count == 0) && (view.visible)
    }

    UrlCheckInfo {
        id: urlCheckInfo

        anchors {
            top: urlInput.bottom
            topMargin: 10
            left: parent.left
            right: parent.right
            bottom: parent.bottom
            bottomMargin: 10
        }

        visible: false
    }

    ProgressInfo {
        id: progressInfo

        anchors {
            left: parent.left
            leftMargin: 50
            right: parent.right
            rightMargin: 50
            verticalCenter: parent.verticalCenter
        }

        visible: false
    }
}
