import QtQuick 1.1
import com.nokia.meego 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: {
                Settings.networkProxyPassword = passwordEdit.text;
                Settings.setNetworkProxy();
                appWindow.pageStack.pop();
            }
        }
    }

    Flickable {
        id: flicker

        anchors.fill: parent
        contentHeight: column.height

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            TitleHeader {
                title: qsTr("Other")
            }

            SelectionItem {
                id: orientationSelector

                title: qsTr("Screen orientation")
                subTitle: Settings.screenOrientationString
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("OrientationSelectionDialog.qml"), appWindow.pageStack);
                    dialog.open();
                }
            }

            SwitchItem {
                id: clipboardSwitch

                title: qsTr("Monitor clipboard for URLs")
                checked: Settings.monitorClipboard
                onCheckedChanged: Settings.monitorClipboard = checked
            }

            SwitchItem {
                id: proxySwitch

                title: qsTr("Use network proxy")
                checked: Settings.networkProxyHostName != ""
                onCheckedChanged: {
                    if (!checked) {
                        Settings.networkProxyHostName = "";
                        Settings.networkProxyPort = 80;
                        Settings.networkProxyUser = "";
                        Settings.networkProxyPassword = "";
                        hostEdit.text = "";
                        portEdit.text = 80;
                        usernameEdit.text = "";
                        passwordEdit.text = "";
                    }
                }
            }

            Column {
                id: column2

                width: column.width
                opacity: proxySwitch.checked ? 1 : 0
                visible: opacity > 0
                spacing: 10

                Behavior on opacity { NumberAnimation { duration: 200 } }

                SelectionItem {
                    id: proxyTypeSelector

                    title: qsTr("Proxy type")
                    subTitle: Settings.networkProxyTypeString
                    onClicked: {
                        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("ProxyTypeSelectionDialog.qml"), appWindow.pageStack);
                        dialog.open();
                    }
                }

                Row {
                    x: 10
                    spacing: parent.width - 20 - (children[0].width + children[1].width)

                    Label {
                        width: hostEdit.width
                        text: qsTr("Host")
                    }

                    Label {
                        width: portEdit.width
                        text: qsTr("Port")
                    }
                }

                Row {
                    x: 10
                    spacing: parent.width - 20 - (children[0].width + children[1].width)

                    TextField {
                        id: hostEdit

                        width: column2.width - 230
                        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                        platformSipAttributes: SipAttributes {
                            actionKeyEnabled: hostEdit.text != ""
                            actionKeyHighlighted: true
                            actionKeyLabel: qsTr("Next")
                            actionKeyIcon: ""
                        }
                        onTextChanged: Settings.networkProxyHostName = text
                        Keys.onReturnPressed: portEdit.focus = true
                        Component.onCompleted: text = Settings.networkProxyHostName
                    }

                    TextField {
                        id: portEdit

                        width: 200
                        inputMethodHints: Qt.ImhDigitsOnly
                        onTextChanged: Settings.networkProxyPort = parseInt(text)
                        Component.onCompleted: text = Settings.networkProxyPort
                    }
                }

                Label {
                    x: 10
                    text: qsTr("Username")
                }

                TextField {
                    id: usernameEdit

                    x: 10
                    width: parent.width - 20
                    inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                    platformSipAttributes: SipAttributes {
                        actionKeyEnabled: usernameEdit.text != ""
                        actionKeyHighlighted: true
                        actionKeyLabel: qsTr("Next")
                        actionKeyIcon: ""
                    }
                    onTextChanged: Settings.networkProxyUser = text
                    Keys.onReturnPressed: passwordEdit.focus = true
                    Component.onCompleted: text = Settings.networkProxyUser
                }

                Label {
                    x: 10
                    text: qsTr("Password")
                }

                TextField {
                    id: passwordEdit

                    x: 10
                    width: parent.width - 20
                    echoMode: TextInput.Password
                    inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                    Component.onCompleted: text = Settings.networkProxyPassword
                }
            }
        }
    }
}
