import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxian.models 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    function showEditAccountDialog(serviceName, serviceIcon, username, password) {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("EditAccountDialog.qml"), appWindow.pageStack);
        dialog.isDecaptchaAccount = true;
        dialog.serviceName = serviceName;
        dialog.serviceIcon = serviceIcon;
        dialog.username = username;
        dialog.password = password;
        dialog.accountSet.connect(accountsModel.addAccount);
        dialog.open();
    }

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: appWindow.pageStack.pop()
        }
    }

    ContextMenu {
        id: contextMenu

        MenuLayout {

            MenuItem {
                text: qsTr("Edit")
                onClicked: root.showEditAccountDialog(
                               accountsModel.serviceName(view.selectedIndex),
                               iconPath + accountsModel.serviceIcon(view.selectedIndex),
                               accountsModel.username(view.selectedIndex),
                               accountsModel.password(view.selectedIndex)
                               )
            }

            MenuItem {
                text: qsTr("Clear")
                onClicked: accountsModel.removeAccount(view.selectedIndex)
            }
        }
    }

    ListView {
        id: view

        property int selectedIndex: -1

        anchors.fill: parent
        model: DecaptchaAccountsModel {
            id: accountsModel

            session: Session
        }
        header: TitleHeader {
            title: qsTr("Decaptcha Accounts")
        }
        delegate: AccountDelegate {
            id: delegate

            onClicked: root.showEditAccountDialog(serviceName, iconPath + serviceIcon, username, password)
            onPressAndHold: {
                view.selectedIndex = index;
                contextMenu.open();
            }
        }
    }
}
