import QtQuick 1.1
import com.nokia.meego 1.0

MySheet {
    id: root

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: urlsEdit.text == "" ? "" : qsTr("Done")
    content: Item {
        id: contentItem

        anchors.fill: parent

        Flickable {
            id: flicker

            anchors {
                fill: parent
                margins: 10
            }

            TextArea {
                id: urlsEdit

                height: 200
                width: parent.width
                placeholderText: qsTr("Add URLs")
                inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    onAccepted: UrlChecker.parseUrlsFromText(urlsEdit.text)
}
