#ifndef FILEFACTORY_H
#define FILEFACTORY_H

#include <QObject>
#include <QUrl>
#include "serviceplugin.h"

class QTimer;

class FileFactory : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit FileFactory(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new FileFactory; }
    inline QString iconName() const { return QString("filefactory.jpg"); }
    inline QString serviceName() const { return QString("FileFactory"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadUrl(const QUrl &url);
    void login(const QString &username, const QString &password);
    inline bool loginSupported() const { return true; }
    inline bool recaptchaRequired() const { return true; }
    inline QString recaptchaKey() const { return m_captchaKey; }

public slots:
    void submitCaptchaResponse(const QString &challenge, const QString &response);

private:
    void startWait(int msecs);
    void getDownloadPage(const QUrl &url);

private slots:
    void checkLogin();
    void checkUrlIsValid();
    void onWebPageDownloaded();
    void onCaptchaSubmitted();
    void updateWaitTime();
    void onWaitFinished();
    void checkDownloadPage();

private:
    QString m_check;
    QUrl m_url;
    QString m_captchaKey;
    QTimer *m_waitTimer;
    int m_waitTime;
};

#endif // FILEFACTORY_H
