#include "variablewindow.h"
#include "ui_variablewindow.h"
#include "mainwindow.h"

VariableWindow::VariableWindow(QWidget *parent, Variables vars) :
    QMainWindow(parent),
    ui(new Ui::VariableWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);

    m_ibase = vars[ibase].toInt();
    m_obase = vars[obase].toInt();
    m_scale = vars[scale].toInt();
    switch (m_ibase)
    {
        case 10:
            ui->rbIbaseDec->setChecked(true);
            break;
        case 2:
            ui->rbIbaseBin->setChecked(true);
            break;
        case 16:
            ui->rbIbaseHex->setChecked(true);
            break;
    }
    switch (m_obase)
    {
        case 10:
            ui->rbObaseDec->setChecked(true);
            break;
        case 2:
            ui->rbObaseBin->setChecked(true);
            break;
        case 16:
            ui->rbObaseHex->setChecked(true);
            break;
    }
    switch (m_scale)
    {
        case 0:
            ui->rbScale0->setChecked(true);
            break;
        case 2:
            ui->rbScale2->setChecked(true);
            break;
        case 5:
            ui->rbScale5->setChecked(true);
            break;
        case 10:
            ui->rbScale10->setChecked(true);
            break;
        case 20:
            ui->rbScale20->setChecked(true);
            break;
    }
}

VariableWindow::~VariableWindow()
{
    if (ui->rbIbaseDec->isChecked() && m_ibase != 10)
        ((MainWindow*)parent())->setIbase(10);
    if (ui->rbIbaseBin->isChecked() && m_ibase != 2)
        ((MainWindow*)parent())->setIbase(2);
    if (ui->rbIbaseHex->isChecked() && m_ibase != 16)
        ((MainWindow*)parent())->setIbase(16);

    if (ui->rbObaseDec->isChecked() && m_obase != 10)
        ((MainWindow*)parent())->setObase(10);
    if (ui->rbObaseBin->isChecked() && m_obase != 2)
        ((MainWindow*)parent())->setObase(2);
    if (ui->rbObaseHex->isChecked() && m_obase != 16)
        ((MainWindow*)parent())->setObase(16);

    if (ui->rbScale0->isChecked() && m_scale != 0)
        ((MainWindow*)parent())->setScale(0);
    if (ui->rbScale2->isChecked() && m_scale != 2)
        ((MainWindow*)parent())->setScale(2);
    if (ui->rbScale5->isChecked() && m_scale != 5)
        ((MainWindow*)parent())->setScale(5);
    if (ui->rbScale10->isChecked() && m_scale != 10)
        ((MainWindow*)parent())->setScale(10);
    if (ui->rbScale20->isChecked() && m_scale != 20)
        ((MainWindow*)parent())->setScale(20);

    delete ui;
}

void VariableWindow::on_pbLast_clicked()
{
    ((MainWindow*)parentWidget())->append("last");
    close();
}

void VariableWindow::on_pbX_clicked()
{
    ((MainWindow*)parentWidget())->append("x");
    close();
}

void VariableWindow::on_pbLetX_clicked()
{
    ((MainWindow*)parentWidget())->append("x=");
    close();
}

void VariableWindow::on_pbPi_clicked()
{
    ((MainWindow*)parentWidget())->append("4*a(1)");
    close();
}
