#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "functionwindow.h"
#include "variablewindow.h"
#include <QLineEdit>

#define VERSION "0.9.1"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    ui->combo->setFocus();

    keyListener = new KeyListener(this);
    ui->combo->installEventFilter(keyListener);
    connect(keyListener, SIGNAL(enterKeyPressed()), this, SLOT(on_pbEnter_clicked()));

    connect(&bc, SIGNAL(outputReady(QString)), this, SLOT(displayOutput(QString)));
    connect(&bc, SIGNAL(errorReady(QString)), this, SLOT(displayError(QString)));
    bc.start();

    QString welcomeText = "<i>Welcome to qbc v";
    welcomeText.append(VERSION);
    welcomeText.append("</i>");
    ui->text->setHtml("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\" \"http://www.w3.org/TR/REC-html40/strict.dtd\">\
                      <html><head><meta name=\"qrichtext\" content=\"1\" /><style type=\"text/css\">p, li { white-space: pre-wrap; }</style></head>\
                      <body style=\"font-family:'Sans'; font-size:10pt; font-weight:400; font-style:normal;\"><p style=\"margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;\">" + welcomeText + "</p></body></html>");
}

MainWindow::~MainWindow()
{
    bc.quit();
    delete ui;
    delete keyListener;
}

void MainWindow::append(QChar c)
{
    ui->combo->lineEdit()->insert(c);
    ui->combo->setFocus();
}

void MainWindow::append(QString s)
{
    ui->combo->lineEdit()->insert(s);
    ui->combo->setFocus();
}

void MainWindow::setIbase(int value)
{
    bc.setVariable("ibase", QString::number(value));
}

void MainWindow::setObase(int value)
{
    bc.setVariable("obase", QString::number(value));
}

void MainWindow::setScale(int value)
{
    bc.setVariable("scale", QString::number(value));
}

void MainWindow::displayOutput(QString text)
{
    if (!text.isEmpty())
    {
        ui->text->append("<b>"+text+"</b>");
        ui->text->moveCursor(QTextCursor::End);
    }
}

void MainWindow::displayError(QString text)
{
    if (!text.isEmpty())
    {
        ui->text->append("<u>"+text+"</u>");
        ui->text->moveCursor(QTextCursor::End);
    }
}

void MainWindow::on_pbEnter_clicked()
{
    QString input = ui->combo->lineEdit()->text().toLatin1();
    bc.write(input.toLatin1());
    bc.write("\n");
    ui->text->append("<i>> " + input + "</i>");
    ui->text->moveCursor(QTextCursor::End);
    ui->combo->insertItem(0, ui->combo->lineEdit()->text());
    ui->combo->lineEdit()->setText("");
    ui->combo->setCurrentIndex(-1);
    ui->combo->setFocus();
}

void MainWindow::on_pb0_clicked()
{
    append('0');
}

void MainWindow::on_pb1_clicked()
{
    append('1');
}

void MainWindow::on_pb2_clicked()
{
    append('2');
}

void MainWindow::on_pb3_clicked()
{
    append('3');
}

void MainWindow::on_pb4_clicked()
{
    append('4');
}

void MainWindow::on_pb5_clicked()
{
    append('5');
}

void MainWindow::on_pb6_clicked()
{
    append('6');
}

void MainWindow::on_pb7_clicked()
{
    append('7');
}

void MainWindow::on_pb8_clicked()
{
    append('8');
}

void MainWindow::on_pb9_clicked()
{
    append('9');
}

void MainWindow::on_pbDot_clicked()
{
    append('.');
}

void MainWindow::on_pbBracketOpen_clicked()
{
    append('(');
}

void MainWindow::on_pbBracketClose_clicked()
{
    append(')');
}

void MainWindow::on_pbPlus_clicked()
{
    append('+');
}

void MainWindow::on_pbMinus_clicked()
{
    append('-');
}

void MainWindow::on_pbMultiply_clicked()
{
    append('*');
}

void MainWindow::on_pbDivide_clicked()
{
    append('/');
}

void MainWindow::on_pbFn_clicked()
{
    FunctionWindow* w = new FunctionWindow(this);
#ifdef Q_WS_MAEMO_5
    w->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    w->show();
}

void MainWindow::on_pbDelete_clicked()
{
    QString s = ui->combo->lineEdit()->text();
    s.chop(1);
    ui->combo->lineEdit()->setText(s);
    ui->combo->setFocus();
}

void MainWindow::on_pbVariable_clicked()
{
    Variables vars = bc.getBuiltInVariables();
    VariableWindow* w = new VariableWindow(this, vars);
#ifdef Q_WS_MAEMO_5
    w->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    w->show();
}
