#include "keylistener.h"
#include <QKeyEvent>

KeyListener::KeyListener(QObject *parent) :
    QObject(parent)
{
}

bool KeyListener::eventFilter(QObject *obj, QEvent *event)
{
    if (event->type() == QEvent::KeyPress)
    {
        QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
        if (keyEvent->key() == Qt::Key_Return || keyEvent->key() == Qt::Key_Enter)
        {
            emit enterKeyPressed();
            return true;
        }
        else
            return false;
    }
    else
    {
        return QObject::eventFilter(obj, event);
    }
}
