# -*- coding: utf-8 -*-
import _midgard as Midgard
import ConfigParser
import os


class SQLConnection():
    # Borg singleton object
    __singleton = {}


    @staticmethod
    def dbtype():
        return "midgard"


    def __init__(self, dbpath = None, schemafile = None, blobdir = None):
        if self.__singleton.has_key("conn") != True:
            if dbpath == None or schemafile == None or blobdir == None:
                raise Exception("database connection not initialized")

            dbdir, dbfile = os.path.split(dbpath)
            configuration = Midgard.config()
            configuration.dbtype = 'SQLite'
            configuration.database = dbfile
            try:
                configuration.dbdir = dbdir
            except:
                print "could not set database directory! (database: %s/%s)" % (dbdir, dbfile)
            configuration.loglevel = 'warn'
            configuration.blobdir = blobdir
            configuration.create_blobdir()

            self.__singleton["conn"] = Midgard.connection()
            self.__singleton["conn"].open_config(configuration)
            self.__singleton["conf"] = configuration
            self.__singleton["schema"] = {}
            self.__singleton["trans"] = Midgard.transaction()
            self.__singleton["trans_started"] = False
            self.__singleton["blobdir"] = blobdir
            
            config = ConfigParser.ConfigParser()
            config.read(schemafile)
            for table,schema in config.items("schema"):
                self.__singleton["schema"][table] = schema
            self.__singleton["autocommit_counter"] = 0
            self.__singleton["autocommit_limit"] = 0

        self.conn = self.__singleton["conn"]
        self.schema = self.__singleton["schema"]
        self.trans = self.__singleton["trans"]
        self.blobdir = self.__singleton["blobdir"]


    def begin(self):
        if self.__singleton["autocommit_limit"] < 1:
            return
        if self.__singleton["trans_started"] == False:
            self.__singleton["trans_started"] = True
            self.trans.begin()


    def set_commit_limit(self, limit):
        self.__singleton["autocommit_counter"] = 0
        self.__singleton["autocommit_limit"] = limit
        if self.__singleton["autocommit_limit"] < 1 and self.__singleton["trans_started"] == True:
            self.trans.commit()
            self.__singleton["trans_started"] = False
            

    def commit(self, force = False):
        if self.__singleton["trans_started"] == False:
            return
        if self.__singleton["autocommit_limit"] > 0:
            self.__singleton["autocommit_counter"] += 1
        if self.__singleton["autocommit_counter"] >= self.__singleton["autocommit_limit"] or force == True:
            self.trans.commit()
            self.__singleton["trans_started"] = False
            self.__singleton["autocommit_counter"] = 0


    def schema(self, table):
        if self.schema_object.has_key(table) != True:
            raise Exception("invalid table given %s" % (table))
        schema = {}
        for field, desc in self.schema_object[table].items():
            schema[field] = None
        return schema


    def create_database(self):
        Midgard.storage.create_base_storage()
        for table,storage_type in self.__singleton["schema"].items():
            if Midgard.storage.class_storage_exists(storage_type):
                print "update",storage_type
                Midgard.storage.update_class_storage(storage_type)
            else:
                print "create",storage_type
                Midgard.storage.create_class_storage(storage_type)

        storage_types = "midgard_attachment", "midgard_parameter", 
        for storage_type in storage_types:
            if Midgard.storage.class_storage_exists(storage_type):
                print "update",storage_type
                Midgard.storage.update_class_storage(storage_type)
            else:
                print "create",storage_type
                Midgard.storage.create_class_storage(storage_type)
            

class SQLObject(object):
    def __init__(self, table, o = None):
        self.object = None
        self._table = table
        self._conn = SQLConnection()
        if o != None:
            self.object = o
        else:
            self.object = getattr(Midgard.mgdschema, self._conn.schema[table])()


    #def __eq__(self, other):
        #if type(self) == type(other):
            #return True
        #return False
        
        
    def __getattr__(self, name):
        if name == "object":
            return self.__dict__[name]
        try:
            return getattr(self.object, name)
        except AttributeError:
            return self.__dict__[name]


    def __setattr__(self, name, value):
        if name == "object":
            self.__dict__[name] = value
            return True
        try:
            setattr(self.object, name, value)
        except AttributeError:
            self.__dict__[name] = value
        return True


    def get_by(self, field, value):
        q = Midgard.query_builder(self._conn.schema[self._table])
        q.add_constraint(field, "=", value)
        r = q.execute()
        if len(r) < 1:
            raise Exception("object not found from %s with %s = %s" % (self._table, field, value))
        self.object = r[0]


    def create(self):
        self._conn.begin()
        self.object.create()
        self._conn.commit()


    def update(self):
        self._conn.begin()
        self.object.update()
        self._conn.commit()


    def delete(self):
        self._conn.begin()
        self.object.purge()
        self._conn.commit()


    def blobWrite(self, name, data):
        filename = "%s/%s_%s_%s" % (self._conn.blobdir, self._table, self.id, name)
        f = open(filename, "wb")
        f.write(data)
        f.close()


    def blobPath(self, name):
        filename = "%s/%s_%s_%s" % (self._conn.blobdir, self._table, self.id, name)
        if os.path.isfile(filename):
            return filename
        return None
        

class SQLQuery(Midgard.query_builder):
    def __init__(self, table):
        self._table = table
        self._conn = SQLConnection()
        Midgard.query_builder.__init__(self, self._conn.schema[table])
        
        
    def execute(self):
        r = Midgard.query_builder.execute(self)
        results = []
        for o in r:
            results.append(SQLObject(self._table, o))
        return results

        
