# -*- coding: utf-8 -*-
import time
import ConfigParser
from dateutil import parser
import datetime
import simplejson

try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from sql import *
from config import Config
from channel import Channel
from person import Person


class Message(object):
    def __init__(self, param = None, parent = None, json = None):
        if isinstance(json, dict):
            self.object = SQLObject("message")
            self.createFromJson(param, parent, json)
        elif isinstance(param, int):
            self.object = SQLObject("message")
            self.object.get_by("id", param)
        elif isinstance(param, str):
            self.object = SQLObject("message")
            self.object.get_by("uuid", param)
        elif param == None:
            self.object = SQLObject("message")
        else:
            self.object = param

        if self.isentry != 1:
            self.isentry = 0
        if self.istask != 1:
            self.istask = 0
        if self.comment != 1:
            self.comment = 0
            
        self.channel = None
        self.person = None
        self.source = None
        if param == None:
            self.created = time.time()
            return
            
        try:
            self.channel = Channel(int(self.object.channelid))
        except:
            self.channel = None

        try:
            self.person = Person(int(self.object.ownerid))
        except:
            self.person = None

        if self.object.sourceid > 0:
            try:
                self.source = Message(int(self.object.sourceid))
            except:
                pass

        if self.source != None and self.source.istask:
            self.isentry = 1


    @staticmethod
    def messageGetAllForTask(taskId):
        #qb = Midgard.query_builder("com_qaiku_message")
        #qb.add_constraint("taskid", "=", taskId)
        #qb.add_order("metadata.published", "DESC")
        #r = qb.execute()
        #messages = []
        #for message in r:
            #messages.append(Message(message))
        #return messages
        return []
        

    @staticmethod
    def messageGetAll(channelId = None, limit = 0, all = False, istask = 0):
        q = SQLQuery("message")
        if channelId != None:
            q.add_constraint("channelid", "=", channelId)
        if all != True:
            q.add_constraint("comment", "=", 0)
        if limit > 0:
            q.set_limit(int(limit))
        q.add_constraint("istask", "=", istask)
        q.add_order("created", "DESC")
        r = q.execute()
        messages = []
        for message in r:
            messages.append(Message(message))
        return messages


    def createFromJson(self, task, parent, json):
        if json.has_key("channel"):
            channel = Channel.channelCreate(json["channel"])
            if channel == None:
                print "channel not found",json["channel"]
                return None
        else:
            channel = None

        update = False
        try:
            self.object.get_by("uuid", json["id"])
        except:
            self.object.uuid = json["id"]

            if parent != None:
                self.object.sourceid = parent.id
                self.object.comment = 1
            else:
                self.object.comment = 0

            if channel != None:
                self.object.channelid = channel.id
            self.object.created = time.mktime(parser.parse(json["created_at"]).timetuple())

        if self.object.message != json["html"]:
            self.object.message = unicode(json["html"]).encode("utf-8")
            update = True

        if json.has_key("user"):
            person = Person(json["user"])
            self.object.ownerid = person.id

        self.istask = 0
        self.isentry = 0
        
        if len(json["data"]) > 0:
            try:
                data = simplejson.loads(json["data"])
                self.istask = int(data["task"])
                self.isentry = int(data["entry"])
                if int(data["completeness"]) > self.object.completeness:
                    self.object.completeness = int(data["completeness"])
                self.object.deadline = int(data["deadline"])
                self.object.priority = int(data["priority"])
                if self.isentry:
                    try:
                        m = Message(str(data["source"]))
                        if m.id != self.object.sourceid:
                            self.object.sourceid = m.id
                            update = True
                    except:
                        pass
                if self.istask:
                    update = True
            except:
                pass

        try:
            self.object.create()
        except:
            if update:
                self.object.update()

        
    # Overloaded getter function to handle direct request of variables from Midgard objects
    def __getattr__(self, name):
        if name == 'object':
            return self.__dict__[name]
        elif name == "metadata":
            return self.__dict__[name]
        try:
            value = getattr(self.object, name)
            #if isinstance(value, str):
                #value = QtCore.QString.fromUtf8(value).toLatin1()
            return value
        except AttributeError:
            return self.__dict__[name]
        return False

            
    # Overloaded setter function to handle direct setting of variables to Midgard objects
    def __setattr__(self, name, value):
        if name == 'object':
            self.__dict__[name] = value   
            return True 
        elif name == 'metadata':
            self.__dict__[name] = value
            return True
        try:
            setattr(self.object, name, value)
        except AttributeError:
            self.__dict__[name] = value
        return True

          
    # Overload Midgard object's create function      
    def create(self):    
        self.object.create()
        
        try:
            self.person = Person(int(self.object.ownerid))
        except AttributeError:
            self.person = None

        try:
            self.channel = Channel(int(self.object.channelid))
        except:
            self.channel = None

        if self.object.sourceid > 0:
            try:
                self.source = Message(int(self.object.sourceid))
            except:
                self.source = None

        if self.source != None and self.source.istask:
            self.isentry = 1

        # insert to sync queue
        so = SQLObject("sync")
        so.objectuuid = self.object.uuid
        so.objectid = self.object.id
        so.objectclassname = "message"
        so.operation = "create"
        so.create()

        
    def objectSync(self, QC):
        channel = None
        replyId = None
        data = None
        
        if self.comment == True:
            q = SQLQuery("message")
            q.add_constraint("id", "=", self.sourceid)
            r = q.execute()
            if len(r) > 0:
                replyId = str(r[0].uuid)
        elif self.channel != None:
            channel = str(self.channel.name)

        if self.isentry or self.istask:
            data = {}
            data["task"] = 0
            data["entry"] = 0
            if self.istask:
                data["task"] = 1
            if self.isentry:
                data["entry"] = 1
                data["source"] = self.source.uuid
            data["completeness"] = self.object.completeness
            data["priority"] = self.object.priority
            data["deadline"] = self.object.deadline

        if data != None:
            data = simplejson.dumps(data)
            
        return QC.qaikuPostMessage(message = self.object.message, channel = channel, in_reply_to_status_id = replyId, callback = self.objectSyncReady, data = data)


    def objectSyncReady(self, request):
        print "post",request["status"],request["reason"]
        if request["status"] == 200:
            item = request["qdata"]
            self.object.uuid = item.getValue("id")
            self.object.update()
        else:
            return False
        return True


    # Overload Midgard object's update function      
    def update(self):
        self.object.update()
        # TODO: Tassa kohtaa lisataan synkronointitauluun kaamaa

        print self.__class__.__name__+" object updated"

        # insert to sync queue
        so = SQLObject("sync")
        so.objectuuid = self.object.uuid
        so.objectid = self.object.id
        so.objectclassname = "message"
        so.operation = "update"
        so.create()


    # Overload Midgard object's delete function      
    def delete(self):
        self.object.delete()
        # TODO: Tassa kohtaa lisataan synkronointitauluun kaamaa

        print self.__class__.__name__+" object deleted"


    def getIcon(self):
        return self.person.getAvatar()


    def getCommentsCount(self):
        q = SQLQuery("message")
        q.add_constraint("sourceid", "=", self.object.id)
        return q.count()


    def getComments(self):
        q = SQLQuery("message")
        q.add_constraint("sourceid", "=", self.object.id)
        q.add_order("created", "ASC")
        r = q.execute()
        messages = []
        for message in r:
            messages.append(Message(message))
        return messages
        
        
