# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui
from qaikuconnection import QaikuConnection
from person import Person

class Ui_Persons(QtGui.QDialog):
    def __init__(self, currentPerson):
        QtGui.QDialog.__init__(self)

        self.currentPerson = currentPerson
        
        self.setObjectName("Ui_Person")
        self.setWindowTitle(self.tr("Select person"))

        self.setFixedHeight(400)
        self.layout = QtGui.QHBoxLayout(self)
        self.listPersons = QtGui.QListWidget()
        self.layout.addWidget(self.listPersons)
        button = QtGui.QPushButton("Select")
        self.layout.addWidget(button)
        button.connect(QtCore.SIGNAL("clicked()"), self.selectPerson)

        persons = Person.personGetAll()
        for person in persons:
            self.addPerson(person)


    def selectPerson(self):
        person = Person(str(self.listPersons.currentItem().text()))
        self.setResult(int(person.id))
        self.hide()

    def addPerson(self, person):
        item = QtGui.QListWidgetItem(QtGui.QIcon(person.getAvatar()), person.getScreenName())
        self.listPersons.addItem(item)
        if (person.getLogin() == self.currentPerson.getLogin()):
            self.listPersons.setCurrentItem(item)


