# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui
from dateutil import parser
import datetime, random

from config import Config
from message import Message

from ui_list import Ui_List, Ui_ListWidget
from ui_icon import Ui_Icon


class Ui_Message(Ui_ListWidget):
    def __init__(self, message, callback = None):
        self.message = message
        Ui_ListWidget.__init__(self, callback = callback)
        self.setObjectName("Ui_Message")
        self.setContentsMargins(2, 14, 2, 2)

        self.setText(unicode(self.message.message))
        self.setIcon(self.message.getIcon(), "data/message.png", 20, 6)
        
        self.commentsIcon = None
        self.labelCompleteness = None
        
        if self.message.comment == 1:
            self.setFlat(True)
            self.setBorder(1)
        else:
            iconfile = "data/comment.png"
            if self.message.istask:
                iconfile = "data/entry.png"
            self.commentsIcon = Ui_Icon(iconfile, str(self.message.getCommentsCount()), self)
            self.commentsIcon.setTextOffset(y = 4, alignment = QtCore.Qt.AlignTop + QtCore.Qt.AlignHCenter)
            self.addWidgetRight(self.commentsIcon)
        

    def updateContent(self):
        if self.commentsIcon != None:
            self.commentsIcon.setText(str(self.message.getCommentsCount()))
        if (self.message.isentry or self.message.istask) and self.labelCompleteness != None:
            self.updateCompleteness()
        self.update()
        
        
    def enableExtra(self):
        try:
            channel_name = "#"+str(self.message.channel.getName())
            if self.message.comment != 1:
                channel_name = " "+self.tr("on channel")+" "+channel_name
            else:
                channel_name = " "+self.tr("commented on channel")+" "+channel_name
        except:
            channel_name = ""
            
        created = datetime.datetime.fromtimestamp(int(self.message.created))
        label = QtGui.QLabel(str(self.message.person.getScreenName())+channel_name+" ("+str(created)+")")
        font = label.font()
        font.setPointSize(font.pointSize() - 6)
        label.setFont(font)
        palette = label.palette()
        palette.setColor(QtGui.QPalette.WindowText, QtGui.QColor(200, 200, 200))
        label.setPalette(palette)
        self.addWidgetBottom(label)

        if self.message.isentry or self.message.istask:
            self.labelCompleteness = QtGui.QLabel(self)
            #font = self.labelCompleteness.font()
            #size = font.pointSize()
            #completeness = int(self.message.completeness)
            #if completeness < 20:
                #size += 8
            #elif completeness < 40:
                #size += 6
            #elif completeness < 60:
                #size += 4
            #elif completeness < 80:
                #size += 2
            #font.setPointSize(size)
            #self.labelCompleteness.setFont(font)
            self.addWidgetRight(self.labelCompleteness, align = QtCore.Qt.AlignCenter)
            self.updateCompleteness()


    def updateCompleteness(self):
        completeness = int(self.message.completeness)
        self.labelCompleteness.setText(str(completeness)+"%")
        palette = self.labelCompleteness.palette()
        g = 50 + (completeness * 2)
        r = 255 - (completeness * 2)
        palette.setColor(QtGui.QPalette.WindowText, QtGui.QColor(r, g, 100))
        self.labelCompleteness.setPalette(palette)



