# -*- coding: utf-8 -*-
import os

from sql import *
from config import Config


# Decorator class for Entry object in Midgard DB
class Person(object):
    def __init__(self, param = None):
        if isinstance(param, dict):
            self.object = SQLObject("person")
            self.createFromJson(param)
        elif isinstance(param, int):
            self.object = SQLObject("person")
            self.object.get_by("id", param)
        elif isinstance(param, str):
            self.object = SQLObject("person")
            self.object.get_by("username", param)
        elif param == None:
            self.object = SQLObject("person")
        else:
            self.object = param


    @staticmethod
    def personGetAll():
        q = SQLQuery("person")
        r = q.execute()
        persons = []
        for person in r:
            if len(person.username) < 1:
                continue
            persons.append(Person(person))
        return persons


    @staticmethod
    def personGetAllActive():
        q = SQLQuery("person")
        q.add_constraint("active", "=", 1)
        r = q.execute()
        persons = []
        for person in r:
            if len(person.username) < 1:
                continue
            persons.append(Person(person))
        return persons


    def createFromJson(self, json):
        update = False
        username = str(json["screen_name"])

        try:
            self.object.get_by("username", username)
        except:
            pass

        self.username = username
        self.uuid = str(json["id"])
        if json.has_key("apikey"):
            if self.password != json["apikey"]:
                self.password = json["apikey"]
                update = True

        if json.has_key("profile_image_url"):
            if json["profile_image_url"] != self.avatarurl:
                self.avatarurl = json["profile_image_url"]
                self.avatarupdate = 1
                update = True

        try:
            self.object.create()
        except:
            if update:
                self.object.update()


    # Overloaded getter function to handle direct request of variables from Midgard objects
    def __getattr__(self, name):
        if name == 'object':
            return self.__dict__[name]
        try:
            return getattr(self.object, name)
        except AttributeError:
            #print "WARNING: __getattr__ function of class ("+self.__class__.__name__+") didn't find requested attribute ('"+name+"') in object ("+self.__dict__['object'].__class__.__name__+")."
            # Get non-persistent values (not members of Midgard object) from this object
            return self.__dict__[name]
        return False

            
    # Overloaded setter function to handle direct setting of variables to Midgard objects
    def __setattr__(self, name, value):
        if name == 'object':
            self.__dict__[name] = value
            return True
        try:
            setattr(self.object, name, value)
        except AttributeError:
            #print "WARNING: __setattr__ function of class ("+self.__class__.__name__+") didn't find requested attribute ('"+name+"') in object ("+self.__dict__['object'].__class__.__name__+")."
            # Set non-persistent values (not members of Midgard object) to this object
            self.__dict__[name] = value
        return True

        
    # Overload Midgard object's create function      
    def create(self):    
        self.object.create()


    # Overload Midgard object's update function      
    def update(self):
        self.object.update()


    # Overload Midgard object's delete function      
    def delete(self):
        self.object.delete()


    # set person active or inactive
    def setActive(self, active):
        self.object.active = int(active)
        self.object.update()


    # get person avatar
    def getAvatar(self):
        path = self.object.blobPath("avatar")
        if path == None:
            path = "data/no_avatar.gif"
        return path


    def getLogin(self):
        return self.object.username

        
    # return realname for person
    def getName(self):
        return self.object.username


    # return screen name for person
    def getScreenName(self):
        return self.object.username


    def getApiKey(self):
        return self.object.password


    def setApiKey(self, apikey):
        self.object.password = apikey
        self.object.update()


    def writeAvatarData(self, data):
        self.object.blobWrite("avatar", data)


