
#define QT_NO_KEYWORDS
#include "qemaemo5notification.h"
#include "qesettingsmanager.h"
#include <hildon-notify/hildon/hildon-notification.h>

#define QE_MAEMO5_NOTIFICATION_DBUS_PATH ("/net/venemo/qextrasnotification_" + id)
#define QE_MAEMO5_NOTIFICATION_DBUS_SERVICE (QString(QE_MAEMO5_NOTIFICATION_DBUS_INTERFACE) + "_" + id)
#define QGSTRING(x) (x.toLatin1().data())

const int QeMaemo5Notification::EXPIRES_NEVER = NOTIFY_EXPIRES_NEVER;
const int QeMaemo5Notification::DEFAULT_TIMEOUT = NOTIFY_EXPIRES_DEFAULT;
const QString QeMaemo5Notification::DEFAULT_ICON("general_web");
const QString QeMaemo5Notification::APPLICATION_ICON_SETTING_KEY("QeMaemo5Notification_application_icon");

void QeMaemo5Notification::notification_closed(NotifyNotification* notification, gpointer user_data)
{
    Q_UNUSED(notification);
    QeMaemo5Notification *n = static_cast<QeMaemo5Notification*>(user_data);

    if (n->_isVisible)
    {
        //qDebug() << "QeMaemo5Notification closed!";
        n->_isVisible = false;
        Q_EMIT n->closed();
    }
}

QeMaemo5Notification::QeMaemo5Notification(const QString &text, QObject *parent, const QString &title, int timeout, const QList<QeStringPair> &hints, const QString &icon)
    : QObject(parent),
      id(QUuid::createUuid().toString().remove("{").remove("}").remove("-")),
      _text(text),
      _title(title),
      _icon(icon),
      _isVisible(false)
{
    if (!notify_is_initted())
        notify_init(QApplication::applicationName().toLatin1().data());

    QDBusConnection::sessionBus().registerService(QE_MAEMO5_NOTIFICATION_DBUS_SERVICE);
    QDBusConnection::sessionBus().registerObject(QE_MAEMO5_NOTIFICATION_DBUS_PATH, this, QDBusConnection::ExportScriptableSlots);

    notification = hildon_notification_new(QGSTRING(title), QGSTRING(text), QGSTRING(icon), NULL);
    hildon_notification_add_dbus_action(notification,
                                        "default",
                                        QApplication::applicationName().toLatin1().data(),
                                        QGSTRING(QE_MAEMO5_NOTIFICATION_DBUS_SERVICE),
                                        QGSTRING(QE_MAEMO5_NOTIFICATION_DBUS_PATH),
                                        QE_MAEMO5_NOTIFICATION_DBUS_INTERFACE,
                                        "clicked_you_now",
                                        G_TYPE_NONE,
                                        0
                                       -1);
    g_signal_connect(G_OBJECT(notification), "closed", G_CALLBACK(notification_closed), this);
    setTimeout(timeout);

    Q_FOREACH (const QeStringPair &hint, hints)
        addHint(hint);
}

QeMaemo5Notification::~QeMaemo5Notification()
{
    //qDebug() << "QeMaemo5Notification destroyed";
    g_object_unref(notification);
    QDBusConnection::sessionBus().unregisterService(QE_MAEMO5_NOTIFICATION_DBUS_SERVICE);
    QDBusConnection::sessionBus().unregisterObject(QE_MAEMO5_NOTIFICATION_DBUS_PATH, QDBusConnection::UnregisterTree);
}

QString QeMaemo5Notification::text()
{
    return _text;
}

QString QeMaemo5Notification::title()
{
    return _title;
}

QString QeMaemo5Notification::icon()
{
    return _icon;
}

QString QeMaemo5Notification::category()
{
    return _category;
}

QString QeMaemo5Notification::soundFile()
{
    return _soundFile;
}

void QeMaemo5Notification::setText(const QString &value)
{
    _text = value;
    notify_notification_update(NOTIFY_NOTIFICATION(notification), QGSTRING(_title), QGSTRING(_text), QGSTRING(_icon));
}

void QeMaemo5Notification::setTitle(const QString &value)
{
    _title = value;
    notify_notification_update(NOTIFY_NOTIFICATION(notification), QGSTRING(_title), QGSTRING(_text), QGSTRING(_icon));
}

void QeMaemo5Notification::setIcon(const QString &value)
{
    _icon = value;
    notify_notification_update(NOTIFY_NOTIFICATION(notification), QGSTRING(_title), QGSTRING(_text), QGSTRING(_icon));
}

void QeMaemo5Notification::setCategory(const QString &value)
{
    _category = value;
    notify_notification_set_category(NOTIFY_NOTIFICATION(notification), QGSTRING(_category));
}

void QeMaemo5Notification::setSoundFile(const QString &value)
{
    _soundFile = value;
    hildon_notification_set_sound(notification, QGSTRING(_soundFile));
}

int QeMaemo5Notification::timeout()
{
    return _timeout;
}

void QeMaemo5Notification::setTimeout(int value)
{
    _timeout = value;
    notify_notification_set_timeout(NOTIFY_NOTIFICATION(notification), _timeout);
}

void QeMaemo5Notification::addDbusAction(const QDBusMessage &message)
{
    _dbusMessages.append(message);
}

void QeMaemo5Notification::clearDbusActions()
{
    _dbusMessages.clear();
}

void QeMaemo5Notification::addHint(const QeStringPair &hint)
{
    notify_notification_set_hint_string(NOTIFY_NOTIFICATION(notification), hint.first.toLatin1().data(), hint.second.toLatin1().data());
}

void QeMaemo5Notification::clearHints()
{
    notify_notification_clear_hints(NOTIFY_NOTIFICATION(notification));
}

const QString QeMaemo5Notification::applicationIcon()
{
    return QeSettingsManager::retrieveSetting(APPLICATION_ICON_SETTING_KEY, DEFAULT_ICON);
}

void QeMaemo5Notification::setApplicationIcon(const QString &icon)
{
    QeSettingsManager::storeSetting(APPLICATION_ICON_SETTING_KEY, icon);
}

void QeMaemo5Notification::show()
{
    if (_isVisible || notify_notification_show(NOTIFY_NOTIFICATION(notification), NULL))
        _isVisible = true;
}

void QeMaemo5Notification::hide()
{
    if (!_isVisible || notify_notification_close(NOTIFY_NOTIFICATION(notification), NULL))
        _isVisible = false;
}

int QeMaemo5Notification::clicked_you_now()
{
    _isVisible = false;
    //qDebug() << "QeMaemo5Notification clicked!";

    Q_FOREACH (const QDBusMessage &message, _dbusMessages)
        QDBusConnection::sessionBus().call(message);

    Q_EMIT clicked();
    return 0;
}

void QeMaemo5Notification::information(const QString &text, const QString &title, int timeout, const QDBusMessage *message, const QList<QeStringPair> &hints, const QString &icon)
{
    QeMaemo5Notification *n = new QeMaemo5Notification(text, 0, title, timeout, hints, icon);
    if (message)
        n->addDbusAction(*message);
    n->show();
    connect(n, SIGNAL(clicked()), n, SLOT(deleteLater()));
    connect(n, SIGNAL(closed()), n, SLOT(deleteLater()));
}

void QeMaemo5Notification::information(const QString &text, const QString &title, int timeout, const QString &icon)
{
    information(text, title, timeout, NULL, QList<QPair<QString, QString> >(), icon);
}

void QeMaemo5Notification::nonExpiringInformation(const QString &text, const QString &title, const QDBusMessage *message, const QList<QeStringPair> &hints, const QString &icon)
{
    information(text, title, QeMaemo5Notification::EXPIRES_NEVER, message, hints, icon);
}

void QeMaemo5Notification::nonExpiringInformation(const QString &text, const QString &title, const QString &icon)
{
    information(text, title, QeMaemo5Notification::EXPIRES_NEVER, NULL, QList<QeStringPair>(), icon);
}
