/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.11-snapshot-c38d259c1879 on Fri Sep  3 11:00:01 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 44 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 39 "sipQtGuiQVector3D.cpp"

#line 40 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 43 "sipQtGuiQVector3D.cpp"
#line 92 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 46 "sipQtGuiQVector3D.cpp"
#line 44 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector2d.sip"
#include <qvector2d.h>
#line 49 "sipQtGuiQVector3D.cpp"
#line 44 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 52 "sipQtGuiQVector3D.cpp"
#line 44 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qmatrix4x4.sip"
#include <qmatrix4x4.h>
#line 55 "sipQtGuiQVector3D.cpp"


extern "C" {static PyObject *meth_QVector3D_length(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->length();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_length, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lengthSquared();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_lengthSquared, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_normalized(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(sipCpp->normalized());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normalized, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_normalize(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->normalize();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normalize, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_dotProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QVector3D::dotProduct(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_dotProduct, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_crossProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_crossProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(QVector3D::crossProduct(*a0,*a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_crossProduct, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_normal(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normal(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(QVector3D::normal(*a0,*a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    {
        const QVector3D * a0;
        const QVector3D * a1;
        const QVector3D * a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(QVector3D::normal(*a0,*a1,*a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normal, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_distanceToPlane(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_distanceToPlane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->distanceToPlane(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    {
        const QVector3D * a0;
        const QVector3D * a1;
        const QVector3D * a2;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->distanceToPlane(*a0,*a1,*a2);
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_distanceToPlane, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_distanceToLine(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_distanceToLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->distanceToLine(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_distanceToLine, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_toVector2D(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toVector2D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            QVector2D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector2D(sipCpp->toVector2D());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector2D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toVector2D, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_toVector4D(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toVector4D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            QVector4D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector4D(sipCpp->toVector4D());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector4D,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toVector4D, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_isNull(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_isNull, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_x(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->x();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_x, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_y(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->y();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_y, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_z(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->z();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_z, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_setX(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setX(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setX, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_setY(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setY(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setY, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_setZ(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setZ(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setZ, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_toPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->toPoint());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toPoint, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QVector3D_toPointF(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toPointF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->toPointF());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toPointF, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QVector3D___eq__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,eq_slot,sipType_QVector3D,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QVector3D___mul__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QMatrix4x4 * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QMatrix4x4, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    {
        qreal a0;
        const QVector3D * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    {
        const QVector3D * a0;
        qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector3D, &a0, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 * a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___div__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___div__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector3D, &a0, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 / a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,div_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___add__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 + *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,add_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___sub__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;
        const QVector3D * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D((*a0 - *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,sub_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___neg__(PyObject *);}
static PyObject *slot_QVector3D___neg__(PyObject *sipSelf)
{
    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;


    {
        {
            QVector3D *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QVector3D(-(*sipCpp));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QVector3D,NULL);
        }
    }
}


extern "C" {static PyObject *slot_QVector3D___ne__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,ne_slot,sipType_QVector3D,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QVector3D___idiv__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___idiv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QVector3D::operator/=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___imul__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QVector3D::operator*=(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QVector3D * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QVector3D::operator*=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___isub__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QVector3D::operator-=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QVector3D___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QVector3D * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QVector3D::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___repr__(PyObject *);}
static PyObject *slot_QVector3D___repr__(PyObject *sipSelf)
{
    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QVector3D));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 61 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector3d.sip"
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        PyObject *z = PyFloat_FromDouble(sipCpp->z());
        
        if (x && y && z)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt4.QtGui.QVector3D(%R, %R, %R)", x, y,
                    z);
        #else
            sipRes = PyString_FromString("PyQt4.QtGui.QVector3D(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(z));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        Py_XDECREF(x);
        Py_XDECREF(y);
        Py_XDECREF(z);
#line 1117 "sipQtGuiQVector3D.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QVector3D(void *, const sipTypeDef *);}
static void *cast_QVector3D(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QVector3D)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QVector3D(void *, int);}
static void release_QVector3D(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QVector3D *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QVector3D(void *);}
static PyObject *pickle_QVector3D(void *sipCppV)
{
    QVector3D *sipCpp = reinterpret_cast<QVector3D *>(sipCppV);
    PyObject *sipRes;

#line 48 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qvector3d.sip"
    sipRes = Py_BuildValue((char *)"ddd", sipCpp->x(), sipCpp->y(), sipCpp->z());
#line 1156 "sipQtGuiQVector3D.cpp"

    return sipRes;
}


extern "C" {static void assign_QVector3D(void *, SIP_SSIZE_T, const void *);}
static void assign_QVector3D(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QVector3D *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QVector3D *>(sipSrc);
}


extern "C" {static void *array_QVector3D(SIP_SSIZE_T);}
static void *array_QVector3D(SIP_SSIZE_T sipNrElem)
{
    return new QVector3D[sipNrElem];
}


extern "C" {static void *copy_QVector3D(const void *, SIP_SSIZE_T);}
static void *copy_QVector3D(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QVector3D(reinterpret_cast<const QVector3D *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVector3D(sipSimpleWrapper *);}
static void dealloc_QVector3D(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QVector3D(sipGetAddress(sipSelf),0);
    }
}


extern "C" {static void *init_QVector3D(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QVector3D(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QVector3D *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        qreal a0;
        qreal a1;
        qreal a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "fff", &a0, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QPoint * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QPointF * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QPointF, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector2D * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QVector2D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector2D * a0;
        qreal a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9f", sipType_QVector2D, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0,a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector4D * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector3D * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QVector3D(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVector3D[] = {
    {(void *)slot_QVector3D___eq__, eq_slot},
    {(void *)slot_QVector3D___mul__, mul_slot},
    {(void *)slot_QVector3D___div__, div_slot},
    {(void *)slot_QVector3D___add__, add_slot},
    {(void *)slot_QVector3D___sub__, sub_slot},
    {(void *)slot_QVector3D___neg__, neg_slot},
    {(void *)slot_QVector3D___ne__, ne_slot},
    {(void *)slot_QVector3D___idiv__, idiv_slot},
    {(void *)slot_QVector3D___imul__, imul_slot},
    {(void *)slot_QVector3D___isub__, isub_slot},
    {(void *)slot_QVector3D___iadd__, iadd_slot},
    {(void *)slot_QVector3D___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVector3D[] = {
    {SIP_MLNAME_CAST(sipName_crossProduct), meth_QVector3D_crossProduct, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_distanceToLine), meth_QVector3D_distanceToLine, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_distanceToPlane), meth_QVector3D_distanceToPlane, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_dotProduct), meth_QVector3D_dotProduct, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isNull), meth_QVector3D_isNull, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_length), meth_QVector3D_length, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_lengthSquared), meth_QVector3D_lengthSquared, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_normal), meth_QVector3D_normal, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_normalize), meth_QVector3D_normalize, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_normalized), meth_QVector3D_normalized, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setX), meth_QVector3D_setX, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setY), meth_QVector3D_setY, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setZ), meth_QVector3D_setZ, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toPoint), meth_QVector3D_toPoint, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toPointF), meth_QVector3D_toPointF, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toVector2D), meth_QVector3D_toVector2D, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_toVector4D), meth_QVector3D_toVector4D, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_x), meth_QVector3D_x, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_y), meth_QVector3D_y, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_z), meth_QVector3D_z, METH_VARARGS, NULL}
};


pyqt4ClassTypeDef sipTypeDef_QtGui_QVector3D = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QVector3D,
        {0}
    },
    {
        sipNameNr_QVector3D,
        {0, 0, 1},
        20, methods_QVector3D,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QVector3D,
    init_QVector3D,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QVector3D,
    assign_QVector3D,
    array_QVector3D,
    copy_QVector3D,
    release_QVector3D,
    cast_QVector3D,
    0,
    0,
    pickle_QVector3D
},
    0,
    0,
    0
};
