/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:17:02 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIphonon.h"

#line 237 "sip/QtCore/qmap.sip"
#include <qmap.h>
#line 44 "sipphononQMultiMap.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipphononQMultiMap.cpp"


extern "C" {static void assign_QMultiMap_0200QString_0200QString(void *, const void*);}
static void assign_QMultiMap_0200QString_0200QString(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QMultiMap<QString,QString> *>(sipDst) = *reinterpret_cast<const QMultiMap<QString,QString> *>(sipSrc);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QMultiMap_0200QString_0200QString(void *, int);}
static void release_QMultiMap_0200QString_0200QString(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast<QMultiMap<QString,QString> *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_QMultiMap_0200QString_0200QString(PyObject *, void **, int *, PyObject *);}
static int convertTo_QMultiMap_0200QString_0200QString(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QMultiMap<QString,QString> **sipCppPtr = reinterpret_cast<QMultiMap<QString,QString> **>(sipCppPtrV);

#line 319 "sip/QtCore/qmap.sip"
    PyObject *key_obj, *value_obj;
    SIP_SSIZE_T i = 0;

    // Check the type if that is all that is required.
    if (sipIsErr == NULL)
    {
        if (!PyDict_Check(sipPy))
            return 0;

        while (PyDict_Next(sipPy, &i, &key_obj, &value_obj))
        {
            if (!sipCanConvertToInstance(key_obj, sipClass_QString, SIP_NOT_NONE))
                return 0;

            if (!PyList_Check(value_obj))
                return 0;

            for (SIP_SSIZE_T vi = 0; vi < PyList_GET_SIZE(value_obj); ++vi)
                if (!sipCanConvertToInstance(PyList_GET_ITEM(value_obj, vi), sipClass_QString, SIP_NOT_NONE))
                    return 0;
        } 

        return 1;
    }

    QMultiMap<QString, QString> *qm = new QMultiMap<QString, QString>;
 
    while (PyDict_Next(sipPy, &i, &key_obj, &value_obj))
    {
        int key_state;

        QString *key = reinterpret_cast<QString *>(sipConvertToInstance(key_obj, sipClass_QString, sipTransferObj, SIP_NOT_NONE, &key_state, sipIsErr));

        SIP_SSIZE_T vi = PyList_GET_SIZE(value_obj);

        // We go through the list backwards to maintain the Qt semantics of
        // later items appearing first.
        while (vi--)
        {
            int val_state;

            QString *val = reinterpret_cast<QString *>(sipConvertToInstance(PyList_GET_ITEM(value_obj, vi), sipClass_QString, sipTransferObj, SIP_NOT_NONE, &val_state, sipIsErr));
 
            if (*sipIsErr)
            {
                sipReleaseInstance(val, sipClass_QString, val_state);
                break;
            }

            qm->insert(*key, *val);
            sipReleaseInstance(val, sipClass_QString, val_state);
        }

        sipReleaseInstance(key, sipClass_QString, key_state);

        if (*sipIsErr)
        {
            delete qm;
            return 0;
        }
    }
 
    *sipCppPtr = qm;
 
    return sipGetState(sipTransferObj);
#line 140 "sipphononQMultiMap.cpp"
}


extern "C" {static void *forceConvertTo_QMultiMap_0200QString_0200QString(PyObject *, int *);}
static void *forceConvertTo_QMultiMap_0200QString_0200QString(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (convertTo_QMultiMap_0200QString_0200QString(valobj,NULL,NULL,NULL))
    {
        void *val;

        /*
         * Note that we throw away the flag that says if the value
         * has just been created on the heap or not.
         */
        convertTo_QMultiMap_0200QString_0200QString(valobj,&val,iserrp,NULL);

        return val;
    }

    sipBadClass("QMultiMap<QString,QString>");

    *iserrp = 1;

    return NULL;
}


extern "C" {static PyObject *convertFrom_QMultiMap_0200QString_0200QString(void *, PyObject *);}
static PyObject *convertFrom_QMultiMap_0200QString_0200QString(void *sipCppV,PyObject *sipTransferObj)
{
   QMultiMap<QString,QString> *sipCpp = reinterpret_cast<QMultiMap<QString,QString> *>(sipCppV);

#line 241 "sip/QtCore/qmap.sip"
    // Create the dictionary.
    PyObject *d = PyDict_New();

    if (!d)
        return NULL;

    // Set the dictionary elements.
    QList<QString> keys = sipCpp->keys();
    QList<QString>::const_iterator kit = keys.constBegin();

    while (kit != keys.constEnd())
    {
        // Create a Python list as the dictionary value.
        QList<QString> values = sipCpp->values(*kit);
        PyObject *value_obj = PyList_New(values.count());

        if (!value_obj)
        {
            Py_DECREF(d);
            return NULL;
        }

        // Wrap each value associated with the key.
        QList<QString>::const_iterator vit = values.constBegin();
        int i = 0;

        while (vit != values.constEnd())
        {
            QString *val_copy = new QString(*vit);
            PyObject *val_obj = sipConvertFromNewInstance(val_copy, sipClass_QString, sipTransferObj);

            if (!val_obj)
            {
                delete val_copy;

                Py_DECREF(value_obj);
                Py_DECREF(d);
                return NULL;
            }

            PyList_SET_ITEM(value_obj, i, val_obj);

            ++i;
            ++vit;
        }

        // Wrap a copy of the key.
        QString *key_copy = new QString(*kit);
        PyObject *key_obj = sipConvertFromNewInstance(key_copy, sipClass_QString, sipTransferObj);

        if (!key_obj)
        {
            delete key_copy;

            Py_DECREF(value_obj);
            Py_DECREF(d);
            return NULL;
        }

        // Add to the dictionary.
        if (PyDict_SetItem(d, key_obj, value_obj) < 0)
        {
            Py_DECREF(key_obj);
            Py_DECREF(value_obj);
            Py_DECREF(d);
            return NULL;
        }

        Py_DECREF(key_obj);
        Py_DECREF(value_obj);

        ++kit;
    }

    return d;
#line 252 "sipphononQMultiMap.cpp"
}


sipMappedType sipMappedTypeDef_QMultiMap_0200QString_0200QString = {
    "QMultiMap<QString,QString>",
    release_QMultiMap_0200QString_0200QString,
    forceConvertTo_QMultiMap_0200QString_0200QString,
    convertTo_QMultiMap_0200QString_0200QString,
    convertFrom_QMultiMap_0200QString_0200QString,
    assign_QMultiMap_0200QString_0200QString
};
