/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:55 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtSql.h"

#line 54 "sip/QtSql/qsqldatabase.sip"
#include <qsqldatabase.h>
#line 44 "sipQtSqlQSqlDatabase.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqldriver.sip"
#include <qsqldriver.h>
#line 51 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqldatabase.sip"
#include <qsqldatabase.h>
#line 54 "sipQtSqlQSqlDatabase.cpp"
#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 57 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqlerror.sip"
#include <qsqlerror.h>
#line 60 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqlquery.sip"
#include <qsqlquery.h>
#line 63 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqlrecord.sip"
#include <qsqlrecord.h>
#line 66 "sipQtSqlQSqlDatabase.cpp"
#line 42 "sip/QtSql/qsqlindex.sip"
#include <qsqlindex.h>
#line 69 "sipQtSqlQSqlDatabase.cpp"
#line 45 "sip/QtSql/qsql.sip"
#include <qsql.h>
#line 72 "sipQtSqlQSqlDatabase.cpp"


class sipQSqlDatabase : public QSqlDatabase
{
public:
    sipQSqlDatabase();
    sipQSqlDatabase(const QSqlDatabase&);
    sipQSqlDatabase(const QString&);
    sipQSqlDatabase(QSqlDriver *);
    ~sipQSqlDatabase();

public:
    sipWrapper *sipPySelf;

private:
    sipQSqlDatabase(const sipQSqlDatabase &);
    sipQSqlDatabase &operator = (const sipQSqlDatabase &);
};

sipQSqlDatabase::sipQSqlDatabase(): QSqlDatabase(), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQSqlDatabase::sipQSqlDatabase(const QSqlDatabase& a0): QSqlDatabase(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQSqlDatabase::sipQSqlDatabase(const QString& a0): QSqlDatabase(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQSqlDatabase::sipQSqlDatabase(QSqlDriver *a0): QSqlDatabase(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQSqlDatabase::~sipQSqlDatabase()
{
    sipCommonDtor(sipPySelf);
}


extern "C" {static PyObject *meth_QSqlDatabase_open(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_open(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->open();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1J1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->open(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_open);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_close(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_close(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->close();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_close);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_isOpen(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isOpen(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isOpen();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_isOpen);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_isOpenError(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isOpenError(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isOpenError();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_isOpenError);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_tables(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_tables(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSql::TableType a0 = QSql::Tables;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|E",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipEnum_QSql_TableType,&a0))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->tables(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_tables);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_primaryIndex(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_primaryIndex(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QSqlIndex *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlIndex(sipCpp->primaryIndex(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlIndex,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_primaryIndex);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_record(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_record(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QSqlRecord *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlRecord(sipCpp->record(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlRecord,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_record);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_exec_(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_exec_(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString& a0def = QString();
        const QString * a0 = &a0def;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|J1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QSqlQuery *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlQuery(sipCpp->exec(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlQuery,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_exec_);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_lastError(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_lastError(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QSqlError *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlError(sipCpp->lastError());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlError,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_lastError);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_isValid(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_transaction(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_transaction(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->transaction();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_transaction);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_commit(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_commit(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->commit();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_commit);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_rollback(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_rollback(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->rollback();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_rollback);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setDatabaseName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setDatabaseName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setDatabaseName(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setDatabaseName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setUserName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setUserName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setUserName(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setUserName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setPassword(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setPassword(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPassword(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setPassword);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setHostName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setHostName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setHostName(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setHostName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setPort(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setPort(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QSqlDatabase,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPort(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setPort);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_setConnectOptions(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setConnectOptions(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString& a0def = QString();
        const QString * a0 = &a0def;
        int a0State = 0;
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|J1",&sipSelf,sipClass_QSqlDatabase,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setConnectOptions(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_setConnectOptions);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_databaseName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_databaseName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->databaseName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_databaseName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_userName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_userName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->userName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_userName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_password(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_password(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->password());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_password);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_hostName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_hostName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->hostName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_hostName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_driverName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_driverName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->driverName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_driverName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_port(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_port(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->port();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_port);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_connectOptions(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectOptions(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->connectOptions());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_connectOptions);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_connectionName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectionName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->connectionName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_connectionName);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_driver(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_driver(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QSqlDatabase,&sipCpp))
        {
            QSqlDriver *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->driver();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QSqlDriver,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_driver);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_addDatabase(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_addDatabase(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        const QString& a1def = QLatin1String(QSqlDatabase::defaultConnection);
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            QSqlDatabase *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlDatabase(QSqlDatabase::addDatabase(*a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlDatabase,NULL);
        }
    }

    {
        QSqlDriver * a0;
        const QString& a1def = QLatin1String(QSqlDatabase::defaultConnection);
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J@|J1",sipClass_QSqlDriver,&a0,sipClass_QString,&a1,&a1State))
        {
            QSqlDatabase *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlDatabase(QSqlDatabase::addDatabase(a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlDatabase,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_addDatabase);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_cloneDatabase(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_cloneDatabase(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSqlDatabase * a0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"JAJ1",sipClass_QSqlDatabase,&a0,sipClass_QString,&a1,&a1State))
        {
            QSqlDatabase *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlDatabase(QSqlDatabase::cloneDatabase(*a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlDatabase,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_cloneDatabase);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_database(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_database(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString& a0def = QLatin1String(QSqlDatabase::defaultConnection);
        const QString * a0 = &a0def;
        int a0State = 0;
        bool a1 = 1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"|J1b",sipClass_QString,&a0,&a0State,&a1))
        {
            QSqlDatabase *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSqlDatabase(QSqlDatabase::database(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QSqlDatabase,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_database);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_removeDatabase(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_removeDatabase(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            QSqlDatabase::removeDatabase(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_removeDatabase);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_contains(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_contains(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString& a0def = QLatin1String(QSqlDatabase::defaultConnection);
        const QString * a0 = &a0def;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"|J1",sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QSqlDatabase::contains(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_contains);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_drivers(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_drivers(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(QSqlDatabase::drivers());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_drivers);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_connectionNames(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectionNames(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(QSqlDatabase::connectionNames());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_connectionNames);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_registerSqlDriver(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_registerSqlDriver(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QSqlDriverCreatorBase * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1JB",sipClass_QString,&a0,&a0State,sipClass_QSqlDriverCreatorBase,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            QSqlDatabase::registerSqlDriver(*a0,a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_registerSqlDriver);

    return NULL;
}


extern "C" {static PyObject *meth_QSqlDatabase_isDriverAvailable(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isDriverAvailable(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QSqlDatabase::isDriverAvailable(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtSql_QSqlDatabase,sipNm_QtSql_isDriverAvailable);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QSqlDatabase(void *, sipWrapperType *);}
static void *cast_QSqlDatabase(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QSqlDatabase)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QSqlDatabase(void *, int);}
static void release_QSqlDatabase(void *sipCppV,int state)
{
    Py_BEGIN_ALLOW_THREADS

    if (state & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQSqlDatabase *>(sipCppV);
    else
        delete reinterpret_cast<QSqlDatabase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QSqlDatabase(void *, const void*);}
static void assign_QSqlDatabase(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QSqlDatabase *>(sipDst) = *reinterpret_cast<const QSqlDatabase *>(sipSrc);
}


extern "C" {static void dealloc_QSqlDatabase(sipWrapper *);}
static void dealloc_QSqlDatabase(sipWrapper *sipSelf)
{
    if (sipIsDerived(sipSelf))
        reinterpret_cast<sipQSqlDatabase *>(sipSelf->u.cppPtr)->sipPySelf = NULL;

    if (sipIsPyOwned(sipSelf))
    {
        release_QSqlDatabase(sipSelf->u.cppPtr,sipSelf->flags);
    }
}


extern "C" {static void *init_QSqlDatabase(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QSqlDatabase(sipWrapper *sipSelf,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    sipQSqlDatabase *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQSqlDatabase();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QSqlDatabase * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QSqlDatabase,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQSqlDatabase(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQSqlDatabase(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
        }
    }

    if (!sipCpp)
    {
        QSqlDriver * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J@",sipClass_QSqlDriver,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQSqlDatabase(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (sipCpp)
        sipCpp->sipPySelf = sipSelf;

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QSqlDatabase(PyObject *, int *);}
static void *forceConvertTo_QSqlDatabase(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QSqlDatabase))
        return sipConvertToCpp(valobj,sipClass_QSqlDatabase,iserrp);

    sipBadClass(sipNm_QtSql_QSqlDatabase);

    *iserrp = 1;

    return NULL;
}


static PyMethodDef methods_QSqlDatabase[] = {
    {sipNm_QtSql_addDatabase, meth_QSqlDatabase_addDatabase, METH_VARARGS, NULL},
    {sipNm_QtSql_cloneDatabase, meth_QSqlDatabase_cloneDatabase, METH_VARARGS, NULL},
    {sipNm_QtSql_close, meth_QSqlDatabase_close, METH_VARARGS, NULL},
    {sipNm_QtSql_commit, meth_QSqlDatabase_commit, METH_VARARGS, NULL},
    {sipNm_QtSql_connectOptions, meth_QSqlDatabase_connectOptions, METH_VARARGS, NULL},
    {sipNm_QtSql_connectionName, meth_QSqlDatabase_connectionName, METH_VARARGS, NULL},
    {sipNm_QtSql_connectionNames, meth_QSqlDatabase_connectionNames, METH_VARARGS, NULL},
    {sipNm_QtSql_contains, meth_QSqlDatabase_contains, METH_VARARGS, NULL},
    {sipNm_QtSql_database, meth_QSqlDatabase_database, METH_VARARGS, NULL},
    {sipNm_QtSql_databaseName, meth_QSqlDatabase_databaseName, METH_VARARGS, NULL},
    {sipNm_QtSql_driver, meth_QSqlDatabase_driver, METH_VARARGS, NULL},
    {sipNm_QtSql_driverName, meth_QSqlDatabase_driverName, METH_VARARGS, NULL},
    {sipNm_QtSql_drivers, meth_QSqlDatabase_drivers, METH_VARARGS, NULL},
    {sipNm_QtSql_exec_, meth_QSqlDatabase_exec_, METH_VARARGS, NULL},
    {sipNm_QtSql_hostName, meth_QSqlDatabase_hostName, METH_VARARGS, NULL},
    {sipNm_QtSql_isDriverAvailable, meth_QSqlDatabase_isDriverAvailable, METH_VARARGS, NULL},
    {sipNm_QtSql_isOpen, meth_QSqlDatabase_isOpen, METH_VARARGS, NULL},
    {sipNm_QtSql_isOpenError, meth_QSqlDatabase_isOpenError, METH_VARARGS, NULL},
    {sipNm_QtSql_isValid, meth_QSqlDatabase_isValid, METH_VARARGS, NULL},
    {sipNm_QtSql_lastError, meth_QSqlDatabase_lastError, METH_VARARGS, NULL},
    {sipNm_QtSql_open, meth_QSqlDatabase_open, METH_VARARGS, NULL},
    {sipNm_QtSql_password, meth_QSqlDatabase_password, METH_VARARGS, NULL},
    {sipNm_QtSql_port, meth_QSqlDatabase_port, METH_VARARGS, NULL},
    {sipNm_QtSql_primaryIndex, meth_QSqlDatabase_primaryIndex, METH_VARARGS, NULL},
    {sipNm_QtSql_record, meth_QSqlDatabase_record, METH_VARARGS, NULL},
    {sipNm_QtSql_registerSqlDriver, meth_QSqlDatabase_registerSqlDriver, METH_VARARGS, NULL},
    {sipNm_QtSql_removeDatabase, meth_QSqlDatabase_removeDatabase, METH_VARARGS, NULL},
    {sipNm_QtSql_rollback, meth_QSqlDatabase_rollback, METH_VARARGS, NULL},
    {sipNm_QtSql_setConnectOptions, meth_QSqlDatabase_setConnectOptions, METH_VARARGS, NULL},
    {sipNm_QtSql_setDatabaseName, meth_QSqlDatabase_setDatabaseName, METH_VARARGS, NULL},
    {sipNm_QtSql_setHostName, meth_QSqlDatabase_setHostName, METH_VARARGS, NULL},
    {sipNm_QtSql_setPassword, meth_QSqlDatabase_setPassword, METH_VARARGS, NULL},
    {sipNm_QtSql_setPort, meth_QSqlDatabase_setPort, METH_VARARGS, NULL},
    {sipNm_QtSql_setUserName, meth_QSqlDatabase_setUserName, METH_VARARGS, NULL},
    {sipNm_QtSql_tables, meth_QSqlDatabase_tables, METH_VARARGS, NULL},
    {sipNm_QtSql_transaction, meth_QSqlDatabase_transaction, METH_VARARGS, NULL},
    {sipNm_QtSql_userName, meth_QSqlDatabase_userName, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtSql_QSqlDatabase = {
    0,
    0,
    "QtSql.QSqlDatabase",
    0,
    {0, 0, 1},
    0,
    0,
    37, methods_QSqlDatabase,
    0, 0,
    0,
    init_QSqlDatabase,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QSqlDatabase,
    cast_QSqlDatabase,
    release_QSqlDatabase,
    forceConvertTo_QSqlDatabase,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QSqlDatabase,
    0
};
