/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:51 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 46 "sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 44 "sipQtGuiQPolygon.cpp"

#line 211 "sip/QtCore/qvector.sip"
#include <qvector.h>
#include <qpair.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sip/QtCore/qvector.sip"
#include <qvector.h>
#line 69 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtGui/qcolor.sip"
#include <qcolor.h>
#line 72 "sipQtGuiQPolygon.cpp"
#line 42 "sip/QtGui/qabstracttextdocumentlayout.sip"
#include <qabstracttextdocumentlayout.h>
#line 53 "sip/QtGui/qabstracttextdocumentlayout.sip"
#include <qabstracttextdocumentlayout.h>
#line 64 "sip/QtGui/qabstracttextdocumentlayout.sip"
#include <qabstracttextdocumentlayout.h>
#line 79 "sipQtGuiQPolygon.cpp"
#line 108 "sip/QtCore/qline.sip"
#include <qline.h>
#line 82 "sipQtGuiQPolygon.cpp"
#line 93 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 85 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtCore/qline.sip"
#include <qline.h>
#line 88 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 91 "sipQtGuiQPolygon.cpp"
#line 159 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 94 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 97 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 100 "sipQtGuiQPolygon.cpp"
#line 50 "sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 103 "sipQtGuiQPolygon.cpp"
#line 46 "sip/QtGui/qmatrix.sip"
#include <qmatrix.h>
#line 106 "sipQtGuiQPolygon.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 109 "sipQtGuiQPolygon.cpp"
#line 50 "sip/QtGui/qpolygon.sip"
// Set the points of a polygon from a Python list.
static bool setPointsFromList(QPolygon *poly, PyObject *l)
{
    int *coords = new int[PyList_GET_SIZE(l)];

    for (SIP_SSIZE_T i = 0; i < PyList_GET_SIZE(l); ++i)
    {
        coords[i] = PyInt_AsLong(PyList_GET_ITEM(l, i));

        if (PyErr_Occurred() != NULL)
        {
            delete[] coords;
            return false;
        }
    }

    poly->setPoints(PyList_GET_SIZE(l) >> 1, coords);

    delete[] coords;
    return true;
}
#line 132 "sipQtGuiQPolygon.cpp"


extern "C" {static PyObject *meth_QPolygon_translate(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_translate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_translate);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_boundingRect(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_boundingRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->boundingRect());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_boundingRect);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_point(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_point(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QPolygon,&sipCpp,&a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->point(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_point);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_setPoints(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoints(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        PyObject * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BT",&sipSelf,sipClass_QPolygon,&sipCpp,&PyList_Type,&a0))
        {
            int sipIsErr = 0;

#line 119 "sip/QtGui/qpolygon.sip"
        if (!setPointsFromList(sipCpp, a0))
            sipIsErr = 1;
#line 249 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        PyObject * a2;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiiW",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1,&a2))
        {
#line 125 "sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_GET_SIZE(a2) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a0;
        points[1] = a1;
        
        for (SIP_SSIZE_T i = 0; i < PyTuple_GET_SIZE(a2); ++i)
            points[2 + i] = PyInt_AsLong(PyTuple_GET_ITEM(a2, i));
        
        sipCpp->setPoints(nPoints, points);
        
        delete[] points;
#line 282 "sipQtGuiQPolygon.cpp"

            Py_DECREF(a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_setPoints);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_putPoints(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_putPoints(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        PyObject * a3;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiiiW",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1,&a2,&a3))
        {
#line 143 "sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_GET_SIZE(a3) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a1;
        points[1] = a2;
        
        for (SIP_SSIZE_T i = 0; i < PyTuple_GET_SIZE(a3); ++i)
            points[2 + i] = PyInt_AsLong(PyTuple_GET_ITEM(a3, i));
        
        sipCpp->putPoints(a0, nPoints, points);
        
        delete[] points;
#line 327 "sipQtGuiQPolygon.cpp"

            Py_DECREF(a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        const QPolygon * a2;
        int a3 = 0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiiJA|i",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1,sipClass_QPolygon,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->putPoints(a0,a1,*a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_putPoints);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_setPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoint(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJA",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,sipClass_QPoint,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPoint(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        int a2;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biii",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1,&a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPoint(a0,a1,a2);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_setPoint);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_containsPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_containsPoint(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        Qt::FillRule a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJAE",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0,sipEnum_Qt_FillRule,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->containsPoint(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_containsPoint);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_united(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_united(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPolygon,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->united(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_united);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_intersected(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_intersected(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPolygon,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->intersected(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_intersected);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_subtracted(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_subtracted(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPolygon,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->subtracted(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_subtracted);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_append(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_append(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->append(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_append);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_at(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_at(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QPolygon,&sipCpp,&a0))
        {
            const QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->at(a0);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(const_cast<QPoint *>(sipRes),sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_at);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_clear(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_clear(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->clear();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_clear);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_contains(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_contains(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_contains);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_count(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_count(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count(*a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_count);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_fill(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_fill(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        int a1 = -1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|i",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->fill(*a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_fill);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_first(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_first(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->first();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_first);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_indexOf(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_indexOf(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        int a1 = 0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|i",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_indexOf);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_insert(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_insert(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJA",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,sipClass_QPoint,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_insert);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_last(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_last(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->last();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_last);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_lastIndexOf(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_lastIndexOf(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        int a1 = -1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|i",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_lastIndexOf);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_mid(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_mid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1 = -1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi|i",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->mid(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_mid);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_prepend(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_prepend(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QPolygon,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->prepend(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_prepend);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_remove(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_remove(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QPolygon,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->remove(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->remove(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_remove);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_replace(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_replace(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJA",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,sipClass_QPoint,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->replace(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_replace);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_size(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QPolygon,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->size();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_size);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_value(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_value(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QPolygon,&sipCpp,&a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->value(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BiJA",&sipSelf,sipClass_QPolygon,&sipCpp,&a0,sipClass_QPoint,&a1))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->value(a0,*a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui_value);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___mul__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QPolygon___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        const QPolygon * a0;
        const QTransform * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QPolygon,&a0,sipClass_QTransform,&a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    {
        const QPolygon * a0;
        const QMatrix * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QPolygon,&a0,sipClass_QMatrix,&a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static int slot_QPolygon___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QPolygon___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        const QPoint * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPoint,&a0))
        {
            int sipRes = 0;

#line 316 "sip/QtGui/qpolygon.sip"
// It looks like you can't assign QBool to int.
sipRes = bool(sipCpp->contains(*a0));
#line 1126 "sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui___contains__);

    return -1;
}


extern "C" {static int slot_QPolygon___delitem__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QPolygon___delitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1i",&a0))
        {
            int sipIsErr = 0;

#line 268 "sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    sipCpp->remove(a0);
#line 1165 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1T",&PySlice_Type,&a0))
        {
            int sipIsErr = 0;

#line 280 "sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
    for (i = 0; i < slicelength; ++i)
    {
        sipCpp->remove(start);
        start += step - 1;
    }
#line 1194 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui___delitem__);

    return -1;
}


extern "C" {static int slot_QPolygon___setitem__(PyObject *sipSelf,PyObject *sipArgs);}
static int slot_QPolygon___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        int a0;
        const QPoint * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"iJA",&a0,sipClass_QPoint,&a1))
        {
            int sipIsErr = 0;

#line 225 "sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    (*sipCpp)[a0] = *a1;
#line 1237 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const QPolygon * a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"TJA",&PySlice_Type,&a0,sipClass_QPolygon,&a1))
        {
            int sipIsErr = 0;

#line 237 "sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
{
    int vlen = a1->count();

    if (vlen != slicelength)
    {
        sipBadLengthForSlice(vlen, slicelength);
        sipIsErr = 1;
    }
    else
    {
        QVector<QPoint>::const_iterator it = a1->begin();

        for (i = 0; i < slicelength; ++i)
        {
            (*sipCpp)[start] = *it;
            start += step;
            ++it;
        }
    }
}
#line 1282 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui___setitem__);

    return -1;
}


extern "C" {static int slot_QPolygon___len__(PyObject *sipSelf);}
static int slot_QPolygon___len__(PyObject *sipSelf)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 220 "sip/QtGui/qpolygon.sip"
    sipRes = sipCpp->count();
#line 1313 "sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QPolygon___getitem__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        int a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1i",&a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*sipCpp)[a0];
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1T",&PySlice_Type,&a0))
        {
            QPolygon *sipRes = 0;
            int sipIsErr = 0;

#line 296 "sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
{
    sipRes = new QPolygon();

    for (i = 0; i < slicelength; ++i)
    {
        (*sipRes) += (*sipCpp)[start];
        start += step;
    }
}
#line 1371 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtGui_QPolygon,sipNm_QtGui___getitem__);

    return 0;
}


extern "C" {static PyObject *slot_QPolygon___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPolygon,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QPolygon::operator==(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,eq_slot,sipClass_QPolygon,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QPolygon___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPolygon,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QPolygon::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QPoint * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QPolygon::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___add__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___add__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPolygon,&a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->QPolygon::operator+(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPolygon,NULL);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,concat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QPolygon));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPolygon,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QPolygon::operator!=(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtGui,ne_slot,sipClass_QPolygon,sipSelf,sipArg);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QPolygon(void *, sipWrapperType *);}
static void *cast_QPolygon(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QPolygon)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QPolygon(void *, int);}
static void release_QPolygon(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QPolygon *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QPolygon(void *);}
static PyObject *pickle_QPolygon(void *sipCppV)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipCppV);
    PyObject *sipRes;

#line 74 "sip/QtGui/qpolygon.sip"
    PyObject *pl = PyList_New(sipCpp->count() * 2);
    
    for (int p = 0, i = 0; i < sipCpp->count(); ++i, p += 2)
    {
        int x, y;
    
        sipCpp->point(i, &x, &y);
    
        PyList_SET_ITEM(pl, p, PyInt_FromLong(x));
        PyList_SET_ITEM(pl, p + 1, PyInt_FromLong(y));
    }
    
    sipRes = Py_BuildValue((char *)"(N)", pl);
#line 1565 "sipQtGuiQPolygon.cpp"

    return sipRes;
}


extern "C" {static void assign_QPolygon(void *, const void*);}
static void assign_QPolygon(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QPolygon *>(sipDst) = *reinterpret_cast<const QPolygon *>(sipSrc);
}


extern "C" {static void dealloc_QPolygon(sipWrapper *);}
static void dealloc_QPolygon(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QPolygon(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QPolygon(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QPolygon(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QPolygon *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QPolygon * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QPolygon,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QVector<QPoint> * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"M1",sipMappedType_QVector_0200QPoint,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseMappedType(const_cast<QVector<QPoint> *>(a0),sipMappedType_QVector_0200QPoint,a0State);
        }
    }

    if (!sipCpp)
    {
        const QRect * a0;
        bool a1 = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA|b",sipClass_QRect,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0,a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"i",&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int sipIsErr = 0;
        PyObject * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"T",&PyList_Type,&a0))
        {
#line 98 "sip/QtGui/qpolygon.sip"
        sipCpp = new QPolygon();
        
        if (!setPointsFromList(sipCpp, a0))
        {
            delete sipCpp;
            sipCpp = 0;
            sipIsErr = 1;
        }
#line 1671 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;
        }
    }

    if (!sipCpp)
    {
        const QVariant * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QVariant,&a0))
        {
#line 110 "sip/QtGui/qpolygon.sip"
        sipCpp = new QPolygon(qVariantValue<QPolygon>(*a0));
#line 1686 "sipQtGuiQPolygon.cpp"
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QPolygon(PyObject *, int *);}
static void *forceConvertTo_QPolygon(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QPolygon))
        return sipConvertToCpp(valobj,sipClass_QPolygon,iserrp);

    sipBadClass(sipNm_QtGui_QPolygon);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPolygon[] = {
    {(void *)slot_QPolygon___mul__, mul_slot},
    {(void *)slot_QPolygon___contains__, contains_slot},
    {(void *)slot_QPolygon___delitem__, delitem_slot},
    {(void *)slot_QPolygon___setitem__, setitem_slot},
    {(void *)slot_QPolygon___len__, len_slot},
    {(void *)slot_QPolygon___getitem__, getitem_slot},
    {(void *)slot_QPolygon___eq__, eq_slot},
    {(void *)slot_QPolygon___iadd__, iconcat_slot},
    {(void *)slot_QPolygon___add__, concat_slot},
    {(void *)slot_QPolygon___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPolygon[] = {
    {sipNm_QtGui_append, meth_QPolygon_append, METH_VARARGS, NULL},
    {sipNm_QtGui_at, meth_QPolygon_at, METH_VARARGS, NULL},
    {sipNm_QtGui_boundingRect, meth_QPolygon_boundingRect, METH_VARARGS, NULL},
    {sipNm_QtGui_clear, meth_QPolygon_clear, METH_VARARGS, NULL},
    {sipNm_QtGui_contains, meth_QPolygon_contains, METH_VARARGS, NULL},
    {sipNm_QtGui_containsPoint, meth_QPolygon_containsPoint, METH_VARARGS, NULL},
    {sipNm_QtGui_count, meth_QPolygon_count, METH_VARARGS, NULL},
    {sipNm_QtGui_fill, meth_QPolygon_fill, METH_VARARGS, NULL},
    {sipNm_QtGui_first, meth_QPolygon_first, METH_VARARGS, NULL},
    {sipNm_QtGui_indexOf, meth_QPolygon_indexOf, METH_VARARGS, NULL},
    {sipNm_QtGui_insert, meth_QPolygon_insert, METH_VARARGS, NULL},
    {sipNm_QtGui_intersected, meth_QPolygon_intersected, METH_VARARGS, NULL},
    {sipNm_QtGui_isEmpty, meth_QPolygon_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtGui_last, meth_QPolygon_last, METH_VARARGS, NULL},
    {sipNm_QtGui_lastIndexOf, meth_QPolygon_lastIndexOf, METH_VARARGS, NULL},
    {sipNm_QtGui_mid, meth_QPolygon_mid, METH_VARARGS, NULL},
    {sipNm_QtGui_point, meth_QPolygon_point, METH_VARARGS, NULL},
    {sipNm_QtGui_prepend, meth_QPolygon_prepend, METH_VARARGS, NULL},
    {sipNm_QtGui_putPoints, meth_QPolygon_putPoints, METH_VARARGS, NULL},
    {sipNm_QtGui_remove, meth_QPolygon_remove, METH_VARARGS, NULL},
    {sipNm_QtGui_replace, meth_QPolygon_replace, METH_VARARGS, NULL},
    {sipNm_QtGui_setPoint, meth_QPolygon_setPoint, METH_VARARGS, NULL},
    {sipNm_QtGui_setPoints, meth_QPolygon_setPoints, METH_VARARGS, NULL},
    {sipNm_QtGui_size, meth_QPolygon_size, METH_VARARGS, NULL},
    {sipNm_QtGui_subtracted, meth_QPolygon_subtracted, METH_VARARGS, NULL},
    {sipNm_QtGui_translate, meth_QPolygon_translate, METH_VARARGS, NULL},
    {sipNm_QtGui_united, meth_QPolygon_united, METH_VARARGS, NULL},
    {sipNm_QtGui_value, meth_QPolygon_value, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtGui_QPolygon = {
    0,
    0,
    "QtGui.QPolygon",
    0,
    {0, 0, 1},
    0,
    slots_QPolygon,
    28, methods_QPolygon,
    0, 0,
    0,
    init_QPolygon,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QPolygon,
    cast_QPolygon,
    release_QPolygon,
    forceConvertTo_QPolygon,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QPolygon,
    assign_QPolygon,
    0
};
