/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 160 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 44 "sipQtCoreQTime.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQTime.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 51 "sipQtCoreQTime.cpp"
#line 164 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
#include <datetime.h>
#endif
#line 56 "sipQtCoreQTime.cpp"


extern "C" {static PyObject *meth_QTime_toPyTime(PyObject *, PyObject *);}
static PyObject *meth_QTime_toPyTime(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            PyObject * sipRes = 0;

#line 229 "sip/QtCore/qdatetime.sip"
        if (!PyDateTimeAPI)
            PyDateTime_IMPORT;
        
        // Convert to a Python time object.
        sipRes = PyTime_FromTime(sipCpp->hour(), sipCpp->minute(), sipCpp->second(), sipCpp->msec() * 1000);
#line 77 "sipQtCoreQTime.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_toPyTime);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_isNull(PyObject *, PyObject *);}
static PyObject *meth_QTime_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_isValid(PyObject *, PyObject *);}
static PyObject *meth_QTime_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        int a2;
        int a3 = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"iii|i",&a0,&a1,&a2,&a3))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QTime::isValid(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_hour(PyObject *, PyObject *);}
static PyObject *meth_QTime_hour(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->hour();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_hour);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_minute(PyObject *, PyObject *);}
static PyObject *meth_QTime_minute(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->minute();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_minute);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_second(PyObject *, PyObject *);}
static PyObject *meth_QTime_second(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->second();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_second);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_msec(PyObject *, PyObject *);}
static PyObject *meth_QTime_msec(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->msec();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_msec);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_toString(PyObject *, PyObject *);}
static PyObject *meth_QTime_toString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::DateFormat a0 = Qt::TextDate;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|E",&sipSelf,sipClass_QTime,&sipCpp,sipEnum_Qt_DateFormat,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QTime,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->toString(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_toString);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_setHMS(PyObject *, PyObject *);}
static PyObject *meth_QTime_setHMS(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3 = 0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biii|i",&sipSelf,sipClass_QTime,&sipCpp,&a0,&a1,&a2,&a3))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->setHMS(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_setHMS);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_addSecs(PyObject *, PyObject *);}
static PyObject *meth_QTime_addSecs(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QTime,&sipCpp,&a0))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(sipCpp->addSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_addSecs);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_secsTo(PyObject *, PyObject *);}
static PyObject *meth_QTime_secsTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QTime,&sipCpp,sipClass_QTime,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->secsTo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_secsTo);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_addMSecs(PyObject *, PyObject *);}
static PyObject *meth_QTime_addMSecs(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QTime,&sipCpp,&a0))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(sipCpp->addMSecs(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_addMSecs);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_msecsTo(PyObject *, PyObject *);}
static PyObject *meth_QTime_msecsTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QTime,&sipCpp,sipClass_QTime,&a0,&a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->msecsTo(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_msecsTo);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_currentTime(PyObject *, PyObject *);}
static PyObject *meth_QTime_currentTime(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(QTime::currentTime());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_currentTime);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_fromString(PyObject *, PyObject *);}
static PyObject *meth_QTime_fromString(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        Qt::DateFormat a1 = Qt::TextDate;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|E",sipClass_QString,&a0,&a0State,sipEnum_Qt_DateFormat,&a1))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(QTime::fromString(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            QTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QTime(QTime::fromString(*a0,*a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_fromString);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_start(PyObject *, PyObject *);}
static PyObject *meth_QTime_start(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->start();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_start);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_restart(PyObject *, PyObject *);}
static PyObject *meth_QTime_restart(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->restart();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_restart);

    return NULL;
}


extern "C" {static PyObject *meth_QTime_elapsed(PyObject *, PyObject *);}
static PyObject *meth_QTime_elapsed(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QTime *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QTime,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->elapsed();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QTime,sipNm_QtCore_elapsed);

    return NULL;
}


extern "C" {static PyObject *slot_QTime___ge__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___ge__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator>=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ge_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTime___gt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___gt__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator>(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,gt_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTime___le__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___le__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator<=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,le_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTime___lt__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___lt__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator<(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lt_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTime___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator!=(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QTime___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QTime___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1J1",sipClass_QTime,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QTime::operator==(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QTime,sipSelf,sipArg);
}


extern "C" {static int slot_QTime___nonzero__(PyObject *sipSelf);}
static int slot_QTime___nonzero__(PyObject *sipSelf)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 240 "sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 830 "sipQtCoreQTime.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QTime___repr__(PyObject *sipSelf);}
static PyObject *slot_QTime___repr__(PyObject *sipSelf)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QTime));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 210 "sip/QtCore/qdatetime.sip"
        sipRes = PyString_FromFormat("PyQt4.QtCore.QTime(%i, %i", sipCpp->hour(),
                sipCpp->minute());
        
        if (sipCpp->second() || sipCpp->msec())
        {
            PyString_ConcatAndDel(&sipRes,
                    PyString_FromFormat(", %i", sipCpp->second()));
        
            if (sipCpp->msec())
                PyString_ConcatAndDel(&sipRes,
                        PyString_FromFormat(", %i", sipCpp->msec()));
        }
        
        PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
#line 866 "sipQtCoreQTime.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QTime(void *, sipWrapperType *);}
static void *cast_QTime(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QTime)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QTime(void *, int);}
static void release_QTime(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QTime *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QTime(void *);}
static PyObject *pickle_QTime(void *sipCppV)
{
    QTime *sipCpp = reinterpret_cast<QTime *>(sipCppV);
    PyObject *sipRes;

#line 202 "sip/QtCore/qdatetime.sip"
    sipRes = Py_BuildValue((char *)"iiii", sipCpp->hour(), sipCpp->minute(), sipCpp->second(), sipCpp->msec());
#line 905 "sipQtCoreQTime.cpp"

    return sipRes;
}


extern "C" {static void assign_QTime(void *, const void*);}
static void assign_QTime(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QTime *>(sipDst) = *reinterpret_cast<const QTime *>(sipSrc);
}


extern "C" {static void dealloc_QTime(sipWrapper *);}
static void dealloc_QTime(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QTime(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QTime(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QTime(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QTime *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTime();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;
        int a1;
        int a2 = 0;
        int a3 = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"ii|ii",&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTime(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QTime * a0;
        int a0State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1",sipClass_QTime,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QTime(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QTime *>(a0),sipClass_QTime,a0State);
        }
    }

    return sipCpp;
}


extern "C" {static int convertTo_QTime(PyObject *, void **, int *, PyObject *);}
static int convertTo_QTime(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QTime **sipCppPtr = reinterpret_cast<QTime **>(sipCppPtrV);

#line 170 "sip/QtCore/qdatetime.sip"
#if PY_VERSION_HEX >= 0x02040000
    if (!PyDateTimeAPI)
        PyDateTime_IMPORT;
#endif

// Allow a Python time object whenever a QTime is expected.

if (sipIsErr == NULL)
    return (
#if PY_VERSION_HEX >= 0x02040000
            PyTime_Check(sipPy) ||
#endif
            sipCanConvertToInstance(sipPy, sipClass_QTime, SIP_NO_CONVERTORS));

#if PY_VERSION_HEX >= 0x02040000
if (PyTime_Check(sipPy))
{
    *sipCppPtr = new QTime(PyDateTime_TIME_GET_HOUR(sipPy),
                           PyDateTime_TIME_GET_MINUTE(sipPy),
                           PyDateTime_TIME_GET_SECOND(sipPy),
                           PyDateTime_TIME_GET_MICROSECOND(sipPy) / 1000);

    return sipGetState(sipTransferObj);
}
#endif

*sipCppPtr = reinterpret_cast<QTime *>(sipConvertToInstance(sipPy, sipClass_QTime, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1012 "sipQtCoreQTime.cpp"
}


extern "C" {static void *forceConvertTo_QTime(PyObject *, int *);}
static void *forceConvertTo_QTime(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (convertTo_QTime(valobj,NULL,NULL,NULL))
    {
        void *val;

        /*
         * Note that we throw away the flag that says if the value
         * has just been created on the heap or not.
         */
        convertTo_QTime(valobj,&val,iserrp,NULL);

        return val;
    }

    sipBadClass(sipNm_QtCore_QTime);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QTime[] = {
    {(void *)slot_QTime___ge__, ge_slot},
    {(void *)slot_QTime___gt__, gt_slot},
    {(void *)slot_QTime___le__, le_slot},
    {(void *)slot_QTime___lt__, lt_slot},
    {(void *)slot_QTime___ne__, ne_slot},
    {(void *)slot_QTime___eq__, eq_slot},
    {(void *)slot_QTime___nonzero__, nonzero_slot},
    {(void *)slot_QTime___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QTime[] = {
    {sipNm_QtCore_addMSecs, meth_QTime_addMSecs, METH_VARARGS, NULL},
    {sipNm_QtCore_addSecs, meth_QTime_addSecs, METH_VARARGS, NULL},
    {sipNm_QtCore_currentTime, meth_QTime_currentTime, METH_VARARGS, NULL},
    {sipNm_QtCore_elapsed, meth_QTime_elapsed, METH_VARARGS, NULL},
    {sipNm_QtCore_fromString, meth_QTime_fromString, METH_VARARGS, NULL},
    {sipNm_QtCore_hour, meth_QTime_hour, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QTime_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QTime_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_minute, meth_QTime_minute, METH_VARARGS, NULL},
    {sipNm_QtCore_msec, meth_QTime_msec, METH_VARARGS, NULL},
    {sipNm_QtCore_msecsTo, meth_QTime_msecsTo, METH_VARARGS, NULL},
    {sipNm_QtCore_restart, meth_QTime_restart, METH_VARARGS, NULL},
    {sipNm_QtCore_second, meth_QTime_second, METH_VARARGS, NULL},
    {sipNm_QtCore_secsTo, meth_QTime_secsTo, METH_VARARGS, NULL},
    {sipNm_QtCore_setHMS, meth_QTime_setHMS, METH_VARARGS, NULL},
    {sipNm_QtCore_start, meth_QTime_start, METH_VARARGS, NULL},
    {sipNm_QtCore_toPyTime, meth_QTime_toPyTime, METH_VARARGS, NULL},
    {sipNm_QtCore_toString, meth_QTime_toString, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QTime = {
    0,
    0,
    "QtCore.QTime",
    0,
    {0, 0, 1},
    0,
    slots_QTime,
    18, methods_QTime,
    0, 0,
    0,
    init_QTime,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QTime,
    cast_QTime,
    release_QTime,
    forceConvertTo_QTime,
    convertTo_QTime,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QTime,
    assign_QTime,
    0
};
