/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 44 "sip/QtCore/qresource.sip"
#include <qresource.h>
#line 44 "sipQtCoreQResource.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQResource.cpp"
#line 46 "sip/QtCore/qlocale.sip"
#include <qlocale.h>
#line 51 "sipQtCoreQResource.cpp"
#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 54 "sipQtCoreQResource.cpp"


class sipQResource : public QResource
{
public:
    sipQResource(const QString&,const QLocale&);
    sipQResource(const QResource&);
    ~sipQResource();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    QStringList sipProtect_children() const;
    bool sipProtect_isDir() const;
    bool sipProtect_isFile() const;

public:
    sipWrapper *sipPySelf;

private:
    sipQResource(const sipQResource &);
    sipQResource &operator = (const sipQResource &);
};

sipQResource::sipQResource(const QString& a0,const QLocale& a1): QResource(a0,a1), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQResource::sipQResource(const QResource& a0): QResource(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQResource::~sipQResource()
{
    sipCommonDtor(sipPySelf);
}

QStringList sipQResource::sipProtect_children() const
{
    return QResource::children();
}

bool sipQResource::sipProtect_isDir() const
{
    return QResource::isDir();
}

bool sipQResource::sipProtect_isFile() const
{
    return QResource::isFile();
}


extern "C" {static PyObject *meth_QResource_absoluteFilePath(PyObject *, PyObject *);}
static PyObject *meth_QResource_absoluteFilePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->absoluteFilePath());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_absoluteFilePath);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_data(PyObject *, PyObject *);}
static PyObject *meth_QResource_data(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            const unsigned char *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->data();
            Py_END_ALLOW_THREADS

            if (sipRes == NULL)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyString_FromString((char *)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_data);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_fileName(PyObject *, PyObject *);}
static PyObject *meth_QResource_fileName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->fileName());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_fileName);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_isCompressed(PyObject *, PyObject *);}
static PyObject *meth_QResource_isCompressed(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isCompressed();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_isCompressed);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_isValid(PyObject *, PyObject *);}
static PyObject *meth_QResource_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_locale(PyObject *, PyObject *);}
static PyObject *meth_QResource_locale(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            QLocale *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QLocale(sipCpp->locale());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QLocale,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_locale);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_setFileName(PyObject *, PyObject *);}
static PyObject *meth_QResource_setFileName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QResource,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setFileName(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_setFileName);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_setLocale(PyObject *, PyObject *);}
static PyObject *meth_QResource_setLocale(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QLocale * a0;
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QResource,&sipCpp,sipClass_QLocale,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setLocale(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_setLocale);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_size(PyObject *, PyObject *);}
static PyObject *meth_QResource_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QResource,&sipCpp))
        {
            PY_LONG_LONG sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->size();
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_size);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_addSearchPath(PyObject *, PyObject *);}
static PyObject *meth_QResource_addSearchPath(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            QResource::addSearchPath(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_addSearchPath);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_registerResource(PyObject *, PyObject *);}
static PyObject *meth_QResource_registerResource(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        const QString& a1def = QString();
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QResource::registerResource(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_registerResource);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_registerResourceData(PyObject *, PyObject *);}
static PyObject *meth_QResource_registerResourceData(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const unsigned char * a0;
        const QString& a1def = QString();
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"s|J1",&a0,sipClass_QString,&a1,&a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QResource::registerResource(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_registerResourceData);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_searchPaths(PyObject *, PyObject *);}
static PyObject *meth_QResource_searchPaths(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        if (sipParseArgs(&sipArgsParsed,sipArgs,""))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(QResource::searchPaths());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_searchPaths);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_unregisterResource(PyObject *, PyObject *);}
static PyObject *meth_QResource_unregisterResource(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        const QString& a1def = QString();
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1|J1",sipClass_QString,&a0,&a0State,sipClass_QString,&a1,&a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QResource::unregisterResource(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_unregisterResource);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_unregisterResourceData(PyObject *, PyObject *);}
static PyObject *meth_QResource_unregisterResourceData(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const unsigned char * a0;
        const QString& a1def = QString();
        const QString * a1 = &a1def;
        int a1State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"s|J1",&a0,sipClass_QString,&a1,&a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QResource::unregisterResource(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_unregisterResourceData);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_children(PyObject *, PyObject *);}
static PyObject *meth_QResource_children(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        sipQResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"p",&sipSelf,sipClass_QResource,&sipCpp))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->sipProtect_children());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_children);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_isDir(PyObject *, PyObject *);}
static PyObject *meth_QResource_isDir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        sipQResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"p",&sipSelf,sipClass_QResource,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_isDir();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_isDir);

    return NULL;
}


extern "C" {static PyObject *meth_QResource_isFile(PyObject *, PyObject *);}
static PyObject *meth_QResource_isFile(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        sipQResource *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"p",&sipSelf,sipClass_QResource,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_isFile();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QResource,sipNm_QtCore_isFile);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QResource(void *, sipWrapperType *);}
static void *cast_QResource(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QResource)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QResource(void *, int);}
static void release_QResource(void *sipCppV,int state)
{
    Py_BEGIN_ALLOW_THREADS

    if (state & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQResource *>(sipCppV);
    else
        delete reinterpret_cast<QResource *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QResource(void *, const void*);}
static void assign_QResource(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QResource *>(sipDst) = *reinterpret_cast<const QResource *>(sipSrc);
}


extern "C" {static void dealloc_QResource(sipWrapper *);}
static void dealloc_QResource(sipWrapper *sipSelf)
{
    if (sipIsDerived(sipSelf))
        reinterpret_cast<sipQResource *>(sipSelf->u.cppPtr)->sipPySelf = NULL;

    if (sipIsPyOwned(sipSelf))
    {
        release_QResource(sipSelf->u.cppPtr,sipSelf->flags);
    }
}


extern "C" {static void *init_QResource(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QResource(sipWrapper *sipSelf,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    sipQResource *sipCpp = 0;

    if (!sipCpp)
    {
        const QString& a0def = QString();
        const QString * a0 = &a0def;
        int a0State = 0;
        const QLocale& a1def = QLocale();
        const QLocale * a1 = &a1def;

        if (sipParseArgs(sipArgsParsed,sipArgs,"|J1JA",sipClass_QString,&a0,&a0State,sipClass_QLocale,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQResource(*a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
        }
    }

    if (!sipCpp)
    {
        const QResource * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QResource,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQResource(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (sipCpp)
        sipCpp->sipPySelf = sipSelf;

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QResource(PyObject *, int *);}
static void *forceConvertTo_QResource(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QResource))
        return sipConvertToCpp(valobj,sipClass_QResource,iserrp);

    sipBadClass(sipNm_QtCore_QResource);

    *iserrp = 1;

    return NULL;
}


static PyMethodDef methods_QResource[] = {
    {sipNm_QtCore_absoluteFilePath, meth_QResource_absoluteFilePath, METH_VARARGS, NULL},
    {sipNm_QtCore_addSearchPath, meth_QResource_addSearchPath, METH_VARARGS, NULL},
    {sipNm_QtCore_children, meth_QResource_children, METH_VARARGS, NULL},
    {sipNm_QtCore_data, meth_QResource_data, METH_VARARGS, NULL},
    {sipNm_QtCore_fileName, meth_QResource_fileName, METH_VARARGS, NULL},
    {sipNm_QtCore_isCompressed, meth_QResource_isCompressed, METH_VARARGS, NULL},
    {sipNm_QtCore_isDir, meth_QResource_isDir, METH_VARARGS, NULL},
    {sipNm_QtCore_isFile, meth_QResource_isFile, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QResource_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_locale, meth_QResource_locale, METH_VARARGS, NULL},
    {sipNm_QtCore_registerResource, meth_QResource_registerResource, METH_VARARGS, NULL},
    {sipNm_QtCore_registerResourceData, meth_QResource_registerResourceData, METH_VARARGS, NULL},
    {sipNm_QtCore_searchPaths, meth_QResource_searchPaths, METH_VARARGS, NULL},
    {sipNm_QtCore_setFileName, meth_QResource_setFileName, METH_VARARGS, NULL},
    {sipNm_QtCore_setLocale, meth_QResource_setLocale, METH_VARARGS, NULL},
    {sipNm_QtCore_size, meth_QResource_size, METH_VARARGS, NULL},
    {sipNm_QtCore_unregisterResource, meth_QResource_unregisterResource, METH_VARARGS, NULL},
    {sipNm_QtCore_unregisterResourceData, meth_QResource_unregisterResourceData, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QResource = {
    0,
    0,
    "QtCore.QResource",
    0,
    {0, 0, 1},
    0,
    0,
    18, methods_QResource,
    0, 0,
    0,
    init_QResource,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QResource,
    cast_QResource,
    release_QResource,
    forceConvertTo_QResource,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QResource,
    0
};
