/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 44 "sipQtCoreQRegExp.cpp"

#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 48 "sipQtCoreQRegExp.cpp"
#line 45 "sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 51 "sipQtCoreQRegExp.cpp"
#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 54 "sipQtCoreQRegExp.cpp"


extern "C" {static PyObject *meth_QRegExp_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_isValid(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_pattern(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_pattern(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->pattern());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_pattern);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_setPattern(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_setPattern(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QRegExp,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPattern(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_setPattern);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_caseSensitivity(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_caseSensitivity(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            Qt::CaseSensitivity sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->caseSensitivity();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_Qt_CaseSensitivity);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_caseSensitivity);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_setCaseSensitivity(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_setCaseSensitivity(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        Qt::CaseSensitivity a0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QRegExp,&sipCpp,sipEnum_Qt_CaseSensitivity,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setCaseSensitivity(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_setCaseSensitivity);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_patternSyntax(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_patternSyntax(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            QRegExp::PatternSyntax sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->patternSyntax();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QRegExp_PatternSyntax);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_patternSyntax);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_setPatternSyntax(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_setPatternSyntax(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp::PatternSyntax a0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QRegExp,&sipCpp,sipEnum_QRegExp_PatternSyntax,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPatternSyntax(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_setPatternSyntax);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_isMinimal(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_isMinimal(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isMinimal();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_isMinimal);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_setMinimal(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_setMinimal(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        bool a0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bb",&sipSelf,sipClass_QRegExp,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setMinimal(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_setMinimal);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_exactMatch(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_exactMatch(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QRegExp,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->exactMatch(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_exactMatch);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_indexIn(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_indexIn(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = 0;
        QRegExp::CaretMode a2 = QRegExp::CaretAtZero;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|iE",&sipSelf,sipClass_QRegExp,&sipCpp,sipClass_QString,&a0,&a0State,&a1,sipEnum_QRegExp_CaretMode,&a2))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexIn(*a0,a1,a2);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_indexIn);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_lastIndexIn(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_lastIndexIn(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = -1;
        QRegExp::CaretMode a2 = QRegExp::CaretAtZero;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1|iE",&sipSelf,sipClass_QRegExp,&sipCpp,sipClass_QString,&a0,&a0State,&a1,sipEnum_QRegExp_CaretMode,&a2))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexIn(*a0,a1,a2);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_lastIndexIn);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_matchedLength(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_matchedLength(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->matchedLength();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_matchedLength);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_numCaptures(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_numCaptures(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->numCaptures();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_numCaptures);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_capturedTexts(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_capturedTexts(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->capturedTexts());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_capturedTexts);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_cap(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_cap(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0 = 0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|i",&sipSelf,sipClass_QRegExp,&sipCpp,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->cap(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_cap);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_pos(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_pos(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0 = 0;
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|i",&sipSelf,sipClass_QRegExp,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->pos(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_pos);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_errorString(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_errorString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRegExp *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRegExp,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->errorString());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_errorString);

    return NULL;
}


extern "C" {static PyObject *meth_QRegExp_escape(PyObject *, PyObject *);}
static PyObject *meth_QRegExp_escape(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(QRegExp::escape(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRegExp,sipNm_QtCore_escape);

    return NULL;
}


extern "C" {static PyObject *slot_QRegExp___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRegExp___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QRegExp *sipCpp = reinterpret_cast<QRegExp *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRegExp));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRegExp * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRegExp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QRegExp::operator!=(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QRegExp,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRegExp___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRegExp___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QRegExp *sipCpp = reinterpret_cast<QRegExp *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRegExp));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRegExp * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRegExp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QRegExp::operator==(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QRegExp,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRegExp___repr__(PyObject *sipSelf);}
static PyObject *slot_QRegExp___repr__(PyObject *sipSelf)
{
    QRegExp *sipCpp = reinterpret_cast<QRegExp *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRegExp));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 73 "sip/QtCore/qregexp.sip"
        QString patt = sipCpp->pattern();
        PyObject *uni = qtcore_QStringToPyUnicode(&patt);
        
        if (uni)
        {
            sipRes = PyString_FromString("PyQt4.QtCore.QRegExp(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(uni));
        
            if (sipCpp->caseSensitivity() != Qt::CaseSensitive ||
                sipCpp->patternSyntax() != QRegExp::RegExp)
            {
                PyString_ConcatAndDel(&sipRes,
                        PyString_FromFormat(", PyQt4.QtCore.Qt.CaseSensitivity(%i)",
                                (int)sipCpp->caseSensitivity()));
        
                if (sipCpp->patternSyntax() != QRegExp::RegExp)
                    PyString_ConcatAndDel(&sipRes,
                            PyString_FromFormat(
                                    ", PyQt4.QtCore.QRegExp.PatternSyntax(%i)",
                                    (int)sipCpp->patternSyntax()));
            }
        
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        
            Py_DECREF(uni);
        }
        else
            sipRes = 0;
#line 721 "sipQtCoreQRegExp.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QRegExp(void *, sipWrapperType *);}
static void *cast_QRegExp(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QRegExp)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QRegExp(void *, int);}
static void release_QRegExp(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QRegExp *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QRegExp(void *, const void*);}
static void assign_QRegExp(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QRegExp *>(sipDst) = *reinterpret_cast<const QRegExp *>(sipSrc);
}


extern "C" {static void dealloc_QRegExp(sipWrapper *);}
static void dealloc_QRegExp(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QRegExp(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QRegExp(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QRegExp(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QRegExp *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRegExp();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QString * a0;
        int a0State = 0;
        Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        QRegExp::PatternSyntax a2 = QRegExp::RegExp;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J1|EE",sipClass_QString,&a0,&a0State,sipEnum_Qt_CaseSensitivity,&a1,sipEnum_QRegExp_PatternSyntax,&a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRegExp(*a0,a1,a2);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);
        }
    }

    if (!sipCpp)
    {
        const QRegExp * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QRegExp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRegExp(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QRegExp(PyObject *, int *);}
static void *forceConvertTo_QRegExp(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QRegExp))
        return sipConvertToCpp(valobj,sipClass_QRegExp,iserrp);

    sipBadClass(sipNm_QtCore_QRegExp);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QRegExp[] = {
    {(void *)slot_QRegExp___ne__, ne_slot},
    {(void *)slot_QRegExp___eq__, eq_slot},
    {(void *)slot_QRegExp___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QRegExp[] = {
    {sipNm_QtCore_cap, meth_QRegExp_cap, METH_VARARGS, NULL},
    {sipNm_QtCore_capturedTexts, meth_QRegExp_capturedTexts, METH_VARARGS, NULL},
    {sipNm_QtCore_caseSensitivity, meth_QRegExp_caseSensitivity, METH_VARARGS, NULL},
    {sipNm_QtCore_errorString, meth_QRegExp_errorString, METH_VARARGS, NULL},
    {sipNm_QtCore_escape, meth_QRegExp_escape, METH_VARARGS, NULL},
    {sipNm_QtCore_exactMatch, meth_QRegExp_exactMatch, METH_VARARGS, NULL},
    {sipNm_QtCore_indexIn, meth_QRegExp_indexIn, METH_VARARGS, NULL},
    {sipNm_QtCore_isEmpty, meth_QRegExp_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtCore_isMinimal, meth_QRegExp_isMinimal, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QRegExp_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_lastIndexIn, meth_QRegExp_lastIndexIn, METH_VARARGS, NULL},
    {sipNm_QtCore_matchedLength, meth_QRegExp_matchedLength, METH_VARARGS, NULL},
    {sipNm_QtCore_numCaptures, meth_QRegExp_numCaptures, METH_VARARGS, NULL},
    {sipNm_QtCore_pattern, meth_QRegExp_pattern, METH_VARARGS, NULL},
    {sipNm_QtCore_patternSyntax, meth_QRegExp_patternSyntax, METH_VARARGS, NULL},
    {sipNm_QtCore_pos, meth_QRegExp_pos, METH_VARARGS, NULL},
    {sipNm_QtCore_setCaseSensitivity, meth_QRegExp_setCaseSensitivity, METH_VARARGS, NULL},
    {sipNm_QtCore_setMinimal, meth_QRegExp_setMinimal, METH_VARARGS, NULL},
    {sipNm_QtCore_setPattern, meth_QRegExp_setPattern, METH_VARARGS, NULL},
    {sipNm_QtCore_setPatternSyntax, meth_QRegExp_setPatternSyntax, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QRegExp[] = {
    {sipNm_QtCore_CaretAtOffset, QRegExp::CaretAtOffset, 29},
    {sipNm_QtCore_CaretAtZero, QRegExp::CaretAtZero, 29},
    {sipNm_QtCore_CaretWontMatch, QRegExp::CaretWontMatch, 29},
    {sipNm_QtCore_FixedString, QRegExp::FixedString, 30},
    {sipNm_QtCore_RegExp, QRegExp::RegExp, 30},
    {sipNm_QtCore_RegExp2, QRegExp::RegExp2, 30},
    {sipNm_QtCore_Wildcard, QRegExp::Wildcard, 30},
};


sipTypeDef sipType_QtCore_QRegExp = {
    0,
    0,
    "QtCore.QRegExp",
    0,
    {0, 0, 1},
    0,
    slots_QRegExp,
    20, methods_QRegExp,
    7, enummembers_QRegExp,
    0,
    init_QRegExp,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QRegExp,
    cast_QRegExp,
    release_QRegExp,
    forceConvertTo_QRegExp,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    assign_QRegExp,
    0
};
