/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Tue Nov  3 22:16:49 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 159 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 44 "sipQtCoreQRectF.cpp"

#line 93 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 48 "sipQtCoreQRectF.cpp"
#line 99 "sip/QtCore/qsize.sip"
#include <qsize.h>
#line 51 "sipQtCoreQRectF.cpp"
#line 46 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 54 "sipQtCoreQRectF.cpp"


extern "C" {static PyObject *meth_QRectF_normalized(PyObject *, PyObject *);}
static PyObject *meth_QRectF_normalized(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->normalized());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_normalized);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_left(PyObject *, PyObject *);}
static PyObject *meth_QRectF_left(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->left();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_left);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_top(PyObject *, PyObject *);}
static PyObject *meth_QRectF_top(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->top();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_top);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_right(PyObject *, PyObject *);}
static PyObject *meth_QRectF_right(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->right();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_right);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_bottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->bottom();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_bottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setX(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setX(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setX(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setX);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setY(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setY(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setY(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setY);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_topLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_topLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->topLeft());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_topLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_bottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->bottomRight());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_bottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_topRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_topRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->topRight());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_topRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_bottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_bottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->bottomLeft());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_bottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_contains(PyObject *, PyObject *);}
static PyObject *meth_QRectF_contains(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        double a0;
        double a1;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_contains);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_intersects(PyObject *, PyObject *);}
static PyObject *meth_QRectF_intersects(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->intersects(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_intersects);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_isNull(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_isValid(PyObject *, PyObject *);}
static PyObject *meth_QRectF_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_x(PyObject *, PyObject *);}
static PyObject *meth_QRectF_x(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->x();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_x);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_y(PyObject *, PyObject *);}
static PyObject *meth_QRectF_y(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->y();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_y);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setLeft(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setRight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setTop(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTop(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTop(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setTop);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setBottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottom(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setBottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTopLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTopLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setTopLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setTopRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTopRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setTopRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottomLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setBottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setBottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottomRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setBottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_center(PyObject *, PyObject *);}
static PyObject *meth_QRectF_center(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QPointF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPointF(sipCpp->center());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPointF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_center);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveLeft(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveTop(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTop(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTop(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveTop);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveRight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveBottom(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottom(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveBottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTopLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTopLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveTopLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTopRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTopRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveTopRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottomLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveBottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveBottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottomRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveBottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveCenter(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveCenter(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveCenter(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveCenter);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_width(PyObject *, PyObject *);}
static PyObject *meth_QRectF_width(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->width();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_width);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_height(PyObject *, PyObject *);}
static PyObject *meth_QRectF_height(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->height();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_height);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_size(PyObject *, PyObject *);}
static PyObject *meth_QRectF_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QSizeF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSizeF(sipCpp->size());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSizeF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_size);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_translate(PyObject *, PyObject *);}
static PyObject *meth_QRectF_translate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_translate);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_moveTo(PyObject *, PyObject *);}
static PyObject *meth_QRectF_moveTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTo(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTo(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_moveTo);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_translated(PyObject *, PyObject *);}
static PyObject *meth_QRectF_translated(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->translated(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    {
        const QPointF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QPointF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->translated(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_translated);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_getRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_getRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->getRect(&a0,&a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(dddd)",a0,a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_getRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdddd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setRect(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_getCoords(PyObject *, PyObject *);}
static PyObject *meth_QRectF_getCoords(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->getCoords(&a0,&a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(dddd)",a0,a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_getCoords);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setCoords(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setCoords(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdddd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setCoords(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setCoords);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_adjust(PyObject *, PyObject *);}
static PyObject *meth_QRectF_adjust(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdddd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->adjust(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_adjust);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_adjusted(PyObject *, PyObject *);}
static PyObject *meth_QRectF_adjusted(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        double a1;
        double a2;
        double a3;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bdddd",&sipSelf,sipClass_QRectF,&sipCpp,&a0,&a1,&a2,&a3))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->adjusted(a0,a1,a2,a3));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_adjusted);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setWidth(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setWidth(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setWidth(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setWidth);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setHeight(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setHeight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QRectF,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setHeight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setHeight);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_setSize(PyObject *, PyObject *);}
static PyObject *meth_QRectF_setSize(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSizeF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QSizeF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setSize(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_setSize);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_intersect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_intersect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->intersect(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_intersect);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_unite(PyObject *, PyObject *);}
static PyObject *meth_QRectF_unite(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->unite(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_unite);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_toAlignedRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_toAlignedRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->toAlignedRect());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_toAlignedRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_toRect(PyObject *, PyObject *);}
static PyObject *meth_QRectF_toRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRectF,&sipCpp))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->toRect());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_toRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_intersected(PyObject *, PyObject *);}
static PyObject *meth_QRectF_intersected(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->intersected(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_intersected);

    return NULL;
}


extern "C" {static PyObject *meth_QRectF_united(PyObject *, PyObject *);}
static PyObject *meth_QRectF_united(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRectF * a0;
        QRectF *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRectF,&sipCpp,sipClass_QRectF,&a0))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF(sipCpp->united(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore_united);

    return NULL;
}


extern "C" {static PyObject *slot_QRectF___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRectF___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRectF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRectF,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QRectF,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRectF___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRectF___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRectF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRectF,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QRectF,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRectF___iand__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRectF___iand__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QRectF))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRectF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRectF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QRectF::operator&=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QRectF___ior__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRectF___ior__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QRectF))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRectF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRectF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QRectF::operator|=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QRectF___nonzero__(PyObject *sipSelf);}
static int slot_QRectF___nonzero__(PyObject *sipSelf)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 233 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->isValid();
#line 1849 "sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }
}


extern "C" {static int slot_QRectF___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QRectF___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        const QPointF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPointF,&a0))
        {
            int sipRes = 0;

#line 218 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 1876 "sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    {
        const QRectF * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRectF,&a0))
        {
            int sipRes = 0;

#line 224 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 1891 "sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRectF,sipNm_QtCore___contains__);

    return -1;
}


extern "C" {static PyObject *slot_QRectF___and__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QRectF___and__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QRectF * a0;
        const QRectF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QRectF,&a0,sipClass_QRectF,&a1))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF((*a0 & *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,and_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QRectF___or__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QRectF___or__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QRectF * a0;
        const QRectF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QRectF,&a0,sipClass_QRectF,&a1))
        {
            QRectF *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRectF((*a0 | *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRectF,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,or_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QRectF___repr__(PyObject *sipSelf);}
static PyObject *slot_QRectF___repr__(PyObject *sipSelf)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRectF));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 176 "sip/QtCore/qrect.sip"
        PyObject *l = PyFloat_FromDouble(sipCpp->left());
        PyObject *t = PyFloat_FromDouble(sipCpp->top());
        PyObject *w = PyFloat_FromDouble(sipCpp->width());
        PyObject *h = PyFloat_FromDouble(sipCpp->height());
        
        if (l && t && w && h)
        {
            sipRes = PyString_FromString("PyQt4.QtCore.QRectF(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(l));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(t));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(w));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(h));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        }
        else
            sipRes = 0;
        
        Py_XDECREF(l);
        Py_XDECREF(t);
        Py_XDECREF(w);
        Py_XDECREF(h);
#line 1992 "sipQtCoreQRectF.cpp"

            return sipRes;
        }
    }
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QRectF(void *, sipWrapperType *);}
static void *cast_QRectF(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QRectF)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QRectF(void *, int);}
static void release_QRectF(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QRectF *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QRectF(void *);}
static PyObject *pickle_QRectF(void *sipCppV)
{
    QRectF *sipCpp = reinterpret_cast<QRectF *>(sipCppV);
    PyObject *sipRes;

#line 163 "sip/QtCore/qrect.sip"
    sipRes = Py_BuildValue((char *)"dddd", sipCpp->x(), sipCpp->y(), sipCpp->width(), sipCpp->height());
#line 2031 "sipQtCoreQRectF.cpp"

    return sipRes;
}


extern "C" {static void assign_QRectF(void *, const void*);}
static void assign_QRectF(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QRectF *>(sipDst) = *reinterpret_cast<const QRectF *>(sipSrc);
}


extern "C" {static void dealloc_QRectF(sipWrapper *);}
static void dealloc_QRectF(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QRectF(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QRectF(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QRectF(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QRectF *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QPointF * a0;
        const QSizeF * a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JAJA",sipClass_QPointF,&a0,sipClass_QSizeF,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF(*a0,*a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QPointF * a0;
        const QPointF * a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JAJA",sipClass_QPointF,&a0,sipClass_QPointF,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF(*a0,*a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        double a0;
        double a1;
        double a2;
        double a3;

        if (sipParseArgs(sipArgsParsed,sipArgs,"dddd",&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QRect * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QRect,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QRectF * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QRectF,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRectF(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QRectF(PyObject *, int *);}
static void *forceConvertTo_QRectF(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QRectF))
        return sipConvertToCpp(valobj,sipClass_QRectF,iserrp);

    sipBadClass(sipNm_QtCore_QRectF);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QRectF[] = {
    {(void *)slot_QRectF___eq__, eq_slot},
    {(void *)slot_QRectF___ne__, ne_slot},
    {(void *)slot_QRectF___iand__, iand_slot},
    {(void *)slot_QRectF___ior__, ior_slot},
    {(void *)slot_QRectF___nonzero__, nonzero_slot},
    {(void *)slot_QRectF___contains__, contains_slot},
    {(void *)slot_QRectF___and__, and_slot},
    {(void *)slot_QRectF___or__, or_slot},
    {(void *)slot_QRectF___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QRectF[] = {
    {sipNm_QtCore_adjust, meth_QRectF_adjust, METH_VARARGS, NULL},
    {sipNm_QtCore_adjusted, meth_QRectF_adjusted, METH_VARARGS, NULL},
    {sipNm_QtCore_bottom, meth_QRectF_bottom, METH_VARARGS, NULL},
    {sipNm_QtCore_bottomLeft, meth_QRectF_bottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_bottomRight, meth_QRectF_bottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_center, meth_QRectF_center, METH_VARARGS, NULL},
    {sipNm_QtCore_contains, meth_QRectF_contains, METH_VARARGS, NULL},
    {sipNm_QtCore_getCoords, meth_QRectF_getCoords, METH_VARARGS, NULL},
    {sipNm_QtCore_getRect, meth_QRectF_getRect, METH_VARARGS, NULL},
    {sipNm_QtCore_height, meth_QRectF_height, METH_VARARGS, NULL},
    {sipNm_QtCore_intersect, meth_QRectF_intersect, METH_VARARGS, NULL},
    {sipNm_QtCore_intersected, meth_QRectF_intersected, METH_VARARGS, NULL},
    {sipNm_QtCore_intersects, meth_QRectF_intersects, METH_VARARGS, NULL},
    {sipNm_QtCore_isEmpty, meth_QRectF_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QRectF_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QRectF_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_left, meth_QRectF_left, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottom, meth_QRectF_moveBottom, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottomLeft, meth_QRectF_moveBottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottomRight, meth_QRectF_moveBottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_moveCenter, meth_QRectF_moveCenter, METH_VARARGS, NULL},
    {sipNm_QtCore_moveLeft, meth_QRectF_moveLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveRight, meth_QRectF_moveRight, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTo, meth_QRectF_moveTo, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTop, meth_QRectF_moveTop, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTopLeft, meth_QRectF_moveTopLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTopRight, meth_QRectF_moveTopRight, METH_VARARGS, NULL},
    {sipNm_QtCore_normalized, meth_QRectF_normalized, METH_VARARGS, NULL},
    {sipNm_QtCore_right, meth_QRectF_right, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottom, meth_QRectF_setBottom, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottomLeft, meth_QRectF_setBottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottomRight, meth_QRectF_setBottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setCoords, meth_QRectF_setCoords, METH_VARARGS, NULL},
    {sipNm_QtCore_setHeight, meth_QRectF_setHeight, METH_VARARGS, NULL},
    {sipNm_QtCore_setLeft, meth_QRectF_setLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setRect, meth_QRectF_setRect, METH_VARARGS, NULL},
    {sipNm_QtCore_setRight, meth_QRectF_setRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setSize, meth_QRectF_setSize, METH_VARARGS, NULL},
    {sipNm_QtCore_setTop, meth_QRectF_setTop, METH_VARARGS, NULL},
    {sipNm_QtCore_setTopLeft, meth_QRectF_setTopLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setTopRight, meth_QRectF_setTopRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setWidth, meth_QRectF_setWidth, METH_VARARGS, NULL},
    {sipNm_QtCore_setX, meth_QRectF_setX, METH_VARARGS, NULL},
    {sipNm_QtCore_setY, meth_QRectF_setY, METH_VARARGS, NULL},
    {sipNm_QtCore_size, meth_QRectF_size, METH_VARARGS, NULL},
    {sipNm_QtCore_toAlignedRect, meth_QRectF_toAlignedRect, METH_VARARGS, NULL},
    {sipNm_QtCore_toRect, meth_QRectF_toRect, METH_VARARGS, NULL},
    {sipNm_QtCore_top, meth_QRectF_top, METH_VARARGS, NULL},
    {sipNm_QtCore_topLeft, meth_QRectF_topLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_topRight, meth_QRectF_topRight, METH_VARARGS, NULL},
    {sipNm_QtCore_translate, meth_QRectF_translate, METH_VARARGS, NULL},
    {sipNm_QtCore_translated, meth_QRectF_translated, METH_VARARGS, NULL},
    {sipNm_QtCore_unite, meth_QRectF_unite, METH_VARARGS, NULL},
    {sipNm_QtCore_united, meth_QRectF_united, METH_VARARGS, NULL},
    {sipNm_QtCore_width, meth_QRectF_width, METH_VARARGS, NULL},
    {sipNm_QtCore_x, meth_QRectF_x, METH_VARARGS, NULL},
    {sipNm_QtCore_y, meth_QRectF_y, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QRectF = {
    0,
    0,
    "QtCore.QRectF",
    0,
    {0, 0, 1},
    0,
    slots_QRectF,
    57, methods_QRectF,
    0, 0,
    0,
    init_QRectF,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QRectF,
    cast_QRectF,
    release_QRectF,
    forceConvertTo_QRectF,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QRectF,
    assign_QRectF,
    0
};
