/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 44 "sipQtCoreQRect.cpp"

#line 46 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 48 "sipQtCoreQRect.cpp"
#line 46 "sip/QtCore/qsize.sip"
#include <qsize.h>
#line 51 "sipQtCoreQRect.cpp"


extern "C" {static PyObject *meth_QRect_normalized(PyObject *, PyObject *);}
static PyObject *meth_QRect_normalized(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->normalized());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_normalized);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveCenter(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveCenter(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveCenter(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveCenter);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_contains(PyObject *, PyObject *);}
static PyObject *meth_QRect_contains(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        bool a1 = 0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|b",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const QRect * a0;
        bool a1 = 0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA|b",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        bool a2;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biib",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1,&a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        int a0;
        int a1;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_contains);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_intersects(PyObject *, PyObject *);}
static PyObject *meth_QRect_intersects(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->intersects(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_intersects);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_isNull(PyObject *, PyObject *);}
static PyObject *meth_QRect_isNull(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isNull();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_isNull);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QRect_isEmpty(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_isEmpty);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_isValid(PyObject *, PyObject *);}
static PyObject *meth_QRect_isValid(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isValid();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_isValid);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_left(PyObject *, PyObject *);}
static PyObject *meth_QRect_left(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->left();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_left);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_top(PyObject *, PyObject *);}
static PyObject *meth_QRect_top(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->top();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_top);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_right(PyObject *, PyObject *);}
static PyObject *meth_QRect_right(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->right();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_right);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_bottom(PyObject *, PyObject *);}
static PyObject *meth_QRect_bottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->bottom();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_bottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_x(PyObject *, PyObject *);}
static PyObject *meth_QRect_x(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->x();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_x);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_y(PyObject *, PyObject *);}
static PyObject *meth_QRect_y(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->y();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_y);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_setLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setLeft(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setTop(PyObject *, PyObject *);}
static PyObject *meth_QRect_setTop(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTop(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setTop);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_setRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setRight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setBottom(PyObject *, PyObject *);}
static PyObject *meth_QRect_setBottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottom(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setBottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_setTopLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTopLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setTopLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_setBottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottomRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setBottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_setTopRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setTopRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setTopRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_setBottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setBottomLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setBottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setX(PyObject *, PyObject *);}
static PyObject *meth_QRect_setX(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setX(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setX);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setY(PyObject *, PyObject *);}
static PyObject *meth_QRect_setY(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setY(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setY);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_topLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_topLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->topLeft());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_topLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_bottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_bottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->bottomRight());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_bottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_topRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_topRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->topRight());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_topRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_bottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_bottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->bottomLeft());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_bottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_center(PyObject *, PyObject *);}
static PyObject *meth_QRect_center(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->center());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_center);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_width(PyObject *, PyObject *);}
static PyObject *meth_QRect_width(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->width();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_width);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_height(PyObject *, PyObject *);}
static PyObject *meth_QRect_height(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->height();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_height);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_size(PyObject *, PyObject *);}
static PyObject *meth_QRect_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            QSize *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QSize(sipCpp->size());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QSize,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_size);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_translate(PyObject *, PyObject *);}
static PyObject *meth_QRect_translate(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_translate);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_translated(PyObject *, PyObject *);}
static PyObject *meth_QRect_translated(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->translated(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->translated(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_translated);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveTo(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveTo(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTo(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTo(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveTo);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveLeft(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveTop(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveTop(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTop(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveTop);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveRight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveBottom(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveBottom(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottom(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveBottom);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveTopLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveTopLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTopLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveTopLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveBottomRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveBottomRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottomRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveBottomRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveTopRight(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveTopRight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveTopRight(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveTopRight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_moveBottomLeft(PyObject *, PyObject *);}
static PyObject *meth_QRect_moveBottomLeft(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QPoint * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QPoint,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->moveBottomLeft(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_moveBottomLeft);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_getRect(PyObject *, PyObject *);}
static PyObject *meth_QRect_getRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->getRect(&a0,&a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(iiii)",a0,a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_getRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setRect(PyObject *, PyObject *);}
static PyObject *meth_QRect_setRect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biiii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setRect(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setRect);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_getCoords(PyObject *, PyObject *);}
static PyObject *meth_QRect_getCoords(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QRect,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->getCoords(&a0,&a1,&a2,&a3);
            Py_END_ALLOW_THREADS

            return sipBuildResult(0,"(iiii)",a0,a1,a2,a3);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_getCoords);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setCoords(PyObject *, PyObject *);}
static PyObject *meth_QRect_setCoords(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biiii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setCoords(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setCoords);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_adjusted(PyObject *, PyObject *);}
static PyObject *meth_QRect_adjusted(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biiii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1,&a2,&a3))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->adjusted(a0,a1,a2,a3));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_adjusted);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_adjust(PyObject *, PyObject *);}
static PyObject *meth_QRect_adjust(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        int a1;
        int a2;
        int a3;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Biiii",&sipSelf,sipClass_QRect,&sipCpp,&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->adjust(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_adjust);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setWidth(PyObject *, PyObject *);}
static PyObject *meth_QRect_setWidth(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setWidth(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setWidth);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setHeight(PyObject *, PyObject *);}
static PyObject *meth_QRect_setHeight(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QRect,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setHeight(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setHeight);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_setSize(PyObject *, PyObject *);}
static PyObject *meth_QRect_setSize(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QSize * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QSize,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setSize(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_setSize);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_intersect(PyObject *, PyObject *);}
static PyObject *meth_QRect_intersect(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->intersect(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_intersect);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_unite(PyObject *, PyObject *);}
static PyObject *meth_QRect_unite(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->unite(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_unite);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_intersected(PyObject *, PyObject *);}
static PyObject *meth_QRect_intersected(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->intersected(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_intersected);

    return NULL;
}


extern "C" {static PyObject *meth_QRect_united(PyObject *, PyObject *);}
static PyObject *meth_QRect_united(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QRect * a0;
        QRect *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJA",&sipSelf,sipClass_QRect,&sipCpp,sipClass_QRect,&a0))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->united(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore_united);

    return NULL;
}


extern "C" {static PyObject *slot_QRect___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRect___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRect * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRect,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator==((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipClass_QRect,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRect___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRect___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRect * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRect,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = operator!=((*sipCpp), *a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipClass_QRect,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QRect___iand__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRect___iand__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QRect))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRect * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRect,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QRect::operator&=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QRect___ior__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QRect___ior__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf,(PyTypeObject *)sipClass_QRect))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return 0;

    int sipArgsParsed = 0;

    {
        const QRect * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRect,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QRect::operator|=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QRect___nonzero__(PyObject *sipSelf);}
static int slot_QRect___nonzero__(PyObject *sipSelf)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 86 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->isValid();
#line 1812 "sipQtCoreQRect.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QRect___repr__(PyObject *sipSelf);}
static PyObject *slot_QRect___repr__(PyObject *sipSelf)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return 0;


    {
        {
            PyObject * sipRes = 0;

#line 77 "sip/QtCore/qrect.sip"
        sipRes = PyString_FromFormat("PyQt4.QtCore.QRect(%i, %i, %i, %i)",
                sipCpp->left(), sipCpp->top(), sipCpp->width(), sipCpp->height());
#line 1836 "sipQtCoreQRect.cpp"

            return sipRes;
        }
    }
}


extern "C" {static int slot_QRect___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QRect___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipGetCppPtr((sipWrapper *)sipSelf,sipClass_QRect));

    if (!sipCpp)
        return -1;

    int sipArgsParsed = 0;

    {
        const QPoint * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QPoint,&a0))
        {
            int sipRes = 0;

#line 62 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 1863 "sipQtCoreQRect.cpp"

            return sipRes;
        }
    }

    {
        const QRect * a0;

        if (sipParseArgs(&sipArgsParsed,sipArg,"1JA",sipClass_QRect,&a0))
        {
            int sipRes = 0;

#line 68 "sip/QtCore/qrect.sip"
        sipRes = sipCpp->contains(*a0);
#line 1878 "sipQtCoreQRect.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QRect,sipNm_QtCore___contains__);

    return -1;
}


extern "C" {static PyObject *slot_QRect___and__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QRect___and__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QRect * a0;
        const QRect * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QRect,&a0,sipClass_QRect,&a1))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect((*a0 & *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,and_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QRect___or__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QRect___or__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QRect * a0;
        const QRect * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QRect,&a0,sipClass_QRect,&a1))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect((*a0 | *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QRect,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,or_slot,NULL,sipArg0,sipArg1);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QRect(void *, sipWrapperType *);}
static void *cast_QRect(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QRect)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QRect(void *, int);}
static void release_QRect(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QRect *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QRect(void *);}
static PyObject *pickle_QRect(void *sipCppV)
{
    QRect *sipCpp = reinterpret_cast<QRect *>(sipCppV);
    PyObject *sipRes;

#line 50 "sip/QtCore/qrect.sip"
    sipRes = Py_BuildValue((char *)"iiii", sipCpp->x(), sipCpp->y(), sipCpp->width(), sipCpp->height());
#line 1972 "sipQtCoreQRect.cpp"

    return sipRes;
}


extern "C" {static void assign_QRect(void *, const void*);}
static void assign_QRect(void *sipDst, const void *sipSrc)
{
    *reinterpret_cast<QRect *>(sipDst) = *reinterpret_cast<const QRect *>(sipSrc);
}


extern "C" {static void dealloc_QRect(sipWrapper *);}
static void dealloc_QRect(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QRect(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QRect(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QRect(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QRect *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRect();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        int a0;
        int a1;
        int a2;
        int a3;

        if (sipParseArgs(sipArgsParsed,sipArgs,"iiii",&a0,&a1,&a2,&a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRect(a0,a1,a2,a3);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QPoint * a0;
        const QPoint * a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JAJA",sipClass_QPoint,&a0,sipClass_QPoint,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRect(*a0,*a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QPoint * a0;
        const QSize * a1;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JAJA",sipClass_QPoint,&a0,sipClass_QSize,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRect(*a0,*a1);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        const QRect * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QRect,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QRect(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QRect(PyObject *, int *);}
static void *forceConvertTo_QRect(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QRect))
        return sipConvertToCpp(valobj,sipClass_QRect,iserrp);

    sipBadClass(sipNm_QtCore_QRect);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QRect[] = {
    {(void *)slot_QRect___eq__, eq_slot},
    {(void *)slot_QRect___ne__, ne_slot},
    {(void *)slot_QRect___iand__, iand_slot},
    {(void *)slot_QRect___ior__, ior_slot},
    {(void *)slot_QRect___nonzero__, nonzero_slot},
    {(void *)slot_QRect___repr__, repr_slot},
    {(void *)slot_QRect___contains__, contains_slot},
    {(void *)slot_QRect___and__, and_slot},
    {(void *)slot_QRect___or__, or_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QRect[] = {
    {sipNm_QtCore_adjust, meth_QRect_adjust, METH_VARARGS, NULL},
    {sipNm_QtCore_adjusted, meth_QRect_adjusted, METH_VARARGS, NULL},
    {sipNm_QtCore_bottom, meth_QRect_bottom, METH_VARARGS, NULL},
    {sipNm_QtCore_bottomLeft, meth_QRect_bottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_bottomRight, meth_QRect_bottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_center, meth_QRect_center, METH_VARARGS, NULL},
    {sipNm_QtCore_contains, meth_QRect_contains, METH_VARARGS, NULL},
    {sipNm_QtCore_getCoords, meth_QRect_getCoords, METH_VARARGS, NULL},
    {sipNm_QtCore_getRect, meth_QRect_getRect, METH_VARARGS, NULL},
    {sipNm_QtCore_height, meth_QRect_height, METH_VARARGS, NULL},
    {sipNm_QtCore_intersect, meth_QRect_intersect, METH_VARARGS, NULL},
    {sipNm_QtCore_intersected, meth_QRect_intersected, METH_VARARGS, NULL},
    {sipNm_QtCore_intersects, meth_QRect_intersects, METH_VARARGS, NULL},
    {sipNm_QtCore_isEmpty, meth_QRect_isEmpty, METH_VARARGS, NULL},
    {sipNm_QtCore_isNull, meth_QRect_isNull, METH_VARARGS, NULL},
    {sipNm_QtCore_isValid, meth_QRect_isValid, METH_VARARGS, NULL},
    {sipNm_QtCore_left, meth_QRect_left, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottom, meth_QRect_moveBottom, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottomLeft, meth_QRect_moveBottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveBottomRight, meth_QRect_moveBottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_moveCenter, meth_QRect_moveCenter, METH_VARARGS, NULL},
    {sipNm_QtCore_moveLeft, meth_QRect_moveLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveRight, meth_QRect_moveRight, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTo, meth_QRect_moveTo, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTop, meth_QRect_moveTop, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTopLeft, meth_QRect_moveTopLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_moveTopRight, meth_QRect_moveTopRight, METH_VARARGS, NULL},
    {sipNm_QtCore_normalized, meth_QRect_normalized, METH_VARARGS, NULL},
    {sipNm_QtCore_right, meth_QRect_right, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottom, meth_QRect_setBottom, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottomLeft, meth_QRect_setBottomLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setBottomRight, meth_QRect_setBottomRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setCoords, meth_QRect_setCoords, METH_VARARGS, NULL},
    {sipNm_QtCore_setHeight, meth_QRect_setHeight, METH_VARARGS, NULL},
    {sipNm_QtCore_setLeft, meth_QRect_setLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setRect, meth_QRect_setRect, METH_VARARGS, NULL},
    {sipNm_QtCore_setRight, meth_QRect_setRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setSize, meth_QRect_setSize, METH_VARARGS, NULL},
    {sipNm_QtCore_setTop, meth_QRect_setTop, METH_VARARGS, NULL},
    {sipNm_QtCore_setTopLeft, meth_QRect_setTopLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_setTopRight, meth_QRect_setTopRight, METH_VARARGS, NULL},
    {sipNm_QtCore_setWidth, meth_QRect_setWidth, METH_VARARGS, NULL},
    {sipNm_QtCore_setX, meth_QRect_setX, METH_VARARGS, NULL},
    {sipNm_QtCore_setY, meth_QRect_setY, METH_VARARGS, NULL},
    {sipNm_QtCore_size, meth_QRect_size, METH_VARARGS, NULL},
    {sipNm_QtCore_top, meth_QRect_top, METH_VARARGS, NULL},
    {sipNm_QtCore_topLeft, meth_QRect_topLeft, METH_VARARGS, NULL},
    {sipNm_QtCore_topRight, meth_QRect_topRight, METH_VARARGS, NULL},
    {sipNm_QtCore_translate, meth_QRect_translate, METH_VARARGS, NULL},
    {sipNm_QtCore_translated, meth_QRect_translated, METH_VARARGS, NULL},
    {sipNm_QtCore_unite, meth_QRect_unite, METH_VARARGS, NULL},
    {sipNm_QtCore_united, meth_QRect_united, METH_VARARGS, NULL},
    {sipNm_QtCore_width, meth_QRect_width, METH_VARARGS, NULL},
    {sipNm_QtCore_x, meth_QRect_x, METH_VARARGS, NULL},
    {sipNm_QtCore_y, meth_QRect_y, METH_VARARGS, NULL}
};


sipTypeDef sipType_QtCore_QRect = {
    0,
    0,
    "QtCore.QRect",
    0,
    {0, 0, 1},
    0,
    slots_QRect,
    55, methods_QRect,
    0, 0,
    0,
    init_QRect,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QRect,
    cast_QRect,
    release_QRect,
    forceConvertTo_QRect,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    pickle_QRect,
    assign_QRect,
    0
};
