/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 42 "sip/QtCore/qdatastream.sip"
#include <qdatastream.h>
#line 44 "sipQtCoreQDataStream.cpp"

#line 46 "sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 48 "sipQtCoreQDataStream.cpp"
#line 59 "sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 51 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 54 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 57 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/quuid.sip"
#include <quuid.h>
#line 60 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qurl.sip"
#include <qurl.h>
#line 63 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 66 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 69 "sipQtCoreQDataStream.cpp"
#line 99 "sip/QtCore/qsize.sip"
#include <qsize.h>
#line 72 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qsize.sip"
#include <qsize.h>
#line 75 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 78 "sipQtCoreQDataStream.cpp"
#line 159 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 81 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qrect.sip"
#include <qrect.h>
#line 84 "sipQtCoreQDataStream.cpp"
#line 93 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 87 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 90 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qlocale.sip"
#include <qlocale.h>
#line 93 "sipQtCoreQDataStream.cpp"
#line 108 "sip/QtCore/qline.sip"
#include <qline.h>
#line 96 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qline.sip"
#include <qline.h>
#line 99 "sipQtCoreQDataStream.cpp"
#line 274 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 102 "sipQtCoreQDataStream.cpp"
#line 160 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 105 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 108 "sipQtCoreQDataStream.cpp"
#line 81 "sip/QtCore/qchar.sip"
#include <qchar.h>
#line 111 "sipQtCoreQDataStream.cpp"
#line 46 "sip/QtCore/qbitarray.sip"
#include <qbitarray.h>
#line 114 "sipQtCoreQDataStream.cpp"


class sipQDataStream : public QDataStream
{
public:
    sipQDataStream();
    sipQDataStream(QIODevice *);
    sipQDataStream(QByteArray *,QIODevice::OpenMode);
    sipQDataStream(const QByteArray&);
    ~sipQDataStream();

public:
    sipWrapper *sipPySelf;

private:
    sipQDataStream(const sipQDataStream &);
    sipQDataStream &operator = (const sipQDataStream &);
};

sipQDataStream::sipQDataStream(): QDataStream(), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQDataStream::sipQDataStream(QIODevice *a0): QDataStream(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQDataStream::sipQDataStream(QByteArray *a0,QIODevice::OpenMode a1): QDataStream(a0,a1), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQDataStream::sipQDataStream(const QByteArray& a0): QDataStream(a0), sipPySelf(0)
{
    sipCommonCtor(NULL,0);
}

sipQDataStream::~sipQDataStream()
{
    sipCommonDtor(sipPySelf);
}


extern "C" {static PyObject *meth_QDataStream_device(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_device(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            QIODevice *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->device();
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QIODevice,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_device);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_setDevice(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_setDevice(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QIODevice * a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ@",&sipSelf,sipClass_QDataStream,&sipCpp,sipClass_QIODevice,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setDevice(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_setDevice);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_unsetDevice(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_unsetDevice(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->unsetDevice();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_unsetDevice);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_atEnd(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_atEnd(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->atEnd();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_atEnd);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_status(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_status(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            QDataStream::Status sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->status();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QDataStream_Status);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_status);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_setStatus(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_setStatus(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream::Status a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QDataStream,&sipCpp,sipEnum_QDataStream_Status,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setStatus(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_setStatus);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_resetStatus(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_resetStatus(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->resetStatus();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_resetStatus);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_byteOrder(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_byteOrder(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            QDataStream::ByteOrder sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->byteOrder();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QDataStream_ByteOrder);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_byteOrder);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_setByteOrder(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_setByteOrder(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream::ByteOrder a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QDataStream,&sipCpp,sipEnum_QDataStream_ByteOrder,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setByteOrder(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_setByteOrder);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_version(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_version(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->version();
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_version);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_setVersion(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_setVersion(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setVersion(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_setVersion);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_skipRawData(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_skipRawData(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->skipRawData(a0);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_skipRawData);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readInt8(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readInt8(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            signed char sipRes = 0;

#line 100 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 499 "sipQtCoreQDataStream.cpp"

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readInt8);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readUInt8(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readUInt8(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            unsigned char sipRes = 0;

#line 107 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 528 "sipQtCoreQDataStream.cpp"

            return PyString_FromStringAndSize((char *)&sipRes,1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readUInt8);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readInt16(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readInt16(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            short sipRes = 0;

#line 114 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 557 "sipQtCoreQDataStream.cpp"

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readInt16);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readUInt16(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readUInt16(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            unsigned short sipRes = 0;

#line 121 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 586 "sipQtCoreQDataStream.cpp"

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readUInt16);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readInt32(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readInt32(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            int sipRes = 0;

#line 128 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 615 "sipQtCoreQDataStream.cpp"

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readInt32);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readUInt32(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readUInt32(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            unsigned sipRes = 0;

#line 135 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 644 "sipQtCoreQDataStream.cpp"

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readUInt32);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readInt64(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readInt64(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            PY_LONG_LONG sipRes = 0;

#line 142 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 673 "sipQtCoreQDataStream.cpp"

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readInt64);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readUInt64(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readUInt64(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            unsigned PY_LONG_LONG sipRes = 0;

#line 149 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 702 "sipQtCoreQDataStream.cpp"

            return PyLong_FromUnsignedLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readUInt64);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readBool(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readBool(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            bool sipRes = 0;

#line 156 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 731 "sipQtCoreQDataStream.cpp"

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readBool);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readFloat(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readFloat(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            float sipRes = 0;

#line 163 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 760 "sipQtCoreQDataStream.cpp"

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readFloat);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readDouble(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readDouble(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            double sipRes = 0;

#line 170 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> sipRes;
    Py_END_ALLOW_THREADS
#line 789 "sipQtCoreQDataStream.cpp"

            return PyFloat_FromDouble(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readDouble);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readString(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            PyObject * sipRes = 0;

#line 177 "sip/QtCore/qdatastream.sip"
    char *s;

    Py_BEGIN_ALLOW_THREADS
    *sipCpp >> s;
    Py_END_ALLOW_THREADS

    if (s)
    {
        sipRes = PyString_FromString(s);
        delete[] s;
    }
    else
    {
        sipRes = Py_None;
        Py_INCREF(Py_None);
    }
#line 831 "sipQtCoreQDataStream.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readString);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeInt8(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeInt8(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        signed char a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bc",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 197 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 859 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeInt8);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeUInt8(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeUInt8(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned char a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bc",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 204 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 888 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeUInt8);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeInt16(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeInt16(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        short a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bh",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 211 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 917 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeInt16);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeUInt16(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeUInt16(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned short a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bt",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 218 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 946 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeUInt16);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeInt32(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeInt32(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 225 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 975 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeInt32);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeUInt32(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeUInt32(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bu",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 232 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1004 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeUInt32);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeInt64(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeInt64(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        PY_LONG_LONG a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 239 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1033 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeInt64);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeUInt64(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeUInt64(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        unsigned PY_LONG_LONG a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bo",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 246 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1062 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeUInt64);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeBool(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeBool(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        bool a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bb",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 253 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1091 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeBool);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeFloat(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeFloat(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        float a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bf",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 260 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1120 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeFloat);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeDouble(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeDouble(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        double a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bd",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 267 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1149 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeDouble);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeString(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bs",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
#line 274 "sip/QtCore/qdatastream.sip"
    Py_BEGIN_ALLOW_THREADS
    *sipCpp << a0;
    Py_END_ALLOW_THREADS
#line 1178 "sipQtCoreQDataStream.cpp"

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeString);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readBytes(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readBytes(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QDataStream,&sipCpp))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

#line 280 "sip/QtCore/qdatastream.sip"
        char *s;
        uint l;
        
        Py_BEGIN_ALLOW_THREADS
        sipCpp->readBytes(s, l);
        Py_END_ALLOW_THREADS
        
        if ((sipRes = PyString_FromStringAndSize(s, l)) == NULL)
            sipIsErr = 1;
        
        if (s)
            delete[] s;
#line 1218 "sipQtCoreQDataStream.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readBytes);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_readRawData(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_readRawData(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        int a0;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bi",&sipSelf,sipClass_QDataStream,&sipCpp,&a0))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

#line 296 "sip/QtCore/qdatastream.sip"
        char *s = new char[a0];
        
        Py_BEGIN_ALLOW_THREADS
        sipCpp->readRawData(s, a0);
        Py_END_ALLOW_THREADS
        
        sipRes = PyString_FromStringAndSize(s, a0);
        
        if (!sipRes)
            sipIsErr = 1;
        
        delete[] s;
#line 1261 "sipQtCoreQDataStream.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_readRawData);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeBytes(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeBytes(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        SIP_SSIZE_T a1;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bk",&sipSelf,sipClass_QDataStream,&sipCpp,&a0,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->writeBytes(a0,(unsigned)a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeBytes);

    return NULL;
}


extern "C" {static PyObject *meth_QDataStream_writeRawData(PyObject *, PyObject *);}
static PyObject *meth_QDataStream_writeRawData(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        SIP_SSIZE_T a1;
        QDataStream *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bk",&sipSelf,sipClass_QDataStream,&sipCpp,&a0,&a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->writeRawData(a0,(int)a1);
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QDataStream,sipNm_QtCore_writeRawData);

    return NULL;
}


extern "C" {static PyObject *slot_QDataStream___lshift__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QDataStream___lshift__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QDataStream * a0;
        QVariant::Type a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAE",sipClass_QDataStream,&a0,sipEnum_QVariant_Type,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QVariant * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QVariant,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QUuid * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QUuid,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QUrl * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QUrl,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QStringList * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QStringList,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QString * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QString,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QSizeF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QSizeF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QSize * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QSize,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QRegExp * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRegExp,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QRectF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRectF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QRect * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRect,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QPointF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QPointF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QPoint * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QPoint,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QLocale * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLocale,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QLineF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLineF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QLine * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLine,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QDateTime * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QDateTime,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QTime * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QTime,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QDate * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QDate,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QChar * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QChar,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QByteArray * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QByteArray,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        const QBitArray * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QBitArray,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,lshift_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static PyObject *slot_QDataStream___rshift__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QDataStream___rshift__(PyObject *sipArg0,PyObject *sipArg1)
{
    int sipArgsParsed = 0;

    {
        QDataStream * a0;
        QVariant::Type a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAE",sipClass_QDataStream,&a0,sipEnum_QVariant_Type,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QVariant * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QVariant,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QUuid * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QUuid,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QUrl * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QUrl,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QStringList * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QStringList,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QString * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QString,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QSizeF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QSizeF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QSize * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QSize,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QRegExp * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRegExp,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QRectF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRectF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QRect * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QRect,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QPointF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QPointF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QPoint * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QPoint,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QLocale * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLocale,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QLineF * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLineF,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QLine * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QLine,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QDateTime * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QDateTime,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QTime * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QTime,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QDate * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QDate,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QChar * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QChar,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QByteArray * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QByteArray,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    {
        QDataStream * a0;
        QBitArray * a1;

        if (sipParsePair(&sipArgsParsed,sipArg0,sipArg1,"JAJA",sipClass_QDataStream,&a0,sipClass_QBitArray,&a1))
        {
            QDataStream *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 >> *a1);
            Py_END_ALLOW_THREADS

            return sipConvertFromInstance(sipRes,sipClass_QDataStream,NULL);
        }
    }

    return sipPySlotExtend(&sipModuleAPI_QtCore,rshift_slot,NULL,sipArg0,sipArg1);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QDataStream(void *, sipWrapperType *);}
static void *cast_QDataStream(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QDataStream)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDataStream(void *, int);}
static void release_QDataStream(void *sipCppV,int state)
{
    Py_BEGIN_ALLOW_THREADS

    if (state & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQDataStream *>(sipCppV);
    else
        delete reinterpret_cast<QDataStream *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QDataStream(sipWrapper *);}
static void dealloc_QDataStream(sipWrapper *sipSelf)
{
    if (sipIsDerived(sipSelf))
        reinterpret_cast<sipQDataStream *>(sipSelf->u.cppPtr)->sipPySelf = NULL;

    if (sipIsPyOwned(sipSelf))
    {
        release_QDataStream(sipSelf->u.cppPtr,sipSelf->flags);
    }
}


extern "C" {static void *init_QDataStream(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QDataStream(sipWrapper *sipSelf,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    sipQDataStream *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQDataStream();
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        QIODevice * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J@",sipClass_QIODevice,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQDataStream(a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (!sipCpp)
    {
        QByteArray * a0;
        QIODevice::OpenMode * a1;
        int a1State = 0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"J@J1",sipClass_QByteArray,&a0,sipClass_QIODevice_OpenMode,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQDataStream(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a1,sipClass_QIODevice_OpenMode,a1State);
        }
    }

    if (!sipCpp)
    {
        const QByteArray * a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"JA",sipClass_QByteArray,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQDataStream(*a0);
            Py_END_ALLOW_THREADS
        }
    }

    if (sipCpp)
        sipCpp->sipPySelf = sipSelf;

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QDataStream(PyObject *, int *);}
static void *forceConvertTo_QDataStream(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QDataStream))
        return sipConvertToCpp(valobj,sipClass_QDataStream,iserrp);

    sipBadClass(sipNm_QtCore_QDataStream);

    *iserrp = 1;

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDataStream[] = {
    {(void *)slot_QDataStream___lshift__, lshift_slot},
    {(void *)slot_QDataStream___rshift__, rshift_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDataStream[] = {
    {sipNm_QtCore_atEnd, meth_QDataStream_atEnd, METH_VARARGS, NULL},
    {sipNm_QtCore_byteOrder, meth_QDataStream_byteOrder, METH_VARARGS, NULL},
    {sipNm_QtCore_device, meth_QDataStream_device, METH_VARARGS, NULL},
    {sipNm_QtCore_readBool, meth_QDataStream_readBool, METH_VARARGS, NULL},
    {sipNm_QtCore_readBytes, meth_QDataStream_readBytes, METH_VARARGS, NULL},
    {sipNm_QtCore_readDouble, meth_QDataStream_readDouble, METH_VARARGS, NULL},
    {sipNm_QtCore_readFloat, meth_QDataStream_readFloat, METH_VARARGS, NULL},
    {sipNm_QtCore_readInt16, meth_QDataStream_readInt16, METH_VARARGS, NULL},
    {sipNm_QtCore_readInt32, meth_QDataStream_readInt32, METH_VARARGS, NULL},
    {sipNm_QtCore_readInt64, meth_QDataStream_readInt64, METH_VARARGS, NULL},
    {sipNm_QtCore_readInt8, meth_QDataStream_readInt8, METH_VARARGS, NULL},
    {sipNm_QtCore_readRawData, meth_QDataStream_readRawData, METH_VARARGS, NULL},
    {sipNm_QtCore_readString, meth_QDataStream_readString, METH_VARARGS, NULL},
    {sipNm_QtCore_readUInt16, meth_QDataStream_readUInt16, METH_VARARGS, NULL},
    {sipNm_QtCore_readUInt32, meth_QDataStream_readUInt32, METH_VARARGS, NULL},
    {sipNm_QtCore_readUInt64, meth_QDataStream_readUInt64, METH_VARARGS, NULL},
    {sipNm_QtCore_readUInt8, meth_QDataStream_readUInt8, METH_VARARGS, NULL},
    {sipNm_QtCore_resetStatus, meth_QDataStream_resetStatus, METH_VARARGS, NULL},
    {sipNm_QtCore_setByteOrder, meth_QDataStream_setByteOrder, METH_VARARGS, NULL},
    {sipNm_QtCore_setDevice, meth_QDataStream_setDevice, METH_VARARGS, NULL},
    {sipNm_QtCore_setStatus, meth_QDataStream_setStatus, METH_VARARGS, NULL},
    {sipNm_QtCore_setVersion, meth_QDataStream_setVersion, METH_VARARGS, NULL},
    {sipNm_QtCore_skipRawData, meth_QDataStream_skipRawData, METH_VARARGS, NULL},
    {sipNm_QtCore_status, meth_QDataStream_status, METH_VARARGS, NULL},
    {sipNm_QtCore_unsetDevice, meth_QDataStream_unsetDevice, METH_VARARGS, NULL},
    {sipNm_QtCore_version, meth_QDataStream_version, METH_VARARGS, NULL},
    {sipNm_QtCore_writeBool, meth_QDataStream_writeBool, METH_VARARGS, NULL},
    {sipNm_QtCore_writeBytes, meth_QDataStream_writeBytes, METH_VARARGS, NULL},
    {sipNm_QtCore_writeDouble, meth_QDataStream_writeDouble, METH_VARARGS, NULL},
    {sipNm_QtCore_writeFloat, meth_QDataStream_writeFloat, METH_VARARGS, NULL},
    {sipNm_QtCore_writeInt16, meth_QDataStream_writeInt16, METH_VARARGS, NULL},
    {sipNm_QtCore_writeInt32, meth_QDataStream_writeInt32, METH_VARARGS, NULL},
    {sipNm_QtCore_writeInt64, meth_QDataStream_writeInt64, METH_VARARGS, NULL},
    {sipNm_QtCore_writeInt8, meth_QDataStream_writeInt8, METH_VARARGS, NULL},
    {sipNm_QtCore_writeRawData, meth_QDataStream_writeRawData, METH_VARARGS, NULL},
    {sipNm_QtCore_writeString, meth_QDataStream_writeString, METH_VARARGS, NULL},
    {sipNm_QtCore_writeUInt16, meth_QDataStream_writeUInt16, METH_VARARGS, NULL},
    {sipNm_QtCore_writeUInt32, meth_QDataStream_writeUInt32, METH_VARARGS, NULL},
    {sipNm_QtCore_writeUInt64, meth_QDataStream_writeUInt64, METH_VARARGS, NULL},
    {sipNm_QtCore_writeUInt8, meth_QDataStream_writeUInt8, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QDataStream[] = {
    {sipNm_QtCore_BigEndian, QDataStream::BigEndian, 59},
    {sipNm_QtCore_LittleEndian, QDataStream::LittleEndian, 59},
    {sipNm_QtCore_Ok, QDataStream::Ok, 58},
    {sipNm_QtCore_Qt_1_0, QDataStream::Qt_1_0, 60},
    {sipNm_QtCore_Qt_2_0, QDataStream::Qt_2_0, 60},
    {sipNm_QtCore_Qt_2_1, QDataStream::Qt_2_1, 60},
    {sipNm_QtCore_Qt_3_0, QDataStream::Qt_3_0, 60},
    {sipNm_QtCore_Qt_3_1, QDataStream::Qt_3_1, 60},
    {sipNm_QtCore_Qt_3_3, QDataStream::Qt_3_3, 60},
    {sipNm_QtCore_Qt_4_0, QDataStream::Qt_4_0, 60},
    {sipNm_QtCore_Qt_4_1, QDataStream::Qt_4_1, 60},
    {sipNm_QtCore_Qt_4_2, QDataStream::Qt_4_2, 60},
    {sipNm_QtCore_Qt_4_3, QDataStream::Qt_4_3, 60},
    {sipNm_QtCore_Qt_4_4, QDataStream::Qt_4_4, 60},
    {sipNm_QtCore_ReadCorruptData, QDataStream::ReadCorruptData, 58},
    {sipNm_QtCore_ReadPastEnd, QDataStream::ReadPastEnd, 58},
};


sipTypeDef sipType_QtCore_QDataStream = {
    0,
    0,
    "QtCore.QDataStream",
    0,
    {0, 0, 1},
    0,
    slots_QDataStream,
    40, methods_QDataStream,
    16, enummembers_QDataStream,
    0,
    init_QDataStream,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QDataStream,
    cast_QDataStream,
    release_QDataStream,
    forceConvertTo_QDataStream,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    0,
    0
};
