/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 44 "sip/QtCore/qcryptographichash.sip"
#include <qcryptographichash.h>
#line 44 "sipQtCoreQCryptographicHash.cpp"

#line 59 "sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 48 "sipQtCoreQCryptographicHash.cpp"


extern "C" {static PyObject *meth_QCryptographicHash_reset(PyObject *, PyObject *);}
static PyObject *meth_QCryptographicHash_reset(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QCryptographicHash *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QCryptographicHash,&sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->reset();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QCryptographicHash,sipNm_QtCore_reset);

    return NULL;
}


extern "C" {static PyObject *meth_QCryptographicHash_addData(PyObject *, PyObject *);}
static PyObject *meth_QCryptographicHash_addData(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const char * a0;
        SIP_SSIZE_T a1;
        QCryptographicHash *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bk",&sipSelf,sipClass_QCryptographicHash,&sipCpp,&a0,&a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->addData(a0,(int)a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QByteArray * a0;
        int a0State = 0;
        QCryptographicHash *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QCryptographicHash,&sipCpp,sipClass_QByteArray,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->addData(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QByteArray *>(a0),sipClass_QByteArray,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QCryptographicHash,sipNm_QtCore_addData);

    return NULL;
}


extern "C" {static PyObject *meth_QCryptographicHash_result(PyObject *, PyObject *);}
static PyObject *meth_QCryptographicHash_result(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QCryptographicHash *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QCryptographicHash,&sipCpp))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(sipCpp->result());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QCryptographicHash,sipNm_QtCore_result);

    return NULL;
}


extern "C" {static PyObject *meth_QCryptographicHash_hash(PyObject *, PyObject *);}
static PyObject *meth_QCryptographicHash_hash(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QByteArray * a0;
        int a0State = 0;
        QCryptographicHash::Algorithm a1;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1E",sipClass_QByteArray,&a0,&a0State,sipEnum_QCryptographicHash_Algorithm,&a1))
        {
            QByteArray *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QByteArray(QCryptographicHash::hash(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QByteArray *>(a0),sipClass_QByteArray,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QByteArray,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QCryptographicHash,sipNm_QtCore_hash);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QCryptographicHash(void *, sipWrapperType *);}
static void *cast_QCryptographicHash(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QCryptographicHash)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QCryptographicHash(void *, int);}
static void release_QCryptographicHash(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QCryptographicHash *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QCryptographicHash(sipWrapper *);}
static void dealloc_QCryptographicHash(sipWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QCryptographicHash(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QCryptographicHash(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QCryptographicHash(sipWrapper *,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    QCryptographicHash *sipCpp = 0;

    if (!sipCpp)
    {
        QCryptographicHash::Algorithm a0;

        if (sipParseArgs(sipArgsParsed,sipArgs,"E",sipEnum_QCryptographicHash_Algorithm,&a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QCryptographicHash(a0);
            Py_END_ALLOW_THREADS
        }
    }

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QCryptographicHash(PyObject *, int *);}
static void *forceConvertTo_QCryptographicHash(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QCryptographicHash))
        return sipConvertToCpp(valobj,sipClass_QCryptographicHash,iserrp);

    sipBadClass(sipNm_QtCore_QCryptographicHash);

    *iserrp = 1;

    return NULL;
}


static PyMethodDef methods_QCryptographicHash[] = {
    {sipNm_QtCore_addData, meth_QCryptographicHash_addData, METH_VARARGS, NULL},
    {sipNm_QtCore_hash, meth_QCryptographicHash_hash, METH_VARARGS, NULL},
    {sipNm_QtCore_reset, meth_QCryptographicHash_reset, METH_VARARGS, NULL},
    {sipNm_QtCore_result, meth_QCryptographicHash_result, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QCryptographicHash[] = {
    {sipNm_QtCore_Md4, QCryptographicHash::Md4, 61},
    {sipNm_QtCore_Md5, QCryptographicHash::Md5, 61},
    {sipNm_QtCore_Sha1, QCryptographicHash::Sha1, 61},
};


sipTypeDef sipType_QtCore_QCryptographicHash = {
    0,
    0,
    "QtCore.QCryptographicHash",
    0,
    {0, 0, 1},
    0,
    0,
    4, methods_QCryptographicHash,
    3, enummembers_QCryptographicHash,
    0,
    init_QCryptographicHash,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QCryptographicHash,
    cast_QCryptographicHash,
    release_QCryptographicHash,
    forceConvertTo_QCryptographicHash,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    0,
    0
};
