/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.7.7 on Fri Oct 30 22:46:27 2009
 *
 * Copyright (c) 2008 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
 * INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
 * granted herein.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 46 "sip/QtCore/qabstractfileengine.sip"
#include <qabstractfileengine.h>
#line 44 "sipQtCoreQAbstractFileEngine.cpp"

#line 46 "sip/QtCore/qfile.sip"
#include <qfile.h>
#line 48 "sipQtCoreQAbstractFileEngine.cpp"
#line 46 "sip/QtCore/qstring.sip"
#include <qstring.h>
#line 51 "sipQtCoreQAbstractFileEngine.cpp"
#line 274 "sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 54 "sipQtCoreQAbstractFileEngine.cpp"
#line 46 "sip/QtCore/qabstractfileengine.sip"
#include <qabstractfileengine.h>
#line 57 "sipQtCoreQAbstractFileEngine.cpp"
#line 46 "sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 60 "sipQtCoreQAbstractFileEngine.cpp"
#line 46 "sip/QtCore/qdir.sip"
#include <qdir.h>
#line 63 "sipQtCoreQAbstractFileEngine.cpp"
#line 46 "sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 66 "sipQtCoreQAbstractFileEngine.cpp"


class sipQAbstractFileEngine : public QAbstractFileEngine
{
public:
    sipQAbstractFileEngine();
    virtual ~sipQAbstractFileEngine();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    void sipProtect_setError(QFile::FileError,const QString&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool open(QIODevice::OpenMode);
    bool close();
    bool flush();
    PY_LONG_LONG size() const;
    PY_LONG_LONG pos() const;
    bool seek(PY_LONG_LONG);
    bool isSequential() const;
    bool remove();
    bool copy(const QString&);
    bool rename(const QString&);
    bool link(const QString&);
    bool mkdir(const QString&,bool) const;
    bool rmdir(const QString&,bool) const;
    bool setSize(PY_LONG_LONG);
    bool caseSensitive() const;
    bool isRelativePath() const;
    QStringList entryList(QDir::Filters,const QStringList&) const;
    QAbstractFileEngine::FileFlags fileFlags(QAbstractFileEngine::FileFlags) const;
    bool setPermissions(unsigned);
    QString fileName(QAbstractFileEngine::FileName) const;
    unsigned ownerId(QAbstractFileEngine::FileOwner) const;
    QString owner(QAbstractFileEngine::FileOwner) const;
    QDateTime fileTime(QAbstractFileEngine::FileTime) const;
    void setFileName(const QString&);
    int handle() const;
    PY_LONG_LONG read(char *,PY_LONG_LONG);
    PY_LONG_LONG readLine(char *,PY_LONG_LONG);
    PY_LONG_LONG write(const char *,PY_LONG_LONG);

public:
    sipWrapper *sipPySelf;

private:
    sipQAbstractFileEngine(const sipQAbstractFileEngine &);
    sipQAbstractFileEngine &operator = (const sipQAbstractFileEngine &);

    sipMethodCache sipPyMethods[28];
};

sipQAbstractFileEngine::sipQAbstractFileEngine(): QAbstractFileEngine(), sipPySelf(0)
{
    sipCommonCtor(sipPyMethods,28);
}

sipQAbstractFileEngine::~sipQAbstractFileEngine()
{
    sipCommonDtor(sipPySelf);
}

bool sipQAbstractFileEngine::open(QIODevice::OpenMode a0)
{
    extern bool sipVH_QtCore_11(sip_gilstate_t,PyObject *,QIODevice::OpenMode);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[0],sipPySelf,NULL,sipNm_QtCore_open);

    if (!meth)
        return QAbstractFileEngine::open(a0);

    return sipVH_QtCore_11(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::close()
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,NULL,sipNm_QtCore_close);

    if (!meth)
        return QAbstractFileEngine::close();

    return sipVH_QtCore_1(sipGILState,meth);
}

bool sipQAbstractFileEngine::flush()
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,NULL,sipNm_QtCore_flush);

    if (!meth)
        return QAbstractFileEngine::flush();

    return sipVH_QtCore_1(sipGILState,meth);
}

PY_LONG_LONG sipQAbstractFileEngine::size() const
{
    extern PY_LONG_LONG sipVH_QtCore_16(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[3]),sipPySelf,NULL,sipNm_QtCore_size);

    if (!meth)
        return QAbstractFileEngine::size();

    return sipVH_QtCore_16(sipGILState,meth);
}

PY_LONG_LONG sipQAbstractFileEngine::pos() const
{
    extern PY_LONG_LONG sipVH_QtCore_16(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[4]),sipPySelf,NULL,sipNm_QtCore_pos);

    if (!meth)
        return QAbstractFileEngine::pos();

    return sipVH_QtCore_16(sipGILState,meth);
}

bool sipQAbstractFileEngine::seek(PY_LONG_LONG a0)
{
    extern bool sipVH_QtCore_28(sip_gilstate_t,PyObject *,PY_LONG_LONG);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,NULL,sipNm_QtCore_seek);

    if (!meth)
        return QAbstractFileEngine::seek(a0);

    return sipVH_QtCore_28(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::isSequential() const
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[6]),sipPySelf,NULL,sipNm_QtCore_isSequential);

    if (!meth)
        return QAbstractFileEngine::isSequential();

    return sipVH_QtCore_1(sipGILState,meth);
}

bool sipQAbstractFileEngine::remove()
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[7],sipPySelf,NULL,sipNm_QtCore_remove);

    if (!meth)
        return QAbstractFileEngine::remove();

    return sipVH_QtCore_1(sipGILState,meth);
}

bool sipQAbstractFileEngine::copy(const QString& a0)
{
    extern bool sipVH_QtCore_24(sip_gilstate_t,PyObject *,const QString&);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,NULL,sipNm_QtCore_copy);

    if (!meth)
        return QAbstractFileEngine::copy(a0);

    return sipVH_QtCore_24(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::rename(const QString& a0)
{
    extern bool sipVH_QtCore_24(sip_gilstate_t,PyObject *,const QString&);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,NULL,sipNm_QtCore_rename);

    if (!meth)
        return QAbstractFileEngine::rename(a0);

    return sipVH_QtCore_24(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::link(const QString& a0)
{
    extern bool sipVH_QtCore_24(sip_gilstate_t,PyObject *,const QString&);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[10],sipPySelf,NULL,sipNm_QtCore_link);

    if (!meth)
        return QAbstractFileEngine::link(a0);

    return sipVH_QtCore_24(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::mkdir(const QString& a0,bool a1) const
{
    extern bool sipVH_QtCore_37(sip_gilstate_t,PyObject *,const QString&,bool);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[11]),sipPySelf,NULL,sipNm_QtCore_mkdir);

    if (!meth)
        return QAbstractFileEngine::mkdir(a0,a1);

    return sipVH_QtCore_37(sipGILState,meth,a0,a1);
}

bool sipQAbstractFileEngine::rmdir(const QString& a0,bool a1) const
{
    extern bool sipVH_QtCore_37(sip_gilstate_t,PyObject *,const QString&,bool);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[12]),sipPySelf,NULL,sipNm_QtCore_rmdir);

    if (!meth)
        return QAbstractFileEngine::rmdir(a0,a1);

    return sipVH_QtCore_37(sipGILState,meth,a0,a1);
}

bool sipQAbstractFileEngine::setSize(PY_LONG_LONG a0)
{
    extern bool sipVH_QtCore_28(sip_gilstate_t,PyObject *,PY_LONG_LONG);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[13],sipPySelf,NULL,sipNm_QtCore_setSize);

    if (!meth)
        return QAbstractFileEngine::setSize(a0);

    return sipVH_QtCore_28(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::caseSensitive() const
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[14]),sipPySelf,NULL,sipNm_QtCore_caseSensitive);

    if (!meth)
        return QAbstractFileEngine::caseSensitive();

    return sipVH_QtCore_1(sipGILState,meth);
}

bool sipQAbstractFileEngine::isRelativePath() const
{
    extern bool sipVH_QtCore_1(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[15]),sipPySelf,NULL,sipNm_QtCore_isRelativePath);

    if (!meth)
        return QAbstractFileEngine::isRelativePath();

    return sipVH_QtCore_1(sipGILState,meth);
}

QStringList sipQAbstractFileEngine::entryList(QDir::Filters a0,const QStringList& a1) const
{
    extern QStringList sipVH_QtCore_36(sip_gilstate_t,PyObject *,QDir::Filters,const QStringList&);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[16]),sipPySelf,NULL,sipNm_QtCore_entryList);

    if (!meth)
        return QAbstractFileEngine::entryList(a0,a1);

    return sipVH_QtCore_36(sipGILState,meth,a0,a1);
}

QAbstractFileEngine::FileFlags sipQAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags a0) const
{
    extern QAbstractFileEngine::FileFlags sipVH_QtCore_35(sip_gilstate_t,PyObject *,QAbstractFileEngine::FileFlags);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[17]),sipPySelf,NULL,sipNm_QtCore_fileFlags);

    if (!meth)
        return QAbstractFileEngine::fileFlags(a0);

    return sipVH_QtCore_35(sipGILState,meth,a0);
}

bool sipQAbstractFileEngine::setPermissions(unsigned a0)
{
    extern bool sipVH_QtCore_34(sip_gilstate_t,PyObject *,unsigned);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[18],sipPySelf,NULL,sipNm_QtCore_setPermissions);

    if (!meth)
        return QAbstractFileEngine::setPermissions(a0);

    return sipVH_QtCore_34(sipGILState,meth,a0);
}

QString sipQAbstractFileEngine::fileName(QAbstractFileEngine::FileName a0) const
{
    extern QString sipVH_QtCore_33(sip_gilstate_t,PyObject *,QAbstractFileEngine::FileName);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[19]),sipPySelf,NULL,sipNm_QtCore_fileName);

    if (!meth)
        return QAbstractFileEngine::fileName(a0);

    return sipVH_QtCore_33(sipGILState,meth,a0);
}

unsigned sipQAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner a0) const
{
    extern unsigned sipVH_QtCore_32(sip_gilstate_t,PyObject *,QAbstractFileEngine::FileOwner);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[20]),sipPySelf,NULL,sipNm_QtCore_ownerId);

    if (!meth)
        return QAbstractFileEngine::ownerId(a0);

    return sipVH_QtCore_32(sipGILState,meth,a0);
}

QString sipQAbstractFileEngine::owner(QAbstractFileEngine::FileOwner a0) const
{
    extern QString sipVH_QtCore_31(sip_gilstate_t,PyObject *,QAbstractFileEngine::FileOwner);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[21]),sipPySelf,NULL,sipNm_QtCore_owner);

    if (!meth)
        return QAbstractFileEngine::owner(a0);

    return sipVH_QtCore_31(sipGILState,meth,a0);
}

QDateTime sipQAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime a0) const
{
    extern QDateTime sipVH_QtCore_30(sip_gilstate_t,PyObject *,QAbstractFileEngine::FileTime);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[22]),sipPySelf,NULL,sipNm_QtCore_fileTime);

    if (!meth)
        return QAbstractFileEngine::fileTime(a0);

    return sipVH_QtCore_30(sipGILState,meth,a0);
}

void sipQAbstractFileEngine::setFileName(const QString& a0)
{
    extern void sipVH_QtCore_29(sip_gilstate_t,PyObject *,const QString&);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[23],sipPySelf,NULL,sipNm_QtCore_setFileName);

    if (!meth)
    {
        QAbstractFileEngine::setFileName(a0);
        return;
    }

    sipVH_QtCore_29(sipGILState,meth,a0);
}

int sipQAbstractFileEngine::handle() const
{
    extern int sipVH_QtCore_8(sip_gilstate_t,PyObject *);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,const_cast<sipMethodCache *>(&sipPyMethods[24]),sipPySelf,NULL,sipNm_QtCore_handle);

    if (!meth)
        return QAbstractFileEngine::handle();

    return sipVH_QtCore_8(sipGILState,meth);
}

PY_LONG_LONG sipQAbstractFileEngine::read(char *a0,PY_LONG_LONG a1)
{
    extern PY_LONG_LONG sipVH_QtCore_61(sip_gilstate_t,PyObject *,char *,PY_LONG_LONG);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[25],sipPySelf,NULL,sipNm_QtCore_read);

    if (!meth)
        return QAbstractFileEngine::read(a0,a1);

    return sipVH_QtCore_61(sipGILState,meth,a0,a1);
}

PY_LONG_LONG sipQAbstractFileEngine::readLine(char *a0,PY_LONG_LONG a1)
{
    extern PY_LONG_LONG sipVH_QtCore_60(sip_gilstate_t,PyObject *,char *,PY_LONG_LONG);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[26],sipPySelf,NULL,sipNm_QtCore_readLine);

    if (!meth)
        return QAbstractFileEngine::readLine(a0,a1);

    return sipVH_QtCore_60(sipGILState,meth,a0,a1);
}

PY_LONG_LONG sipQAbstractFileEngine::write(const char *a0,PY_LONG_LONG a1)
{
    extern PY_LONG_LONG sipVH_QtCore_14(sip_gilstate_t,PyObject *,const char *,PY_LONG_LONG);

    sip_gilstate_t sipGILState;
    PyObject *meth;

    meth = sipIsPyMethod(&sipGILState,&sipPyMethods[27],sipPySelf,NULL,sipNm_QtCore_write);

    if (!meth)
        return QAbstractFileEngine::write(a0,a1);

    return sipVH_QtCore_14(sipGILState,meth,a0,a1);
}

void sipQAbstractFileEngine::sipProtect_setError(QFile::FileError a0,const QString& a1)
{
    QAbstractFileEngine::setError(a0,a1);
}


extern "C" {static PyObject *meth_QAbstractFileEngine_atEnd(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_atEnd(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->atEnd();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_atEnd);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_open(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_open(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QIODevice::OpenMode * a0;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QIODevice_OpenMode,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::open(*a0) : sipCpp->open(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QIODevice_OpenMode,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_open);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_close(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_close(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::close() : sipCpp->close());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_close);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_flush(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_flush(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::flush() : sipCpp->flush());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_flush);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_size(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_size(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            PY_LONG_LONG sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::size() : sipCpp->size());
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_size);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_pos(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_pos(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            PY_LONG_LONG sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::pos() : sipCpp->pos());
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_pos);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_seek(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_seek(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        PY_LONG_LONG a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::seek(a0) : sipCpp->seek(a0));
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_seek);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_isSequential(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_isSequential(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::isSequential() : sipCpp->isSequential());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_isSequential);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_remove(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_remove(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::remove() : sipCpp->remove());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_remove);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_copy(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_copy(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::copy(*a0) : sipCpp->copy(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_copy);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_rename(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_rename(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::rename(*a0) : sipCpp->rename(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_rename);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_link(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_link(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::link(*a0) : sipCpp->link(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_link);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_mkdir(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_mkdir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        bool a1;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1b",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::mkdir(*a0,a1) : sipCpp->mkdir(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_mkdir);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_rmdir(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_rmdir(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        bool a1;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1b",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State,&a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::rmdir(*a0,a1) : sipCpp->rmdir(*a0,a1));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_rmdir);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_setSize(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_setSize(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        PY_LONG_LONG a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::setSize(a0) : sipCpp->setSize(a0));
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_setSize);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_caseSensitive(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_caseSensitive(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::caseSensitive() : sipCpp->caseSensitive());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_caseSensitive);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_isRelativePath(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_isRelativePath(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::isRelativePath() : sipCpp->isRelativePath());
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_isRelativePath);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_entryList(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_entryList(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QDir::Filters * a0;
        int a0State = 0;
        const QStringList * a1;
        int a1State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1J1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QDir_Filters,&a0,&a0State,sipClass_QStringList,&a1,&a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList((sipSelfWasArg ? sipCpp->QAbstractFileEngine::entryList(*a0,*a1) : sipCpp->entryList(*a0,*a1)));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QDir_Filters,a0State);
            sipReleaseInstance(const_cast<QStringList *>(a1),sipClass_QStringList,a1State);

            return sipConvertFromNewInstance(sipRes,sipClass_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_entryList);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_fileFlags(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_fileFlags(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine::FileFlags a0def = QAbstractFileEngine::FileInfoAll;
        QAbstractFileEngine::FileFlags * a0 = &a0def;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|J1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QAbstractFileEngine_FileFlags,&a0,&a0State))
        {
            QAbstractFileEngine::FileFlags *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QAbstractFileEngine::FileFlags((sipSelfWasArg ? sipCpp->QAbstractFileEngine::fileFlags(*a0) : sipCpp->fileFlags(*a0)));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(a0,sipClass_QAbstractFileEngine_FileFlags,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QAbstractFileEngine_FileFlags,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_fileFlags);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_setPermissions(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_setPermissions(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        unsigned a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bu",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::setPermissions(a0) : sipCpp->setPermissions(a0));
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_setPermissions);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_fileName(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_fileName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine::FileName a0 = QAbstractFileEngine::DefaultName;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B|E",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipEnum_QAbstractFileEngine_FileName,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString((sipSelfWasArg ? sipCpp->QAbstractFileEngine::fileName(a0) : sipCpp->fileName(a0)));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_fileName);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_ownerId(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_ownerId(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine::FileOwner a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipEnum_QAbstractFileEngine_FileOwner,&a0))
        {
            unsigned sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::ownerId(a0) : sipCpp->ownerId(a0));
            Py_END_ALLOW_THREADS

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_ownerId);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_owner(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_owner(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine::FileOwner a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipEnum_QAbstractFileEngine_FileOwner,&a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString((sipSelfWasArg ? sipCpp->QAbstractFileEngine::owner(a0) : sipCpp->owner(a0)));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_owner);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_fileTime(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_fileTime(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine::FileTime a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BE",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipEnum_QAbstractFileEngine_FileTime,&a0))
        {
            QDateTime *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QDateTime((sipSelfWasArg ? sipCpp->QAbstractFileEngine::fileTime(a0) : sipCpp->fileTime(a0)));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QDateTime,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_fileTime);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_setFileName(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_setFileName(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const QString * a0;
        int a0State = 0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipClass_QString,&a0,&a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->QAbstractFileEngine::setFileName(*a0) : sipCpp->setFileName(*a0));
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_setFileName);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_handle(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_handle(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::handle() : sipCpp->handle());
            Py_END_ALLOW_THREADS

            return PyInt_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_handle);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_read(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_read(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        PY_LONG_LONG a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

#line 144 "sip/QtCore/qabstractfileengine.sip"
        // Return the data read or None if there was an error.
        if (a0 < 0)
        {
            PyErr_SetString(PyExc_ValueError, "maximum length of data to be read cannot be negative");
            sipIsErr = 1;
        }
        else
        {
            char *s = new char[a0];
            qint64 len;
        
            Py_BEGIN_ALLOW_THREADS
            len = sipSelfWasArg ? sipCpp->QAbstractFileEngine::read(s, a0)
                                : sipCpp->read(s, a0);
            Py_END_ALLOW_THREADS
        
            if (len < 0)
            {
                Py_INCREF(Py_None);
                sipRes = Py_None;
            }
            else
            {
                sipRes = PyString_FromStringAndSize(s, len);
        
                if (!sipRes)
                    sipIsErr = 1;
            }
        
            delete[] s;
        }
#line 1386 "sipQtCoreQAbstractFileEngine.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_read);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_readLine(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_readLine(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        PY_LONG_LONG a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bn",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            PyObject * sipRes = 0;
            int sipIsErr = 0;

#line 206 "sip/QtCore/qabstractfileengine.sip"
        // Return the data read or None if there was an error.
        if (a0 < 0)
        {
            PyErr_SetString(PyExc_ValueError, "maximum length of data to be read cannot be negative");
            sipIsErr = 1;
        }
        else
        {
            char *s = new char[a0];
            qint64 len;
        
            Py_BEGIN_ALLOW_THREADS
            len = sipSelfWasArg ? sipCpp->QAbstractFileEngine::readLine(s, a0)
                                : sipCpp->readLine(s, a0);
            Py_END_ALLOW_THREADS
        
            if (len < 0)
            {
                Py_INCREF(Py_None);
                sipRes = Py_None;
            }
            else
            {
                sipRes = PyString_FromStringAndSize(s, len);
        
                if (!sipRes)
                    sipIsErr = 1;
            }
        
            delete[] s;
        }
#line 1449 "sipQtCoreQAbstractFileEngine.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_readLine);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_write(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_write(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;
    bool sipSelfWasArg = !sipSelf;

    {
        const char * a0;
        SIP_SSIZE_T a1;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bk",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0,&a1))
        {
            PY_LONG_LONG sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->QAbstractFileEngine::write(a0,(PY_LONG_LONG)a1) : sipCpp->write(a0,(PY_LONG_LONG)a1));
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_write);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_error(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_error(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            QFile::FileError sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->error();
            Py_END_ALLOW_THREADS

            return sipConvertFromNamedEnum(sipRes,sipEnum_QFile_FileError);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_error);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_errorString(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_errorString(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"B",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->errorString());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewInstance(sipRes,sipClass_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_errorString);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_create(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_create(PyObject *,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"J1",sipClass_QString,&a0,&a0State))
        {
            QAbstractFileEngine *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = QAbstractFileEngine::create(*a0);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a0),sipClass_QString,a0State);

            return sipConvertFromNewInstance(sipRes,sipClass_QAbstractFileEngine,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_create);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_map(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_map(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        PY_LONG_LONG a0;
        PY_LONG_LONG a1;
        QFile::MemoryMapFlags a2;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"BnnE",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0,&a1,sipEnum_QFile_MemoryMapFlags,&a2))
        {
            void *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->map(a0,a1,a2);
            Py_END_ALLOW_THREADS

            return sipConvertFromVoidPtrAndSize(sipRes,a1);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_map);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_unmap(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_unmap(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        void * a0;
        QAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"Bv",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,&a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->unmap(reinterpret_cast<unsigned char *>(a0));
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_unmap);

    return NULL;
}


extern "C" {static PyObject *meth_QAbstractFileEngine_setError(PyObject *, PyObject *);}
static PyObject *meth_QAbstractFileEngine_setError(PyObject *sipSelf,PyObject *sipArgs)
{
    int sipArgsParsed = 0;

    {
        QFile::FileError a0;
        const QString * a1;
        int a1State = 0;
        sipQAbstractFileEngine *sipCpp;

        if (sipParseArgs(&sipArgsParsed,sipArgs,"pEJ1",&sipSelf,sipClass_QAbstractFileEngine,&sipCpp,sipEnum_QFile_FileError,&a0,sipClass_QString,&a1,&a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtect_setError(a0,*a1);
            Py_END_ALLOW_THREADS

            sipReleaseInstance(const_cast<QString *>(a1),sipClass_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipArgsParsed,sipNm_QtCore_QAbstractFileEngine,sipNm_QtCore_setError);

    return NULL;
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QAbstractFileEngine(void *, sipWrapperType *);}
static void *cast_QAbstractFileEngine(void *ptr,sipWrapperType *targetClass)
{
    if (targetClass == sipClass_QAbstractFileEngine)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QAbstractFileEngine(void *, int);}
static void release_QAbstractFileEngine(void *sipCppV,int state)
{
    Py_BEGIN_ALLOW_THREADS

    if (state & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQAbstractFileEngine *>(sipCppV);
    else
        delete reinterpret_cast<QAbstractFileEngine *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QAbstractFileEngine(sipWrapper *);}
static void dealloc_QAbstractFileEngine(sipWrapper *sipSelf)
{
    if (sipIsDerived(sipSelf))
        reinterpret_cast<sipQAbstractFileEngine *>(sipSelf->u.cppPtr)->sipPySelf = NULL;

    if (sipIsPyOwned(sipSelf))
    {
        release_QAbstractFileEngine(sipSelf->u.cppPtr,sipSelf->flags);
    }
}


extern "C" {static void *init_QAbstractFileEngine(sipWrapper *, PyObject *, sipWrapper **, int *);}
static void *init_QAbstractFileEngine(sipWrapper *sipSelf,PyObject *sipArgs,sipWrapper **,int *sipArgsParsed)
{
    sipQAbstractFileEngine *sipCpp = 0;

    if (!sipCpp)
    {
        if (sipParseArgs(sipArgsParsed,sipArgs,""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipQAbstractFileEngine();
            Py_END_ALLOW_THREADS
        }
    }

    if (sipCpp)
        sipCpp->sipPySelf = sipSelf;

    return sipCpp;
}


extern "C" {static void *forceConvertTo_QAbstractFileEngine(PyObject *, int *);}
static void *forceConvertTo_QAbstractFileEngine(PyObject *valobj,int *iserrp)
{
    if (*iserrp || valobj == NULL)
        return NULL;

    if (valobj == Py_None || sipIsSubClassInstance(valobj,sipClass_QAbstractFileEngine))
        return sipConvertToCpp(valobj,sipClass_QAbstractFileEngine,iserrp);

    sipBadClass(sipNm_QtCore_QAbstractFileEngine);

    *iserrp = 1;

    return NULL;
}


static PyMethodDef methods_QAbstractFileEngine[] = {
    {sipNm_QtCore_atEnd, meth_QAbstractFileEngine_atEnd, METH_VARARGS, NULL},
    {sipNm_QtCore_caseSensitive, meth_QAbstractFileEngine_caseSensitive, METH_VARARGS, NULL},
    {sipNm_QtCore_close, meth_QAbstractFileEngine_close, METH_VARARGS, NULL},
    {sipNm_QtCore_copy, meth_QAbstractFileEngine_copy, METH_VARARGS, NULL},
    {sipNm_QtCore_create, meth_QAbstractFileEngine_create, METH_VARARGS, NULL},
    {sipNm_QtCore_entryList, meth_QAbstractFileEngine_entryList, METH_VARARGS, NULL},
    {sipNm_QtCore_error, meth_QAbstractFileEngine_error, METH_VARARGS, NULL},
    {sipNm_QtCore_errorString, meth_QAbstractFileEngine_errorString, METH_VARARGS, NULL},
    {sipNm_QtCore_fileFlags, meth_QAbstractFileEngine_fileFlags, METH_VARARGS, NULL},
    {sipNm_QtCore_fileName, meth_QAbstractFileEngine_fileName, METH_VARARGS, NULL},
    {sipNm_QtCore_fileTime, meth_QAbstractFileEngine_fileTime, METH_VARARGS, NULL},
    {sipNm_QtCore_flush, meth_QAbstractFileEngine_flush, METH_VARARGS, NULL},
    {sipNm_QtCore_handle, meth_QAbstractFileEngine_handle, METH_VARARGS, NULL},
    {sipNm_QtCore_isRelativePath, meth_QAbstractFileEngine_isRelativePath, METH_VARARGS, NULL},
    {sipNm_QtCore_isSequential, meth_QAbstractFileEngine_isSequential, METH_VARARGS, NULL},
    {sipNm_QtCore_link, meth_QAbstractFileEngine_link, METH_VARARGS, NULL},
    {sipNm_QtCore_map, meth_QAbstractFileEngine_map, METH_VARARGS, NULL},
    {sipNm_QtCore_mkdir, meth_QAbstractFileEngine_mkdir, METH_VARARGS, NULL},
    {sipNm_QtCore_open, meth_QAbstractFileEngine_open, METH_VARARGS, NULL},
    {sipNm_QtCore_owner, meth_QAbstractFileEngine_owner, METH_VARARGS, NULL},
    {sipNm_QtCore_ownerId, meth_QAbstractFileEngine_ownerId, METH_VARARGS, NULL},
    {sipNm_QtCore_pos, meth_QAbstractFileEngine_pos, METH_VARARGS, NULL},
    {sipNm_QtCore_read, meth_QAbstractFileEngine_read, METH_VARARGS, NULL},
    {sipNm_QtCore_readLine, meth_QAbstractFileEngine_readLine, METH_VARARGS, NULL},
    {sipNm_QtCore_remove, meth_QAbstractFileEngine_remove, METH_VARARGS, NULL},
    {sipNm_QtCore_rename, meth_QAbstractFileEngine_rename, METH_VARARGS, NULL},
    {sipNm_QtCore_rmdir, meth_QAbstractFileEngine_rmdir, METH_VARARGS, NULL},
    {sipNm_QtCore_seek, meth_QAbstractFileEngine_seek, METH_VARARGS, NULL},
    {sipNm_QtCore_setError, meth_QAbstractFileEngine_setError, METH_VARARGS, NULL},
    {sipNm_QtCore_setFileName, meth_QAbstractFileEngine_setFileName, METH_VARARGS, NULL},
    {sipNm_QtCore_setPermissions, meth_QAbstractFileEngine_setPermissions, METH_VARARGS, NULL},
    {sipNm_QtCore_setSize, meth_QAbstractFileEngine_setSize, METH_VARARGS, NULL},
    {sipNm_QtCore_size, meth_QAbstractFileEngine_size, METH_VARARGS, NULL},
    {sipNm_QtCore_unmap, meth_QAbstractFileEngine_unmap, METH_VARARGS, NULL},
    {sipNm_QtCore_write, meth_QAbstractFileEngine_write, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QAbstractFileEngine[] = {
    {sipNm_QtCore_AbsoluteName, QAbstractFileEngine::AbsoluteName, 73},
    {sipNm_QtCore_AbsolutePathName, QAbstractFileEngine::AbsolutePathName, 73},
    {sipNm_QtCore_AccessTime, QAbstractFileEngine::AccessTime, 71},
    {sipNm_QtCore_BaseName, QAbstractFileEngine::BaseName, 73},
    {sipNm_QtCore_BundleName, QAbstractFileEngine::BundleName, 73},
    {sipNm_QtCore_BundleType, QAbstractFileEngine::BundleType, 74},
    {sipNm_QtCore_CanonicalName, QAbstractFileEngine::CanonicalName, 73},
    {sipNm_QtCore_CanonicalPathName, QAbstractFileEngine::CanonicalPathName, 73},
    {sipNm_QtCore_CreationTime, QAbstractFileEngine::CreationTime, 71},
    {sipNm_QtCore_DefaultName, QAbstractFileEngine::DefaultName, 73},
    {sipNm_QtCore_DirectoryType, QAbstractFileEngine::DirectoryType, 74},
    {sipNm_QtCore_ExeGroupPerm, QAbstractFileEngine::ExeGroupPerm, 74},
    {sipNm_QtCore_ExeOtherPerm, QAbstractFileEngine::ExeOtherPerm, 74},
    {sipNm_QtCore_ExeOwnerPerm, QAbstractFileEngine::ExeOwnerPerm, 74},
    {sipNm_QtCore_ExeUserPerm, QAbstractFileEngine::ExeUserPerm, 74},
    {sipNm_QtCore_ExistsFlag, QAbstractFileEngine::ExistsFlag, 74},
    {sipNm_QtCore_FileInfoAll, QAbstractFileEngine::FileInfoAll, 74},
    {sipNm_QtCore_FileType, QAbstractFileEngine::FileType, 74},
    {sipNm_QtCore_FlagsMask, QAbstractFileEngine::FlagsMask, 74},
    {sipNm_QtCore_HiddenFlag, QAbstractFileEngine::HiddenFlag, 74},
    {sipNm_QtCore_LinkName, QAbstractFileEngine::LinkName, 73},
    {sipNm_QtCore_LinkType, QAbstractFileEngine::LinkType, 74},
    {sipNm_QtCore_LocalDiskFlag, QAbstractFileEngine::LocalDiskFlag, 74},
    {sipNm_QtCore_ModificationTime, QAbstractFileEngine::ModificationTime, 71},
    {sipNm_QtCore_OwnerGroup, QAbstractFileEngine::OwnerGroup, 72},
    {sipNm_QtCore_OwnerUser, QAbstractFileEngine::OwnerUser, 72},
    {sipNm_QtCore_PathName, QAbstractFileEngine::PathName, 73},
    {sipNm_QtCore_PermsMask, QAbstractFileEngine::PermsMask, 74},
    {sipNm_QtCore_ReadGroupPerm, QAbstractFileEngine::ReadGroupPerm, 74},
    {sipNm_QtCore_ReadOtherPerm, QAbstractFileEngine::ReadOtherPerm, 74},
    {sipNm_QtCore_ReadOwnerPerm, QAbstractFileEngine::ReadOwnerPerm, 74},
    {sipNm_QtCore_ReadUserPerm, QAbstractFileEngine::ReadUserPerm, 74},
    {sipNm_QtCore_Refresh, QAbstractFileEngine::Refresh, 74},
    {sipNm_QtCore_RootFlag, QAbstractFileEngine::RootFlag, 74},
    {sipNm_QtCore_TypesMask, QAbstractFileEngine::TypesMask, 74},
    {sipNm_QtCore_WriteGroupPerm, QAbstractFileEngine::WriteGroupPerm, 74},
    {sipNm_QtCore_WriteOtherPerm, QAbstractFileEngine::WriteOtherPerm, 74},
    {sipNm_QtCore_WriteOwnerPerm, QAbstractFileEngine::WriteOwnerPerm, 74},
    {sipNm_QtCore_WriteUserPerm, QAbstractFileEngine::WriteUserPerm, 74},
};


sipTypeDef sipType_QtCore_QAbstractFileEngine = {
    0,
    0,
    "QtCore.QAbstractFileEngine",
    0,
    {0, 0, 1},
    0,
    0,
    35, methods_QAbstractFileEngine,
    39, enummembers_QAbstractFileEngine,
    0,
    init_QAbstractFileEngine,
    0,
    0,
    0,
    0,
    0,
    0,
    dealloc_QAbstractFileEngine,
    cast_QAbstractFileEngine,
    release_QAbstractFileEngine,
    forceConvertTo_QAbstractFileEngine,
    0,
    0,
    {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    0,
    0,
    0,
    0
};
