/*
 * Interface wrapper code.
 *
 * Generated by SIP snapshot-4.10.3-f760366cea3b on Mon Jul 12 18:06:22 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 39 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qeasingcurve.sip"
#include <qeasingcurve.h>
#line 39 "sipQtCoreQEasingCurve.cpp"

#line 43 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qeasingcurve.sip"
// The EasingFunction callback doesn't provide a context so we support a fixed
// number of different functions.

const int ec_nr_custom_types = 10;

struct ec_custom_type {
    PyObject *py_func;
    QEasingCurve::EasingFunction func;
};

static qreal ec_call(int ec, qreal v);

static qreal ec_func_0(qreal v)
{
    return ec_call(0, v);
}

static qreal ec_func_1(qreal v)
{
    return ec_call(1, v);
}

static qreal ec_func_2(qreal v)
{
    return ec_call(2, v);
}

static qreal ec_func_3(qreal v)
{
    return ec_call(3, v);
}

static qreal ec_func_4(qreal v)
{
    return ec_call(4, v);
}

static qreal ec_func_5(qreal v)
{
    return ec_call(5, v);
}

static qreal ec_func_6(qreal v)
{
    return ec_call(6, v);
}

static qreal ec_func_7(qreal v)
{
    return ec_call(7, v);
}

static qreal ec_func_8(qreal v)
{
    return ec_call(8, v);
}

static qreal ec_func_9(qreal v)
{
    return ec_call(9, v);
}

static ec_custom_type ec_custom_types[ec_nr_custom_types] = {
    {0, ec_func_0},
    {0, ec_func_1},
    {0, ec_func_2},
    {0, ec_func_3},
    {0, ec_func_4},
    {0, ec_func_5},
    {0, ec_func_6},
    {0, ec_func_7},
    {0, ec_func_8},
    {0, ec_func_9},
};

static qreal ec_call(int ec, qreal v)
{
    PyObject *res_obj;
    qreal res = 0.0;

    SIP_BLOCK_THREADS

    res_obj = PyObject_CallFunction(ec_custom_types[ec].py_func, (char *)"(d)", (double)v);

    if (res_obj)
    {
        PyErr_Clear();

        res = PyFloat_AsDouble(res_obj);
        Py_DECREF(res_obj);

        if (PyErr_Occurred())
            res_obj = 0;
    }

    if (!res_obj)
        PyErr_Print();

    SIP_UNBLOCK_THREADS

    return res;
}
#line 144 "sipQtCoreQEasingCurve.cpp"


extern "C" {static PyObject *meth_QEasingCurve_amplitude(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_amplitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->amplitude();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_amplitude, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_setAmplitude(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setAmplitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setAmplitude(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setAmplitude, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_period(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_period(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->period();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_period, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_setPeriod(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setPeriod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPeriod(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setPeriod, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_overshoot(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_overshoot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->overshoot();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_overshoot, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_setOvershoot(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setOvershoot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setOvershoot(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setOvershoot, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_type(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            QEasingCurve::Type sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->type();
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(sipRes,sipType_QEasingCurve_Type);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_type, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_setType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve::Type a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QEasingCurve, &sipCpp, sipType_QEasingCurve_Type, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setType(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setType, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_setCustomType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setCustomType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BF", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            sipErrorState sipError = sipErrorNone;

#line 239 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qeasingcurve.sip"
        int i;
        ec_custom_type *ct;
        
        for (i = 0; i < ec_nr_custom_types; ++i)
        {
            ct = &ec_custom_types[i];
        
            if (!ct->py_func || ct->py_func == a0)
                break;
        }
        
        if (i == ec_nr_custom_types)
        {
            PyErr_Format(PyExc_ValueError, "a maximum of %d different easing functions are supported", ec_nr_custom_types);
            sipError = sipErrorFail;
        }
        else
        {
            if (!ct->py_func)
            {
                ct->py_func = a0;
                Py_INCREF(a0);
            }
        
            sipCpp->setCustomType(ct->func);
        }
#line 403 "sipQtCoreQEasingCurve.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            Py_INCREF(Py_None);
            return Py_None;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setCustomType, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_customType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_customType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            PyObject * sipRes = 0;

#line 269 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qeasingcurve.sip"
        QEasingCurve::EasingFunction func = sipCpp->customType();
        
        sipRes = Py_None;
        
        if (func)
        {
            for (int i = 0; i < ec_nr_custom_types; ++i)
            {
                if (ec_custom_types[i].func == func)
                {
                    sipRes = ec_custom_types[i].py_func;
                    break;
                }
            }
        }
        
        Py_INCREF(sipRes);
#line 455 "sipQtCoreQEasingCurve.cpp"

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_customType, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QEasingCurve_valueForProgress(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_valueForProgress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        qreal a0;
        QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            qreal sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->valueForProgress(a0);
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_valueForProgress, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QEasingCurve___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QEasingCurve___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QEasingCurve *sipCpp = reinterpret_cast<QEasingCurve *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QEasingCurve));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QEasingCurve * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QEasingCurve, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QEasingCurve::operator!=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QEasingCurve *>(a0),sipType_QEasingCurve,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipType_QEasingCurve,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QEasingCurve___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QEasingCurve___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QEasingCurve *sipCpp = reinterpret_cast<QEasingCurve *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QEasingCurve));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QEasingCurve * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QEasingCurve, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QEasingCurve::operator==(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QEasingCurve *>(a0),sipType_QEasingCurve,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipType_QEasingCurve,sipSelf,sipArg);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QEasingCurve(void *, const sipTypeDef *);}
static void *cast_QEasingCurve(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QEasingCurve)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QEasingCurve(void *, int);}
static void release_QEasingCurve(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QEasingCurve *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QEasingCurve(void *, SIP_SSIZE_T, const void *);}
static void assign_QEasingCurve(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QEasingCurve *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QEasingCurve *>(sipSrc);
}


extern "C" {static void *array_QEasingCurve(SIP_SSIZE_T);}
static void *array_QEasingCurve(SIP_SSIZE_T sipNrElem)
{
    return new QEasingCurve[sipNrElem];
}


extern "C" {static void *copy_QEasingCurve(const void *, SIP_SSIZE_T);}
static void *copy_QEasingCurve(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QEasingCurve(reinterpret_cast<const QEasingCurve *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QEasingCurve(sipSimpleWrapper *);}
static void dealloc_QEasingCurve(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QEasingCurve(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QEasingCurve(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QEasingCurve(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QEasingCurve *sipCpp = 0;

    {
        QEasingCurve::Type a0 = QEasingCurve::Linear;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|E", sipType_QEasingCurve_Type, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QEasingCurve(a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QEasingCurve * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QEasingCurve, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QEasingCurve(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QEasingCurve *>(a0),sipType_QEasingCurve,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_QEasingCurve(PyObject *, void **, int *, PyObject *);}
static int convertTo_QEasingCurve(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QEasingCurve **sipCppPtr = reinterpret_cast<QEasingCurve **>(sipCppPtrV);

#line 148 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qeasingcurve.sip"
// Allow a QEasingCurve::Type whenever a QEasingCurve is expected.

if (sipIsErr == NULL)
{
    if (sipCanConvertToType(sipPy, sipType_QEasingCurve, SIP_NO_CONVERTORS))
        return 1;

    if (PyObject_TypeCheck(sipPy, sipTypeAsPyTypeObject(sipType_QEasingCurve_Type)))
        return 1;

    return 0;
}

if (sipCanConvertToType(sipPy, sipType_QEasingCurve, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QEasingCurve *>(sipConvertToType(sipPy, sipType_QEasingCurve, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

*sipCppPtr = new QEasingCurve((QEasingCurve::Type)SIPLong_AsLong(sipPy));

return sipGetState(sipTransferObj);
#line 692 "sipQtCoreQEasingCurve.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QEasingCurve[] = {
    {(void *)slot_QEasingCurve___ne__, ne_slot},
    {(void *)slot_QEasingCurve___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QEasingCurve[] = {
    {SIP_MLNAME_CAST(sipName_amplitude), meth_QEasingCurve_amplitude, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_customType), meth_QEasingCurve_customType, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_overshoot), meth_QEasingCurve_overshoot, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_period), meth_QEasingCurve_period, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setAmplitude), meth_QEasingCurve_setAmplitude, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setCustomType), meth_QEasingCurve_setCustomType, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setOvershoot), meth_QEasingCurve_setOvershoot, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setPeriod), meth_QEasingCurve_setPeriod, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setType), meth_QEasingCurve_setType, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_type), meth_QEasingCurve_type, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_valueForProgress), meth_QEasingCurve_valueForProgress, METH_VARARGS, NULL}
};

static sipEnumMemberDef enummembers_QEasingCurve[] = {
    {sipName_CosineCurve, QEasingCurve::CosineCurve, 55},
    {sipName_Custom, QEasingCurve::Custom, 55},
    {sipName_InBack, QEasingCurve::InBack, 55},
    {sipName_InBounce, QEasingCurve::InBounce, 55},
    {sipName_InCirc, QEasingCurve::InCirc, 55},
    {sipName_InCubic, QEasingCurve::InCubic, 55},
    {sipName_InCurve, QEasingCurve::InCurve, 55},
    {sipName_InElastic, QEasingCurve::InElastic, 55},
    {sipName_InExpo, QEasingCurve::InExpo, 55},
    {sipName_InOutBack, QEasingCurve::InOutBack, 55},
    {sipName_InOutBounce, QEasingCurve::InOutBounce, 55},
    {sipName_InOutCirc, QEasingCurve::InOutCirc, 55},
    {sipName_InOutCubic, QEasingCurve::InOutCubic, 55},
    {sipName_InOutElastic, QEasingCurve::InOutElastic, 55},
    {sipName_InOutExpo, QEasingCurve::InOutExpo, 55},
    {sipName_InOutQuad, QEasingCurve::InOutQuad, 55},
    {sipName_InOutQuart, QEasingCurve::InOutQuart, 55},
    {sipName_InOutQuint, QEasingCurve::InOutQuint, 55},
    {sipName_InOutSine, QEasingCurve::InOutSine, 55},
    {sipName_InQuad, QEasingCurve::InQuad, 55},
    {sipName_InQuart, QEasingCurve::InQuart, 55},
    {sipName_InQuint, QEasingCurve::InQuint, 55},
    {sipName_InSine, QEasingCurve::InSine, 55},
    {sipName_Linear, QEasingCurve::Linear, 55},
    {sipName_OutBack, QEasingCurve::OutBack, 55},
    {sipName_OutBounce, QEasingCurve::OutBounce, 55},
    {sipName_OutCirc, QEasingCurve::OutCirc, 55},
    {sipName_OutCubic, QEasingCurve::OutCubic, 55},
    {sipName_OutCurve, QEasingCurve::OutCurve, 55},
    {sipName_OutElastic, QEasingCurve::OutElastic, 55},
    {sipName_OutExpo, QEasingCurve::OutExpo, 55},
    {sipName_OutInBack, QEasingCurve::OutInBack, 55},
    {sipName_OutInBounce, QEasingCurve::OutInBounce, 55},
    {sipName_OutInCirc, QEasingCurve::OutInCirc, 55},
    {sipName_OutInCubic, QEasingCurve::OutInCubic, 55},
    {sipName_OutInElastic, QEasingCurve::OutInElastic, 55},
    {sipName_OutInExpo, QEasingCurve::OutInExpo, 55},
    {sipName_OutInQuad, QEasingCurve::OutInQuad, 55},
    {sipName_OutInQuart, QEasingCurve::OutInQuart, 55},
    {sipName_OutInQuint, QEasingCurve::OutInQuint, 55},
    {sipName_OutInSine, QEasingCurve::OutInSine, 55},
    {sipName_OutQuad, QEasingCurve::OutQuad, 55},
    {sipName_OutQuart, QEasingCurve::OutQuart, 55},
    {sipName_OutQuint, QEasingCurve::OutQuint, 55},
    {sipName_OutSine, QEasingCurve::OutSine, 55},
    {sipName_SineCurve, QEasingCurve::SineCurve, 55},
};


pyqt4ClassTypeDef sipTypeDef_QtCore_QEasingCurve = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QEasingCurve,
        {0}
    },
    {
        sipNameNr_QEasingCurve,
        {0, 0, 1},
        11, methods_QEasingCurve,
        46, enummembers_QEasingCurve,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QEasingCurve,
    init_QEasingCurve,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QEasingCurve,
    assign_QEasingCurve,
    array_QEasingCurve,
    copy_QEasingCurve,
    release_QEasingCurve,
    cast_QEasingCurve,
    convertTo_QEasingCurve,
    0,
    0
},
    0,
    0,
    0
};
