/*
 * Interface wrapper code.
 *
 * Generated by SIP snapshot-4.10.2-275fa5a54910 on Mon May 17 18:24:22 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 39 "sipQtGuiQPolygon.cpp"

#line 38 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qvector.sip"
#include <qvector.h>
#line 43 "sipQtGuiQPolygon.cpp"
#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 46 "sipQtGuiQPolygon.cpp"
#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 49 "sipQtGuiQPolygon.cpp"
#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 52 "sipQtGuiQPolygon.cpp"
#line 41 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qmatrix.sip"
#include <qmatrix.h>
#line 55 "sipQtGuiQPolygon.cpp"
#line 45 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 58 "sipQtGuiQPolygon.cpp"
#line 40 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 61 "sipQtGuiQPolygon.cpp"
#line 45 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
// Set the points of a polygon from a Python list.
static bool setPointsFromList(QPolygon *poly, PyObject *l)
{
    int *coords = new int[PyList_GET_SIZE(l)];

    for (SIP_SSIZE_T i = 0; i < PyList_GET_SIZE(l); ++i)
    {
        coords[i] = SIPLong_AsLong(PyList_GET_ITEM(l, i));

        if (PyErr_Occurred() != NULL)
        {
            delete[] coords;
            return false;
        }
    }

    poly->setPoints(PyList_GET_SIZE(l) >> 1, coords);

    delete[] coords;
    return true;
}
#line 84 "sipQtGuiQPolygon.cpp"


extern "C" {static PyObject *meth_QPolygon_translate(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_translate, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_boundingRect(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_boundingRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            QRect *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QRect(sipCpp->boundingRect());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QRect,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_boundingRect, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_point(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_point(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->point(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_point, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_setPoints(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoints(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        PyObject * a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BT", &sipSelf, sipType_QPolygon, &sipCpp, &PyList_Type, &a0))
        {
            int sipIsErr = 0;

#line 113 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
        if (!setPointsFromList(sipCpp, a0))
            sipIsErr = 1;
#line 205 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        PyObject * a2;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_firstx,
            sipName_firsty,
            NULL,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiW", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2))
        {
#line 119 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_GET_SIZE(a2) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a0;
        points[1] = a1;
        
        for (SIP_SSIZE_T i = 0; i < PyTuple_GET_SIZE(a2); ++i)
            points[2 + i] = SIPLong_AsLong(PyTuple_GET_ITEM(a2, i));
        
        sipCpp->setPoints(nPoints, points);
        
        delete[] points;
#line 244 "sipQtGuiQPolygon.cpp"

            Py_DECREF(a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_setPoints, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_putPoints(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_putPoints(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        int a2;
        PyObject * a3;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
            sipName_firstx,
            sipName_firsty,
            NULL,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiiW", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2, &a3))
        {
#line 137 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
        // Accept at least one pair of integer coordinates.
        int nPoints = 1 + ((PyTuple_GET_SIZE(a3) + 1) >> 1);
        
        int *points = new int[nPoints * 2];
        
        points[0] = a1;
        points[1] = a2;
        
        for (SIP_SSIZE_T i = 0; i < PyTuple_GET_SIZE(a3); ++i)
            points[2 + i] = SIPLong_AsLong(PyTuple_GET_ITEM(a3, i));
        
        sipCpp->putPoints(a0, nPoints, points);
        
        delete[] points;
#line 296 "sipQtGuiQPolygon.cpp"

            Py_DECREF(a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        const QPolygon * a2;
        int a3 = 0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            NULL,
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiiJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, sipType_QPolygon, &a2, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->putPoints(a0,a1,*a2,a3);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_putPoints, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_setPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_setPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPoint(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        int a2;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setPoint(a0,a1,a2);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_setPoint, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_containsPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_containsPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        Qt::FillRule a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9E", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, sipType_Qt_FillRule, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->containsPoint(*a0,a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_containsPoint, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_united(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_united(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->united(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_united, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_intersected(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_intersected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->intersected(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_intersected, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_subtracted(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_subtracted(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPolygon, &a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->subtracted(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_subtracted, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_translated(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_translated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->translated(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->translated(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_translated, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->append(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_append, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_at(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_at(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->at(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_at, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_clear(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->clear();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_clear, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_contains, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_count(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_count(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count(*a0);
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        QPolygon *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_count, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_data(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            void *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->data();
            Py_END_ALLOW_THREADS

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_data, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        int a1 = -1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->fill(*a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_fill, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_first(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->first();
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_first, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        int a1 = 0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_indexOf, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_insert, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_isEmpty, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_last(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->last();
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_last, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        int a1 = -1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_lastIndexOf, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1 = -1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->mid(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_mid, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_prepend(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_prepend(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9", &sipSelf, sipType_QPolygon, &sipCpp, sipType_QPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->prepend(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_prepend, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_remove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_remove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->remove(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_count,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_QPolygon, &sipCpp, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->remove(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_remove, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->replace(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_replace, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_size(PyObject *, PyObject *);}
static PyObject *meth_QPolygon_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QPolygon *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygon, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->size();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_size, NULL);

    return NULL;
}


extern "C" {static PyObject *meth_QPolygon_value(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygon_value(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_QPolygon, &sipCpp, &a0))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->value(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPoint,NULL);
        }
    }

    {
        int a0;
        const QPoint * a1;
        QPolygon *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_defaultValue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ9", &sipSelf, sipType_QPolygon, &sipCpp, &a0, sipType_QPoint, &a1))
        {
            QPoint *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPoint(sipCpp->value(a0,*a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPoint,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName_value, NULL);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___mul__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QPolygon___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;
        const QMatrix * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QPolygon, &a0, sipType_QMatrix, &a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    {
        const QPolygon * a0;
        const QTransform * a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QPolygon, &a0, sipType_QTransform, &a1))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon((*a0 * *a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,mul_slot,NULL,sipArg0,sipArg1);
}


extern "C" {static int slot_QPolygon___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QPolygon___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        const QPoint * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPoint, &a0))
        {
            int sipRes = 0;

#line 326 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
// It looks like you can't assign QBool to int.
sipRes = bool(sipCpp->contains(*a0));
#line 1247 "sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___contains__, NULL);

    return -1;
}


extern "C" {static int slot_QPolygon___delitem__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QPolygon___delitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            int sipIsErr = 0;

#line 278 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    sipCpp->remove(a0);
#line 1291 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            int sipIsErr = 0;

#line 290 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
    for (i = 0; i < slicelength; ++i)
    {
        sipCpp->remove(start);
        start += step - 1;
    }
#line 1320 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___delitem__, NULL);

    return -1;
}


extern "C" {static int slot_QPolygon___setitem__(PyObject *sipSelf,PyObject *sipArgs);}
static int slot_QPolygon___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QPoint * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iJ9", &a0, sipType_QPoint, &a1))
        {
            int sipIsErr = 0;

#line 235 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    (*sipCpp)[a0] = *a1;
#line 1368 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const QPolygon * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "TJ9", &PySlice_Type, &a0, sipType_QPolygon, &a1))
        {
            int sipIsErr = 0;

#line 247 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
{
    int vlen = a1->count();

    if (vlen != slicelength)
    {
        sipBadLengthForSlice(vlen, slicelength);
        sipIsErr = 1;
    }
    else
    {
        QVector<QPoint>::const_iterator it = a1->begin();

        for (i = 0; i < slicelength; ++i)
        {
            (*sipCpp)[start] = *it;
            start += step;
            ++it;
        }
    }
}
#line 1413 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___setitem__, NULL);

    return -1;
}


extern "C" {static int slot_QPolygon___len__(PyObject *sipSelf);}
static int slot_QPolygon___len__(PyObject *sipSelf)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 230 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
    sipRes = sipCpp->count();
#line 1449 "sipQtGuiQPolygon.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QPolygon___getitem__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            QPoint *sipRes = 0;
            int sipIsErr = 0;

#line 218 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
SIP_SSIZE_T idx = sipConvertFromSequenceIndex(a0, sipCpp->count());

if (idx < 0)
    sipIsErr = 1;
else
    sipRes = new QPoint(sipCpp->operator[]((int)idx));
#line 1482 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_QPoint,NULL);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            QPolygon *sipRes = 0;
            int sipIsErr = 0;

#line 306 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
SIP_SSIZE_T len, start, stop, step, slicelength, i;

len = sipCpp->count();

if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
    sipIsErr = 1;
else
{
    sipRes = new QPolygon();

    for (i = 0; i < slicelength; ++i)
    {
        (*sipRes) += (*sipCpp)[start];
        start += step;
    }
}
#line 1516 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes,sipType_QPolygon,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QPolygon, sipName___getitem__, NULL);

    return 0;
}


extern "C" {static PyObject *slot_QPolygon___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QPolygon::operator==(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,eq_slot,sipType_QPolygon,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QPolygon___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QPolygon::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QPoint * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPoint, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QPolygon::operator+=(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___add__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___add__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            QPolygon *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QPolygon(sipCpp->QPolygon::operator+(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QPolygon,NULL);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,concat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QPolygon___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QPolygon___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPolygon));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QPolygon * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygon, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QPolygon::operator!=(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtGui,ne_slot,sipType_QPolygon,sipSelf,sipArg);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QPolygon(void *, const sipTypeDef *);}
static void *cast_QPolygon(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QPolygon)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QPolygon(void *, int);}
static void release_QPolygon(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QPolygon *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static PyObject *pickle_QPolygon(void *);}
static PyObject *pickle_QPolygon(void *sipCppV)
{
    QPolygon *sipCpp = reinterpret_cast<QPolygon *>(sipCppV);
    PyObject *sipRes;

#line 69 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
    PyObject *pl = PyList_New(sipCpp->count() * 2);
    
    for (int p = 0, i = 0; i < sipCpp->count(); ++i, p += 2)
    {
        int x, y;
    
        sipCpp->point(i, &x, &y);
    
        PyList_SET_ITEM(pl, p, SIPLong_FromLong(x));
        PyList_SET_ITEM(pl, p + 1, SIPLong_FromLong(y));
    }
    
    sipRes = Py_BuildValue((char *)"(N)", pl);
#line 1725 "sipQtGuiQPolygon.cpp"

    return sipRes;
}


extern "C" {static void assign_QPolygon(void *, SIP_SSIZE_T, const void *);}
static void assign_QPolygon(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QPolygon *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QPolygon *>(sipSrc);
}


extern "C" {static void *array_QPolygon(SIP_SSIZE_T);}
static void *array_QPolygon(SIP_SSIZE_T sipNrElem)
{
    return new QPolygon[sipNrElem];
}


extern "C" {static void *copy_QPolygon(const void *, SIP_SSIZE_T);}
static void *copy_QPolygon(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QPolygon(reinterpret_cast<const QPolygon *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPolygon(sipSimpleWrapper *);}
static void dealloc_QPolygon(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QPolygon(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QPolygon(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QPolygon(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QPolygon *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QPolygon * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J9", sipType_QPolygon, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QVector<QPoint> * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QVector_0100QPoint,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector<QPoint> *>(a0),sipType_QVector_0100QPoint,a0State);

            return sipCpp;
        }
    }

    {
        const QRect * a0;
        bool a1 = 0;

        static const char *sipKwdList[] = {
            NULL,
            sipName_closed,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|b", sipType_QRect, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(*a0,a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        int a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "i", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QPolygon(a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        PyObject * a0;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "T", &PyList_Type, &a0))
        {
            int sipIsErr = 0;

#line 93 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
        sipCpp = new QPolygon();
        
        if (!setPointsFromList(sipCpp, a0))
        {
            delete sipCpp;
            sipCpp = 0;
            sipIsErr = 1;
        }
#line 1858 "sipQtGuiQPolygon.cpp"

            if (sipIsErr)
            {
                Py_XDECREF(*sipUnused);
                sipAddException(sipErrorFail, sipParseErr);
                return NULL;
            }

            return sipCpp;
        }
    }

    {
        const QVariant * a0;
        int a0State = 0;

        static const char *sipKwdList[] = {
            sipName_variant,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_QVariant,&a0, &a0State))
        {
#line 105 "/home/maemo/python-qt4-experimental-4.7.3/sip/QtGui/qpolygon.sip"
        sipCpp = new QPolygon(qVariantValue<QPolygon>(*a0));
#line 1883 "sipQtGuiQPolygon.cpp"
            sipReleaseType(const_cast<QVariant *>(a0),sipType_QVariant,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPolygon[] = {
    {(void *)slot_QPolygon___mul__, mul_slot},
    {(void *)slot_QPolygon___contains__, contains_slot},
    {(void *)slot_QPolygon___delitem__, delitem_slot},
    {(void *)slot_QPolygon___setitem__, setitem_slot},
    {(void *)slot_QPolygon___len__, len_slot},
    {(void *)slot_QPolygon___getitem__, getitem_slot},
    {(void *)slot_QPolygon___eq__, eq_slot},
    {(void *)slot_QPolygon___iadd__, iconcat_slot},
    {(void *)slot_QPolygon___add__, concat_slot},
    {(void *)slot_QPolygon___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPolygon[] = {
    {SIP_MLNAME_CAST(sipName_append), (PyCFunction)meth_QPolygon_append, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_at), (PyCFunction)meth_QPolygon_at, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_boundingRect), meth_QPolygon_boundingRect, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_clear), meth_QPolygon_clear, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_contains), (PyCFunction)meth_QPolygon_contains, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_containsPoint), meth_QPolygon_containsPoint, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_count), (PyCFunction)meth_QPolygon_count, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_data), meth_QPolygon_data, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_fill), (PyCFunction)meth_QPolygon_fill, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_first), meth_QPolygon_first, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_indexOf), (PyCFunction)meth_QPolygon_indexOf, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_insert), (PyCFunction)meth_QPolygon_insert, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_intersected), meth_QPolygon_intersected, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_isEmpty), meth_QPolygon_isEmpty, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_last), meth_QPolygon_last, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_lastIndexOf), (PyCFunction)meth_QPolygon_lastIndexOf, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_mid), (PyCFunction)meth_QPolygon_mid, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_point), meth_QPolygon_point, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_prepend), (PyCFunction)meth_QPolygon_prepend, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_putPoints), (PyCFunction)meth_QPolygon_putPoints, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_remove), (PyCFunction)meth_QPolygon_remove, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_replace), (PyCFunction)meth_QPolygon_replace, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_setPoint), meth_QPolygon_setPoint, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_setPoints), (PyCFunction)meth_QPolygon_setPoints, METH_VARARGS|METH_KEYWORDS, NULL},
    {SIP_MLNAME_CAST(sipName_size), meth_QPolygon_size, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_subtracted), meth_QPolygon_subtracted, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_translate), meth_QPolygon_translate, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_translated), meth_QPolygon_translated, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_united), meth_QPolygon_united, METH_VARARGS, NULL},
    {SIP_MLNAME_CAST(sipName_value), (PyCFunction)meth_QPolygon_value, METH_VARARGS|METH_KEYWORDS, NULL}
};


pyqt4ClassTypeDef sipTypeDef_QtGui_QPolygon = {
{
    {
        -1,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QPolygon,
        {0}
    },
    {
        sipNameNr_QPolygon,
        {0, 0, 1},
        30, methods_QPolygon,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QPolygon,
    init_QPolygon,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QPolygon,
    assign_QPolygon,
    array_QPolygon,
    copy_QPolygon,
    release_QPolygon,
    cast_QPolygon,
    0,
    0,
    pickle_QPolygon
},
    0,
    0,
    0
};
