
import unittest

import mafw
import gobject

WANTED_SOURCE = 'Mafw-Tracker-Source'
test_source = None

def dummy(*args):
    pass

class BrowseArguments(unittest.TestCase):

    def setUp(self):
        self.source = test_source

    def test_filter_as_string(self):
        self.source.browse('aaaa', 'myfilter', dummy)

    def test_filter_wrong(self):
        self.assertRaises(TypeError, self.source.browse, 'aaaa', 44, dummy)

    def test_callback_wrong(self):
        self.assertRaises(TypeError, self.source.browse, 'aaaa', 'aaa', 'callback')

class BrowseMetadataKeysArgument(unittest.TestCase):

    def setUp(self):
        self.source = test_source

    def testValid(self):
        self.source.browse('aa', 'filter', dummy, keys=[])
        self.source.browse('aa', 'filter', dummy, keys=['aaaa'])
        self.source.browse('aa', 'filter', dummy, keys=['aaaa'])

    def testInvalid(self):
        self.assertRaises(TypeError, self.source.browse, 'aa', 'filter', dummy, keys=33)
        self.assertRaises(TypeError, self.source.browse, 'aa', 'filter', dummy, keys='aaaa')
        self.assertRaises(TypeError, self.source.browse, 'aa', 'filter', dummy, keys=['aaaa', 42])


def source_added_cb(registry, source, data=None):
    global test_source
    mainloop = data
    if source.get_name() == WANTED_SOURCE:
        test_source = source
        mainloop.quit()

def setup_sources():
    mainloop = gobject.MainLoop()
    registry = mafw.Registry.get_instance()
    mafw.mafw_shared_init(registry)

    registry.connect('source_added', source_added_cb, mainloop)
    mainloop.run()

if __name__ == '__main__':
    setup_sources()
    unittest.main()
