import unittest

import gtk
import hildon

class TestHildonButton(unittest.TestCase):
    def test_constructor(self):
        self.assertRaises(TypeError, hildon.Button)
        b = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.assertTrue(isinstance(b, hildon.Button))
        b = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "title")
        self.assertTrue(isinstance(b, hildon.Button))
        b = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "title", "value")
        self.assertTrue(isinstance(b, hildon.Button))

    def test_set_value(self):
        #Bug MB#11340
        b = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        b.set_value('test')
        self.assertTrue(b.get_value() == 'test')
        b.set_value(None)
        self.assertTrue(b.get_value() == '')

if __name__ == "__main__":
    unittest.main()
