#!/usr/bin/env python

# Copyright (c) 2006 Damien Miller <djm@mindrot.org>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: test.py,v 1.3 2007/05/03 23:36:36 djm Exp $

import editdist
import unittest
import random

test_vectors = (
	( 'abc',	'abc',		0 ),
	( 'abc',	'ab',		1 ),
	( 'abc',	'abcd',		1 ),
	( 'abc',	'bc',		1 ),
	( 'abc',	'a', 		2 ),
	( 'abc',	'', 		3 ),
	( '',		'',		0 ),
	( 'abc',	'acx',		2 ),
	( 'abc',	'acxx',		3 ),
	( 'abc',	'bcd',		2 ),
	( 'a' * 1000,	'a' * 1000,	0 ),
	( 'a' * 1000,	'b' * 1000,	1000),
)

def randstring(l):
	a = "abcdefghijklmnopqrstuvwxyz"
	r = ""
	for i in range(0, l):
		r += a[random.randint(0, len(a) - 1)]
	return r
	
class TestRadix(unittest.TestCase):
	def test_00__test_vectors(self):
		for a, b, score in test_vectors:
			self.assertEqual(editdist.distance(a, b), score)

	def test_01__reversed_test_vectors(self):
		for b, a, score in test_vectors:
			self.assertEqual(editdist.distance(a, b), score)

	def test_02__fuzz(self):
		for i in range(0, 32) + range(128, 1024, 128):
			for j in range(0, 32):
				a = randstring(i)
				b = randstring(j)
				dist = editdist.distance(a, b)
				self.assert_(dist >= 0)

def main():
	unittest.main()

if __name__ == '__main__':
	main()
